/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class PointSelectionPage
extends WizardPage
implements ISelectionChangedListener {
    private TableViewer pointListViewer;
    private TableViewer pluginListViewer;
    private IPluginBase pluginBase;
    private Text pointIdText;
    private Text pointNameText;
    private Label description;
    private Button descriptionButton;
    private Button filterCheck;
    private IPluginExtensionPoint currentPoint;
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_LISTS_WIDTH = 250;
    private static final String KEY_TITLE = "NewExtensionWizard.PointSelectionPage.title";
    private static final String KEY_POINT_ID = "NewExtensionWizard.PointSelectionPage.pointId";
    private static final String KEY_POINT_NAME = "NewExtensionWizard.PointSelectionPage.pointName";
    private static final String KEY_DESC = "NewExtensionWizard.PointSelectionPage.desc";
    private static final String KEY_MISSING_TITLE = "NewExtensionWizard.PointSelectionPage.missingTitle";
    private static final String KEY_MISSING_IMPORT = "NewExtensionWizard.PointSelectionPage.missingImport";
    private static final String KEY_FILTER_CHECK = "NewExtensionWizard.PointSelectionPage.filterCheck";
    private static final String KEY_DESC_BUTTON = "NewExtensionWizard.PointSelectionPage.descButton";
    private static final String KEY_WARNING = "NewExtensionWizard.PointSelectionPage.warning";
    private IPluginExtension newExtension;
    private ShowDescriptionAction showDescriptionAction;

    public PointSelectionPage(IPluginBase model) {
        super("pointSelectionPage");
        this.pluginBase = model;
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        provider.connect((Object)this);
    }

    void addPoints(IPluginBase pluginBase, Vector points) {
        IPluginExtensionPoint[] pts = pluginBase.getExtensionPoints();
        int i = 0;
        while (i < pts.length) {
            IPluginExtensionPoint pt = pts[i];
            boolean fromDependency = this.isFromDependency(pt);
            points.addElement(new ExPoint(pt, fromDependency));
            ++i;
        }
        if (pluginBase instanceof IPlugin && pluginBase.getModel().getUnderlyingResource() != null) {
            WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
            IFragment[] fragments = manager.getFragmentsFor(pluginBase.getId(), pluginBase.getVersion());
            int i2 = 0;
            while (i2 < fragments.length) {
                this.addPoints((IPluginBase)fragments[i2], points);
                ++i2;
            }
        }
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(272));
        this.filterCheck = new Button(outerContainer, 32);
        this.filterCheck.setText(PDEPlugin.getResourceString(KEY_FILTER_CHECK));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.filterCheck.setLayoutData((Object)gd);
        this.filterCheck.setSelection(true);
        this.filterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointSelectionPage.this.pointListViewer.refresh();
            }
        });
        this.pointListViewer = new TableViewer(outerContainer, 2816);
        this.pointListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.pointListViewer.setLabelProvider((IBaseLabelProvider)new PointLabelProvider());
        this.pointListViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.pointListViewer.setSorter(ListUtil.NAME_SORTER);
        gd = new GridData(1808);
        gd.heightHint = 300;
        gd.horizontalSpan = 2;
        this.pointListViewer.getTable().setLayoutData((Object)gd);
        this.descriptionButton = new Button(outerContainer, 8);
        this.descriptionButton.setText(PDEPlugin.getResourceString(KEY_DESC_BUTTON));
        gd = new GridData(2);
        this.descriptionButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.descriptionButton);
        this.descriptionButton.setEnabled(false);
        this.descriptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointSelectionPage.this.doShowDescription();
            }
        });
        Label label = new Label(outerContainer, 0);
        label.setText(PDEPlugin.getResourceString(KEY_POINT_ID));
        this.pointIdText = new Text(outerContainer, 2052);
        gd = new GridData(768);
        this.pointIdText.setLayoutData((Object)gd);
        new Label(outerContainer, 0);
        label = new Label(outerContainer, 0);
        label.setText(PDEPlugin.getResourceString(KEY_POINT_NAME));
        this.pointNameText = new Text(outerContainer, 2052);
        gd = new GridData(768);
        this.pointNameText.setLayoutData((Object)gd);
        new Label(outerContainer, 0);
        this.createDescriptionIn(outerContainer);
        this.initialize();
        this.setControl((Control)outerContainer);
        Dialog.applyDialogFont((Control)outerContainer);
        WorkbenchHelp.setHelp((Control)outerContainer, (String)"org.eclipse.pde.doc.user.add_extensions_schema_based");
    }

    public boolean canFinish() {
        IStructuredSelection ssel;
        ISelection selection;
        return this.pointListViewer != null && (selection = this.pointListViewer.getSelection()) instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty();
    }

    public void createDescriptionIn(Composite composite) {
        this.description = new Label(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.description.setLayoutData((Object)gd);
    }

    public void dispose() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        provider.disconnect((Object)this);
        super.dispose();
    }

    public boolean finish() {
        String name;
        String id = this.pointIdText.getText();
        if (id.length() == 0) {
            id = null;
        }
        if ((name = this.pointNameText.getText()).length() == 0) {
            name = null;
        }
        String point = this.currentPoint.getFullId();
        try {
            if (!this.ensureImportExists(this.currentPoint)) {
                return false;
            }
            IPluginExtension extension = this.pluginBase.getModel().getFactory().createExtension();
            extension.setName(name);
            extension.setPoint(point);
            if (id != null) {
                extension.setId(id);
            }
            this.pluginBase.add(extension);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return true;
    }

    private void doShowDescription() {
        if (this.showDescriptionAction == null) {
            this.showDescriptionAction = new ShowDescriptionAction(this.currentPoint);
        } else {
            this.showDescriptionAction.setExtensionPoint(this.currentPoint);
        }
        BusyIndicator.showWhile((Display)this.descriptionButton.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                PointSelectionPage.this.showDescriptionAction.run();
            }
        });
    }

    private boolean isFromDependency(IPluginExtensionPoint point) {
        IPlugin thisPlugin = this.getTargetPlugin(this.pluginBase);
        IPlugin exPlugin = this.getTargetPlugin(point.getPluginBase());
        if (thisPlugin == null || exPlugin == null) {
            return true;
        }
        String exId = exPlugin.getId();
        if (exId.equals(thisPlugin.getId())) {
            return true;
        }
        if (exId.equals("org.eclipse.core.boot") || exId.equals("org.eclipse.core.runtime")) {
            return true;
        }
        IPluginImport[] iimports = thisPlugin.getImports();
        int i = 0;
        while (i < iimports.length) {
            IPluginImport iimport = iimports[i];
            if (iimport.getId().equals(exId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean ensureImportExists(IPluginExtensionPoint point) throws CoreException {
        if (this.isFromDependency(point)) {
            return true;
        }
        IPlugin exPlugin = this.getTargetPlugin(point.getPluginBase());
        if (exPlugin == null) {
            return true;
        }
        String[] args = new String[]{point.getResourceString(point.getName()), exPlugin.getResourceString(exPlugin.getName())};
        String message = PDEPlugin.getFormattedMessage(KEY_MISSING_IMPORT, args);
        MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(KEY_MISSING_TITLE), (String)message);
        return false;
    }

    private IPlugin getTargetPlugin(IPluginBase base) {
        if (base instanceof IPlugin) {
            return (IPlugin)base;
        }
        IFragment fragment = (IFragment)base;
        String targetId = fragment.getPluginId();
        String targetVersion = fragment.getPluginVersion();
        int match = fragment.getRule();
        return PDECore.getDefault().findPlugin(targetId, targetVersion, match);
    }

    public IPluginExtension getNewExtension() {
        return this.newExtension;
    }

    protected void initialize() {
        this.pointListViewer.addFilter((ViewerFilter)new PointFilter());
        this.pointListViewer.setInput((Object)PDECore.getDefault().getExternalModelManager());
        this.pointListViewer.getTable().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection ssel;
        Iterator elements;
        ISelection selection = event.getSelection();
        ExPoint input = null;
        if (selection instanceof IStructuredSelection && (elements = (ssel = (IStructuredSelection)selection).iterator()).hasNext()) {
            input = (ExPoint)elements.next();
            if (elements.hasNext()) {
                input = null;
            }
        }
        boolean fromDependency = input != null && input.isFromDependency();
        this.setPageComplete(input != null && fromDependency);
        this.descriptionButton.setEnabled(input != null);
        String message = null;
        if (!fromDependency) {
            message = PDEPlugin.getResourceString(KEY_WARNING);
        }
        this.setMessage(message, 2);
        this.currentPoint = input != null ? input.getPoint() : null;
        String description = "";
        if (this.currentPoint != null) {
            description = this.currentPoint.getFullId();
        }
        this.setDescriptionText(description);
        this.getContainer().updateButtons();
    }

    public void setDescriptionText(String text) {
        this.description.setText(text);
    }

    class PointFilter
    extends ViewerFilter {
        PointFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!PointSelectionPage.this.filterCheck.getSelection()) {
                return true;
            }
            ExPoint ep = (ExPoint)element;
            return ep.isFromDependency();
        }
    }

    class ExPoint {
        boolean fromDependency;
        IPluginExtensionPoint point;

        public ExPoint(IPluginExtensionPoint point, boolean fromDependency) {
            this.point = point;
            this.fromDependency = fromDependency;
        }

        public IPluginExtensionPoint getPoint() {
            return this.point;
        }

        public boolean isFromDependency() {
            return this.fromDependency;
        }
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        private Vector points = null;

        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof ExternalModelManager) {
                if (this.points == null) {
                    this.points = new Vector();
                    WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
                    this.addPoints(manager.getWorkspacePluginModels());
                    ExternalModelManager registry = (ExternalModelManager)parent;
                    this.addPoints(registry.getModels());
                }
                Object[] result = new Object[this.points.size()];
                this.points.copyInto(result);
                return result;
            }
            return new Object[0];
        }

        private void addPoints(IPluginModel[] models) {
            int i = 0;
            while (i < models.length) {
                IPluginModel model = models[i];
                if (model.isEnabled()) {
                    IPlugin pluginInfo = model.getPlugin();
                    PointSelectionPage.this.addPoints((IPluginBase)pluginInfo, this.points);
                }
                ++i;
            }
        }
    }

    class PointLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PointLabelProvider() {
        }

        public String getText(Object obj) {
            return this.getColumnText(obj, 0);
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ExPoint) {
                PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
                IPluginExtensionPoint point = ((ExPoint)obj).getPoint();
                if (provider.isFullNameModeEnabled()) {
                    return provider.getText(point);
                }
                return point.getFullId();
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            return this.getColumnImage(obj, 0);
        }

        public Image getColumnImage(Object obj, int index) {
            ExPoint exp = (ExPoint)obj;
            int flag = exp.isFromDependency() ? 0 : 2;
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXT_POINT_OBJ, flag);
        }
    }
}

