/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionMainPage;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionRegistryReader;

public class NewExtensionWizard
extends NewWizard {
    public static final String PLUGIN_POINT = "newExtension";
    public static final String STATUS_MESSAGE = "NewExtensionWizard.statusMessage";
    private static final String KEY_WTITLE = "NewExtensionWizard.wtitle";
    private NewExtensionMainPage mainPage;
    private IPluginModelBase model;
    private IProject project;

    public NewExtensionWizard(IProject project, IPluginModelBase model) {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEX_WIZ);
        this.model = model;
        this.project = project;
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void addPages() {
        this.mainPage = new NewExtensionMainPage(this.project, this.model, this.getAvailableExtensionCategories(), PDEPlugin.getResourceString(STATUS_MESSAGE));
        this.addPage((IWizardPage)this.mainPage);
    }

    public WizardCollectionElement getAvailableExtensionCategories() {
        NewExtensionRegistryReader reader = new NewExtensionRegistryReader();
        return (WizardCollectionElement)reader.readRegistry(PDEPlugin.getPluginId(), PLUGIN_POINT, false);
    }

    public boolean performFinish() {
        return true;
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }
}

