/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.FragmentBuildScriptGenerator;
import org.eclipse.pde.internal.build.PluginBuildScriptGenerator;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.PluginExportWizardPage;

public class PluginExportWizard
extends BaseExportWizard {
    private static final String KEY_WTITLE = "ExportWizard.Plugin.wtitle";
    private static final String STORE_SECTION = "PluginExportWizard";

    public PluginExportWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN_EXPORT_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
    }

    protected BaseExportWizardPage createPage1() {
        return new PluginExportWizardPage(this.getSelection());
    }

    protected HashMap createProperties(String destination, boolean exportZip) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("build.result.folder", String.valueOf(this.buildTempLocation) + '/' + "build_result");
        map.put("temp.folder", String.valueOf(this.buildTempLocation) + '/' + "eclipse" + '/' + "plugins");
        map.put("destination.temp.folder", String.valueOf(this.buildTempLocation) + '/' + "eclipse" + '/' + "plugins");
        map.put("plugin.destination", destination);
        return map;
    }

    protected void doExport(boolean exportZip, boolean exportSource, String destination, String zipFileName, IModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        IPluginModelBase modelBase = (IPluginModelBase)model;
        try {
            String label = PDEPlugin.getDefault().getLabelProvider().getObjectText(modelBase.getPluginBase());
            monitor.setTaskName(String.valueOf(PDEPlugin.getResourceString("ExportWizard.exporting")) + " " + label);
            monitor.beginTask("", 10);
            this.makeScript(modelBase);
            monitor.worked(1);
            this.runScript(modelBase.getInstallLocation(), destination, exportZip, exportSource, (IProgressMonitor)new SubProgressMonitor(monitor, 9));
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.deleteBuildFile(modelBase);
            monitor.done();
            throw throwable;
        }
        Object var9_11 = null;
        this.deleteBuildFile(modelBase);
        monitor.done();
    }

    public void deleteBuildFile(IPluginModelBase model) {
        String fileName = MainPreferencePage.getBuildScriptName();
        File file = new File(String.valueOf(model.getInstallLocation()) + '/' + fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    private void makeScript(IPluginModelBase model) throws CoreException {
        Object generator = null;
        generator = model.isFragmentModel() ? new FragmentBuildScriptGenerator() : new PluginBuildScriptGenerator();
        generator.setBuildScriptName(MainPreferencePage.getBuildScriptName());
        generator.setScriptTargetLocation(model.getInstallLocation());
        generator.setInstallLocation(model.getInstallLocation());
        IProject project = model.getUnderlyingResource().getProject();
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IPath path = JavaCore.create((IProject)project).getOutputLocation().removeFirstSegments(1);
            generator.setDevEntries(new String[]{path.toOSString()});
        } else {
            generator.setDevEntries(new String[]{"bin"});
        }
        generator.setPluginPath(TargetPlatform.createPluginPath());
        generator.setModelId(model.getPluginBase().getId());
        generator.generate();
    }
}

