/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.ExportFeatureBuildScriptGenerator;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureExportWizardPage;

public class FeatureExportWizard
extends BaseExportWizard {
    private static final String KEY_WTITLE = "ExportWizard.Feature.wtitle";
    private static final String STORE_SECTION = "FeatureExportWizard";

    public FeatureExportWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_FEATURE_EXPORT_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
    }

    protected BaseExportWizardPage createPage1() {
        return new FeatureExportWizardPage(this.getSelection());
    }

    protected HashMap createProperties(String destination, boolean exportZip) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("build.result.folder", String.valueOf(this.buildTempLocation) + '/' + "build_result");
        map.put("temp.folder", String.valueOf(this.buildTempLocation) + '/' + "eclipse");
        map.put("feature.temp.folder", String.valueOf(this.buildTempLocation) + '/' + "eclipse");
        if (exportZip) {
            map.put("plugin.destination", destination);
            map.put("feature.destination", destination);
        } else {
            String dest = destination;
            File file = new File(destination, "plugins");
            file.mkdirs();
            if (file.exists()) {
                dest = file.getAbsolutePath();
            }
            map.put("plugin.destination", dest);
            dest = destination;
            file = new File(destination, "features");
            file.mkdirs();
            if (file.exists()) {
                dest = file.getAbsolutePath();
            }
            map.put("feature.destination", dest);
        }
        return map;
    }

    protected void doExport(boolean exportZip, boolean exportSource, String destination, String zipFileName, IModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        IFeatureModel feature = (IFeatureModel)model;
        String label = PDEPlugin.getDefault().getLabelProvider().getObjectText(feature);
        monitor.beginTask("", 10);
        monitor.setTaskName(String.valueOf(PDEPlugin.getResourceString("ExportWizard.exporting")) + " " + label);
        try {
            this.makeScript(feature);
            monitor.worked(1);
            this.runScript(feature.getInstallLocation(), destination, exportZip, exportSource, (IProgressMonitor)new SubProgressMonitor(monitor, 9));
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.deleteBuildFiles(feature);
            monitor.done();
            throw throwable;
        }
        Object var9_11 = null;
        this.deleteBuildFiles(feature);
        monitor.done();
    }

    private void deleteBuildFiles(IFeatureModel model) {
        this.deleteBuildFile((IModel)model);
        IFeaturePlugin[] plugins = model.getFeature().getPlugins();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        int i = 0;
        while (i < plugins.length) {
            ModelEntry entry = manager.findEntry(plugins[i].getId(), plugins[i].getVersion());
            if (entry != null) {
                this.deleteBuildFile((IModel)entry.getActiveModel());
            }
            ++i;
        }
    }

    public void deleteBuildFile(IModel model) {
        String scriptName = MainPreferencePage.getBuildScriptName();
        String filename = "";
        filename = model instanceof IFeatureModel ? String.valueOf(((IFeatureModel)model).getInstallLocation()) + '/' + scriptName : String.valueOf(((IPluginModelBase)model).getInstallLocation()) + '/' + scriptName;
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        }
    }

    public IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    private void makeScript(IFeatureModel model) throws CoreException {
        ExportFeatureBuildScriptGenerator generator = new ExportFeatureBuildScriptGenerator();
        generator.setBuildScriptName(MainPreferencePage.getBuildScriptName());
        generator.setScriptTargetLocation(model.getInstallLocation());
        generator.setFeatureRootLocation(model.getInstallLocation());
        generator.setInstallLocation(model.getInstallLocation());
        IProject project = model.getUnderlyingResource().getProject();
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IPath path = JavaCore.create((IProject)project).getOutputLocation().removeFirstSegments(1);
            generator.setDevEntries(new String[]{path.toOSString()});
        } else {
            generator.setDevEntries(new String[]{"bin"});
        }
        generator.setGenerateChildrenScript(true);
        generator.setPluginPath(TargetPlatform.createPluginPath());
        generator.setFeature(model.getFeature().getId());
        generator.generate();
    }

    protected String[] getExecutionTargets(boolean exportZip, boolean exportSource) {
        ArrayList<String> targets = new ArrayList<String>();
        if (!exportZip) {
            targets.add("build.update.jar");
        } else {
            targets.add("build.jars");
            targets.add("zip.distribution");
            if (exportSource) {
                targets.add("build.sources");
                targets.add("zip.sources");
            }
        }
        return targets.toArray(new String[targets.size()]);
    }
}

