/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class BaseExportWizardPage
extends WizardPage {
    private String S_EXPORT_UPDATE = "exportUpdate";
    private String S_DESTINATION = "destination";
    private String S_EXPORT_SOURCE = "exportSource";
    private String S_ZIP_FILENAME = "zipFileName";
    private IStructuredSelection selection;
    private Combo destination;
    private Combo zipFile;
    protected ExportPart exportPart;
    protected boolean featureExport;
    private Button zipRadio;
    private Button updateRadio;
    private Button browseDirectory;
    private Button includeSource;
    private Label directoryLabel;
    private Button browseFile;
    private Label label;

    public BaseExportWizardPage(IStructuredSelection selection, String name, String choiceLabel, boolean featureExport) {
        super(name);
        this.selection = selection;
        this.featureExport = featureExport;
        this.exportPart = new ExportPart(choiceLabel);
        this.setDescription(PDEPlugin.getResourceString("ExportWizard.Plugin.description"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        this.exportPart.createControl(container);
        GridData gd = (GridData)this.exportPart.getControl().getLayoutData();
        gd.heightHint = 125;
        gd.widthHint = 150;
        gd.horizontalSpan = 2;
        this.createLabel(container, "", 2);
        this.createLabel(container, PDEPlugin.getResourceString(this.featureExport ? "ExportWizard.Feature.label" : "ExportWizard.Plugin.label"), 2);
        this.createZipSection(container);
        this.createUpdateJarsSection(container);
        this.initializeList();
        this.loadSettings();
        this.pageChanged();
        this.hookListeners();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        this.hookHelpContext((Control)container);
    }

    protected void createUpdateJarsSection(Composite container) {
        this.updateRadio = this.createRadioButton(container, PDEPlugin.getResourceString("ExportWizard.Plugin.updateJars"));
        this.directoryLabel = new Label(container, 0);
        this.directoryLabel.setText(PDEPlugin.getResourceString("ExportWizard.destination"));
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        this.directoryLabel.setLayoutData((Object)gd);
        this.destination = new Combo(container, 2048);
        gd = new GridData(768);
        this.destination.setLayoutData((Object)gd);
        this.browseDirectory = new Button(container, 8);
        this.browseDirectory.setText(PDEPlugin.getResourceString("ExportWizard.browse"));
        this.browseDirectory.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.browseDirectory);
    }

    protected void createZipSection(Composite container) {
        this.zipRadio = this.createRadioButton(container, PDEPlugin.getResourceString("ExportWizard.Plugin.zip"));
        this.label = new Label(container, 0);
        this.label.setText(PDEPlugin.getResourceString("ExportWizard.zipFile"));
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        this.label.setLayoutData((Object)gd);
        this.zipFile = new Combo(container, 2048);
        gd = new GridData(768);
        this.zipFile.setLayoutData((Object)gd);
        this.browseFile = new Button(container, 8);
        this.browseFile.setText(PDEPlugin.getResourceString("ExportWizard.browse"));
        this.browseFile.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.browseFile);
        this.includeSource = new Button(container, 32);
        this.includeSource.setText(PDEPlugin.getResourceString("ExportWizard.includeSource"));
        this.includeSource.setSelection(true);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalIndent = 25;
        this.includeSource.setLayoutData((Object)gd);
    }

    protected void hookListeners() {
        this.browseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.doBrowseFile();
            }
        });
        this.zipFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.zipFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.destination.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.destination.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.browseDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.doBrowseDirectory();
            }
        });
        this.updateRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = BaseExportWizardPage.this.updateRadio.getSelection();
                BaseExportWizardPage.this.enableZipSection(!enabled);
                BaseExportWizardPage.this.enableUpdateJarsSection(enabled);
                BaseExportWizardPage.this.pageChanged();
            }
        });
    }

    private void doBrowseFile() {
        IPath path = this.chooseFile();
        if (path != null) {
            this.zipFile.setText(path.toOSString());
        }
    }

    private IPath chooseFile() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFileName(this.zipFile.getText());
        dialog.setFilterExtensions(new String[]{"*.zip"});
        dialog.setText(PDEPlugin.getResourceString("ExportWizard.filedialog.title"));
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    protected void enableZipSection(boolean enabled) {
        this.label.setEnabled(enabled);
        this.zipFile.setEnabled(enabled);
        this.browseFile.setEnabled(enabled);
        this.includeSource.setEnabled(enabled);
    }

    protected void enableUpdateJarsSection(boolean enabled) {
        this.directoryLabel.setEnabled(enabled);
        this.destination.setEnabled(enabled);
        this.browseDirectory.setEnabled(enabled);
    }

    protected void createLabel(Composite container, String text, int span) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
    }

    protected Button createRadioButton(Composite container, String text) {
        Button button = new Button(container, 16);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalIndent = 0;
        button.setLayoutData((Object)gd);
        return button;
    }

    protected abstract Object[] getListElements();

    protected void initializeList() {
        CheckboxTableViewer viewer = this.exportPart.getTableViewer();
        viewer.setContentProvider((IContentProvider)new ExportListProvider());
        viewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        viewer.setSorter(ListUtil.PLUGIN_SORTER);
        this.exportPart.getTableViewer().setInput((Object)PDECore.getDefault().getWorkspaceModelManager());
        this.checkSelected();
    }

    private void doBrowseDirectory() {
        IPath result = this.chooseDestination();
        if (result != null) {
            this.destination.setText(result.toOSString());
        }
    }

    private IPath chooseDestination() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.destination.getText());
        dialog.setText(PDEPlugin.getResourceString("ExportWizard.dialog.title"));
        dialog.setMessage(PDEPlugin.getResourceString("ExportWizard.dialog.message"));
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    protected void checkSelected() {
        Object[] elems = this.selection.toArray();
        ArrayList<IModel> checked = new ArrayList<IModel>(elems.length);
        int i = 0;
        while (i < elems.length) {
            IModel model;
            Object elem = elems[i];
            IProject project = null;
            if (elem instanceof IFile) {
                IFile file = (IFile)elem;
                project = file.getProject();
            } else if (elem instanceof IProject) {
                project = (IProject)elem;
            } else if (elem instanceof IJavaProject) {
                project = ((IJavaProject)elem).getProject();
            }
            if (project != null && (model = this.findModelFor(project)) != null) {
                checked.add(model);
            }
            ++i;
        }
        this.exportPart.setSelection(checked.toArray());
    }

    protected IModel findModelFor(IProject project) {
        WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        return manager.getWorkspaceModel(project);
    }

    protected void pageChanged() {
        boolean hasSel;
        boolean hasDestination = false;
        String message = null;
        if (this.zipRadio != null && !this.zipRadio.isDisposed() && this.zipRadio.getSelection()) {
            boolean bl = hasDestination = this.zipFile.getText().length() > 0;
            if (!hasDestination) {
                message = PDEPlugin.getResourceString("ExportWizard.status.nofile");
            }
        } else {
            boolean bl = hasDestination = this.getDestination().length() > 0;
            if (!hasDestination) {
                message = PDEPlugin.getResourceString("ExportWizard.status.nodirectory");
            }
        }
        boolean bl = hasSel = this.exportPart.getSelectionCount() > 0;
        if (!hasSel) {
            message = PDEPlugin.getResourceString("ExportWizard.status.noselection");
        }
        this.setMessage(message);
        this.setPageComplete(hasSel && hasDestination);
    }

    protected void loadSettings() {
        String curr;
        IDialogSettings settings = this.getDialogSettings();
        boolean exportUpdate = settings.getBoolean(this.S_EXPORT_UPDATE);
        this.zipRadio.setSelection(!exportUpdate);
        this.updateRadio.setSelection(exportUpdate);
        this.enableZipSection(!this.updateRadio.getSelection());
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < 6) {
            curr = settings.get(String.valueOf(this.S_DESTINATION) + String.valueOf(i));
            if (curr != null && !items.contains(curr)) {
                items.add(curr);
            }
            ++i;
        }
        this.destination.setItems(items.toArray(new String[items.size()]));
        this.includeSource.setSelection(settings.getBoolean(this.S_EXPORT_SOURCE));
        this.enableUpdateJarsSection(!this.zipRadio.getSelection());
        items.clear();
        i = 0;
        while (i < 6) {
            curr = settings.get(String.valueOf(this.S_ZIP_FILENAME) + String.valueOf(i));
            if (curr != null && !items.contains(curr)) {
                items.add(curr);
            }
            ++i;
        }
        this.zipFile.setItems(items.toArray(new String[items.size()]));
    }

    public void saveSettings() {
        int i;
        int nEntries;
        String[] items;
        IDialogSettings settings = this.getDialogSettings();
        settings.put(this.S_EXPORT_UPDATE, this.updateRadio.getSelection());
        settings.put(this.S_EXPORT_SOURCE, this.includeSource.getSelection());
        if (this.destination.getText().length() > 0) {
            settings.put(String.valueOf(this.S_DESTINATION) + String.valueOf(0), this.destination.getText());
            items = this.destination.getItems();
            nEntries = Math.min(items.length, 5);
            i = 0;
            while (i < nEntries) {
                settings.put(String.valueOf(this.S_DESTINATION) + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
        if (this.zipFile.getText().length() > 0) {
            settings.put(String.valueOf(this.S_ZIP_FILENAME) + String.valueOf(0), this.zipFile.getText());
            items = this.zipFile.getItems();
            nEntries = Math.min(items.length, 5);
            i = 0;
            while (i < nEntries) {
                settings.put(String.valueOf(this.S_ZIP_FILENAME) + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
    }

    public Object[] getSelectedItems() {
        return this.exportPart.getSelection();
    }

    public boolean getExportZip() {
        return this.zipRadio.getSelection();
    }

    public boolean getExportSource() {
        if (this.includeSource == null) {
            return false;
        }
        return this.includeSource.getSelection();
    }

    public String getFileName() {
        String path;
        if (this.zipRadio.getSelection() && (path = this.zipFile.getText()) != null && path.length() > 0) {
            String fileName = new Path(path).lastSegment();
            if (!fileName.endsWith(".zip")) {
                fileName = String.valueOf(fileName) + ".zip";
            }
            return fileName;
        }
        return null;
    }

    public String getDestination() {
        if (this.zipRadio != null && this.zipRadio.getSelection()) {
            String path = this.zipFile.getText();
            if (path != null && path.length() > 0) {
                return new Path(path).removeLastSegments(1).toOSString();
            }
            return "";
        }
        if (this.destination == null || this.destination.isDisposed()) {
            return "";
        }
        return this.destination.getText();
    }

    protected abstract void hookHelpContext(Control var1);

    class ExportListProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ExportListProvider() {
        }

        public Object[] getElements(Object parent) {
            return BaseExportWizardPage.this.getListElements();
        }
    }

    class ExportPart
    extends WizardCheckboxTablePart {
        public ExportPart(String label) {
            super(label);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            BaseExportWizardPage.this.pageChanged();
        }
    }
}

