/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public abstract class BaseExportWizard
extends Wizard
implements IExportWizard {
    private IStructuredSelection selection;
    private BaseExportWizardPage page1;
    protected static PrintWriter writer;
    protected static File logFile;
    protected String buildTempLocation;

    public BaseExportWizard() {
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.buildTempLocation = PDEPlugin.getDefault().getStateLocation().append("temp").toOSString();
    }

    private static void createLogWriter() {
        try {
            String path = PDEPlugin.getDefault().getStateLocation().addTrailingSeparator().toOSString();
            logFile = new File(String.valueOf(path) + "exportLog.txt");
            if (logFile.exists()) {
                logFile.delete();
                logFile.createNewFile();
            }
            writer = new PrintWriter((Writer)new FileWriter(logFile), true);
        }
        catch (IOException iOException) {}
    }

    public static PrintWriter getWriter() {
        if (writer == null) {
            BaseExportWizard.createLogWriter();
        }
        return writer;
    }

    public void addPages() {
        this.page1 = this.createPage1();
        this.addPage((IWizardPage)this.page1);
    }

    protected abstract BaseExportWizardPage createPage1();

    protected abstract HashMap createProperties(String var1, boolean var2);

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    protected abstract void doExport(boolean var1, boolean var2, String var3, String var4, IModel var5, IProgressMonitor var6) throws CoreException, InvocationTargetException;

    protected void doPerformFinish(boolean exportZip, boolean exportSource, String destination, String zipFileName, Object[] items, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        File file = new File(destination);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            throw new InvocationTargetException(new Exception(PDEPlugin.getResourceString("ExportWizard.badDirectory")));
        }
        monitor.beginTask("", items.length + 1);
        new ArrayList();
        int i = 0;
        while (i < items.length) {
            IModel model = (IModel)items[i];
            this.doExport(exportZip, exportSource, destination, zipFileName, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i;
        }
        this.cleanup(zipFileName, destination, this.createProperties(destination, exportZip), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected abstract IDialogSettings getSettingsSection(IDialogSettings var1);

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        File zipFile;
        this.page1.saveSettings();
        final boolean exportZip = this.page1.getExportZip();
        final boolean exportSource = this.page1.getExportSource();
        final String destination = this.page1.getDestination();
        final String zipFileName = this.page1.getFileName();
        final Object[] items = this.page1.getSelectedItems();
        if (zipFileName != null && (zipFile = new File(destination, zipFileName)).exists()) {
            if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)this.getWindowTitle(), (String)PDEPlugin.getResourceString("ExportWizard.zipFileExists"))) {
                return false;
            }
            zipFile.delete();
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    BaseExportWizard.this.doPerformFinish(exportZip, exportSource, destination, zipFileName, items, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            try {
                BaseExportWizard.createLogWriter();
                this.getContainer().run(true, false, op);
            }
            catch (InterruptedException interruptedException) {
                Object var9_7 = null;
                if (writer != null) {
                    writer.close();
                }
                return false;
            }
            catch (InvocationTargetException e) {
                String message = e.getTargetException().getMessage();
                if (message != null && message.length() > 0) {
                    MessageDialog.openError((Shell)this.getShell(), (String)this.getWindowTitle(), (String)e.getTargetException().getMessage());
                }
                Object var9_8 = null;
                if (writer != null) {
                    writer.close();
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (writer != null) {
                writer.close();
            }
            throw throwable;
        }
        Object var9_10 = null;
        if (writer != null) {
            writer.close();
        }
        if (logFile != null && logFile.exists() && logFile.length() > 0L) {
            if (MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)this.getWindowTitle(), (String)PDEPlugin.getResourceString("ExportWizard.error.message"))) {
                Program.launch((String)logFile.getAbsolutePath());
            }
            return false;
        }
        return true;
    }

    protected void cleanup(String filename, String destination, HashMap properties, IProgressMonitor monitor) {
        try {
            String path = PDEPlugin.getDefault().getStateLocation().addTrailingSeparator().toOSString();
            File zip = new File(String.valueOf(path) + "zip.xml");
            if (zip.exists()) {
                zip.delete();
                zip.createNewFile();
            }
            writer = new PrintWriter((Writer)new FileWriter(zip), true);
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<project name=\"temp\" default=\"clean\" basedir=\".\">");
            writer.println("<target name=\"clean\">");
            writer.println("<delete dir=\"" + this.buildTempLocation + "\"/>");
            writer.println("</target>");
            if (filename != null) {
                writer.println("<target name=\"zip.folder\">");
                writer.println("<delete dir=\"${build.result.folder}\"/>");
                writer.println("<zip zipfile=\"" + destination + "/" + filename + "\" basedir=\"" + this.buildTempLocation + "\" filesonly=\"true\" update=\"no\" excludes=\"**/*.bin.log\"/>");
                writer.println("<delete dir=\"" + this.buildTempLocation + "\"/>");
                writer.println("</target>");
            }
            writer.println("</project>");
            writer.close();
            AntRunner runner = new AntRunner();
            runner.addUserProperties((Map)properties);
            runner.setBuildFileLocation(zip.getAbsolutePath());
            if (filename != null) {
                runner.setExecutionTargets(new String[]{"zip.folder"});
            }
            runner.run(monitor);
            zip.delete();
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    protected void runScript(String location, String destination, boolean exportZip, boolean exportSource, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        AntRunner runner = new AntRunner();
        runner.addUserProperties((Map)this.createProperties(destination, exportZip));
        runner.setAntHome(location);
        runner.setBuildFileLocation(String.valueOf(location) + '/' + MainPreferencePage.getBuildScriptName());
        runner.addBuildListener("org.eclipse.pde.internal.ui.ant.ExportBuildListener");
        runner.setExecutionTargets(this.getExecutionTargets(exportZip, exportSource));
        runner.run(monitor);
    }

    protected String[] getExecutionTargets(boolean exportZip, boolean exportSource) {
        ArrayList<String> targets = new ArrayList<String>();
        if (!exportZip) {
            targets.add("build.update.jar");
        } else {
            targets.add("build.jars");
            targets.add("gather.bin.parts");
            if (exportSource) {
                targets.add("build.sources");
                targets.add("gather.sources");
            }
        }
        return targets.toArray(new String[targets.size()]);
    }
}

