/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.pde.internal.ui.elements.ElementLabelProvider;
import org.eclipse.pde.internal.ui.elements.ListContentProvider;
import org.eclipse.pde.internal.ui.elements.TreeContentProvider;
import org.eclipse.pde.internal.ui.wizards.BaseWizardSelectionPage;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionSorter;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;

public abstract class WizardTreeSelectionPage
extends BaseWizardSelectionPage
implements ISelectionChangedListener {
    private TreeViewer categoryTreeViewer;
    private String baseCategory;
    private TableViewer wizardSelectionViewer;
    private static final int SIZING_LISTS_HEIGHT = 150;
    private static final int SIZING_DESC_HEIGHT = 100;
    private static final int SIZING_LISTS_WIDTH = 150;
    private WizardCollectionElement wizardCategories;

    public WizardTreeSelectionPage(WizardCollectionElement categories, String baseCategory, String message) {
        super("NewExtension", message);
        this.wizardCategories = categories;
        this.baseCategory = baseCategory;
    }

    public void advanceToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(272));
        Tree tree = new Tree(outerContainer, 2048);
        this.categoryTreeViewer = new TreeViewer(tree);
        this.categoryTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.categoryTreeViewer.setLabelProvider((IBaseLabelProvider)ElementLabelProvider.INSTANCE);
        this.categoryTreeViewer.setSorter((ViewerSorter)new WizardCollectionSorter(this.baseCategory));
        this.categoryTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 150;
        tree.setLayoutData((Object)gd);
        Table table = new Table(outerContainer, 2048);
        new TableColumn(table, 0);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tlayout);
        this.wizardSelectionViewer = new TableViewer(table);
        this.wizardSelectionViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)ListUtil.TABLE_LABEL_PROVIDER);
        this.wizardSelectionViewer.setSorter(ListUtil.NAME_SORTER);
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.wizardSelectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BusyIndicator.showWhile((Display)WizardTreeSelectionPage.this.wizardSelectionViewer.getControl().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$0(this.this$1).selectionChanged(new SelectionChangedEvent((ISelectionProvider)WizardTreeSelectionPage.access$0(1.access$0(this.this$1)), WizardTreeSelectionPage.access$0(1.access$0(this.this$1)).getSelection()));
                        1.access$0(this.this$1).advanceToNextPage();
                    }
                });
            }

            static /* synthetic */ WizardTreeSelectionPage access$0(1 var0) {
                return var0.WizardTreeSelectionPage.this;
            }
        });
        gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 150;
        table.setLayoutData((Object)gd);
        Composite descriptionComposite = new Composite(outerContainer, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        descriptionComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.heightHint = 100;
        descriptionComposite.setLayoutData((Object)data);
        this.createDescriptionIn(descriptionComposite);
        this.initializeViewers();
        this.setControl((Control)outerContainer);
    }

    protected Object getSingleSelection(IStructuredSelection selection) {
        Object selectedObject = selection.getFirstElement();
        if (selection.size() > 1) {
            selectedObject = null;
        }
        return selectedObject;
    }

    private void handleCategorySelection(SelectionChangedEvent selectionEvent) {
        this.setErrorMessage(null);
        this.setDescriptionText("");
        this.setSelectedNode(null);
        WizardCollectionElement selectedCategory = (WizardCollectionElement)this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection());
        if (selectedCategory == null) {
            this.wizardSelectionViewer.setInput(null);
        } else {
            this.wizardSelectionViewer.setInput((Object)selectedCategory.getWizards());
        }
    }

    private void handleWizardSelection(SelectionChangedEvent selectionEvent) {
        this.setErrorMessage(null);
        WizardElement currentSelection = (WizardElement)this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection());
        if (currentSelection == null) {
            this.setDescriptionText("");
            this.setSelectedNode(null);
            return;
        }
        WizardElement finalSelection = currentSelection;
        this.setSelectedNode(this.createWizardNode(finalSelection));
        this.setDescriptionText(finalSelection.getDescription());
    }

    protected void initializeViewers() {
        this.categoryTreeViewer.setInput((Object)this.wizardCategories);
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.categoryTreeViewer.getTree().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent selectionEvent) {
        if (selectionEvent.getSelectionProvider().equals(this.categoryTreeViewer)) {
            this.handleCategorySelection(selectionEvent);
        } else {
            this.handleWizardSelection(selectionEvent);
        }
    }

    public void setSelectedNode(IWizardNode node) {
        super.setSelectedNode(node);
    }
}

