/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.elements.ElementLabelProvider;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.swt.graphics.Image;

public class ListUtil {
    public static final ViewerSorter NAME_SORTER = new NameSorter();
    public static final ViewerSorter PLUGIN_SORTER = new PluginSorter();
    public static final ViewerSorter FEATURE_SORTER = new FeatureSorter();
    public static final ILabelProvider TABLE_LABEL_PROVIDER = new TableLabelProvider();

    static class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }

        public boolean isSorterProperty(Object element, Object propertyId) {
            return propertyId.equals("org.eclipse.jface.text");
        }
    }

    static class FeatureSorter
    extends NameSorter {
        FeatureSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IFeatureModel && e2 instanceof IFeatureModel) {
                IFeature feature1 = ((IFeatureModel)e1).getFeature();
                IFeature feature2 = ((IFeatureModel)e2).getFeature();
                int result = this.collator.compare(feature1.getId(), feature2.getId());
                if (result != 0) {
                    return result;
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    public static class PluginSorter
    extends NameSorter {
        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = 0;
            String name1 = this.getName(e1);
            String name2 = this.getName(e2);
            if (name1 != null && name2 != null) {
                result = this.collator.compare(name1, name2);
            }
            return result != 0 ? result : super.compare(viewer, e1, e2);
        }

        private String getName(Object object) {
            if (object instanceof IPluginBase) {
                return this.getPluginName((IPluginBase)object);
            }
            if (object instanceof IPluginModelBase) {
                return this.getPluginName(((IPluginModelBase)object).getPluginBase());
            }
            if (object instanceof ModelEntry) {
                return this.getPluginName(((ModelEntry)object).getActiveModel().getPluginBase());
            }
            return null;
        }

        private String getPluginName(IPluginBase pluginBase) {
            return MainPreferencePage.isFullNameModeEnabled() ? pluginBase.getTranslatedName() : pluginBase.getId();
        }
    }

    static class TableLabelProvider
    extends ElementLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object o, int index) {
            return this.getText(o);
        }

        public Image getColumnImage(Object o, int index) {
            return this.getImage(o);
        }
    }
}

