/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.builders.SchemaTransformer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;

public class ShowDescriptionAction
extends Action {
    private String pointId;
    private ISchema schema;
    private File previewFile;

    public ShowDescriptionAction(IPluginExtensionPoint point) {
        this.setExtensionPoint(point);
    }

    public ShowDescriptionAction(ISchema schema) {
        this.setSchema(schema);
    }

    public void setSchema(ISchema schema) {
        this.schema = schema;
        this.pointId = schema.getQualifiedPointId();
    }

    public void setExtensionPoint(IPluginExtensionPoint point) {
        this.pointId = point.getFullId();
        this.setText(PDEPlugin.getResourceString("ShowDescriptionAction.label"));
        this.schema = null;
    }

    public void run() {
        if (this.schema == null) {
            SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
            this.schema = registry.getSchema(this.pointId);
            if (this.schema == null) {
                this.showNoSchemaMessage();
                return;
            }
        }
        this.showSchemaDocument();
    }

    private void showNoSchemaMessage() {
        String title = "Extension Point Description";
        String message = "Description for extension point \"" + this.pointId + "\" cannot be found.";
        MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }

    private void showSchemaDocument() {
        try {
            if (this.previewFile == null) {
                this.previewFile = this.getPreviewFile();
                if (this.previewFile == null) {
                    return;
                }
            }
            SchemaTransformer transformer = new SchemaTransformer();
            FileOutputStream os = new FileOutputStream(this.previewFile);
            PrintWriter printWriter = new PrintWriter(os, true);
            transformer.transform(printWriter, this.schema);
            os.flush();
            ((OutputStream)os).close();
            this.showURL(this.previewFile.getPath());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private File getPreviewFile() throws CoreException {
        String prefix = "pde";
        String suffix = ".html";
        File file = PDECore.getDefault().getTempFileManager().createTempFile((Object)this, prefix, suffix);
        return file;
    }

    private void showURL(String url) {
        boolean win32 = SWT.getPlatform().equals("win32");
        if (win32) {
            Program.launch((String)url);
        } else {
            IBrowser browser = BrowserManager.getInstance().createBrowser();
            try {
                browser.displayURL(url);
            }
            catch (Exception exception) {}
        }
    }
}

