/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.JavaSearchCollector;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

class JavaSearchOperation
extends WorkspaceModifyOperation {
    IJavaElement element;
    IProject parentProject;
    private static final String KEY_MATCH = "Search.singleMatch";
    private static final String KEY_MATCHES = "Search.multipleMatches";

    public JavaSearchOperation(IJavaElement element, IProject parentProject) {
        this.element = element;
        this.parentProject = parentProject;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.doJavaSearch(monitor);
    }

    private void doJavaSearch(IProgressMonitor monitor) {
        try {
            SearchEngine searchEngine = new SearchEngine();
            searchEngine.search(PDEPlugin.getWorkspace(), this.element, 2, this.getSearchScope(), (IJavaSearchResultCollector)new JavaSearchCollector(this, monitor));
        }
        catch (JavaModelException javaModelException) {}
    }

    private IJavaSearchScope getSearchScope() throws JavaModelException {
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)this.parentProject).getPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> filteredRoots = new ArrayList<IPackageFragmentRoot>();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getResource() != null && roots[i].getResource().getProject().equals((Object)this.parentProject)) {
                filteredRoots.add(roots[i]);
            }
            ++i;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])filteredRoots.toArray(new IJavaElement[filteredRoots.size()]));
    }

    public String getPluralLabel() {
        return String.valueOf(this.element.getElementName()) + " - {0} " + PDEPlugin.getResourceString(KEY_MATCHES);
    }

    public String getSingularLabel() {
        return String.valueOf(this.element.getElementName()) + " - 1 " + PDEPlugin.getResourceString(KEY_MATCH);
    }
}

