/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.DependencyExtentSearchResultCollector;
import org.eclipse.pde.internal.ui.search.PluginJavaSearchUtil;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DependencyExtentSearchOperation
extends WorkspaceModifyOperation {
    private static final String KEY_DEPENDENCY = "DependencyExtent.singular";
    private static final String KEY_DEPENDENCIES = "DependencyExtent.plural";
    private static final String KEY_SEARCHING = "DependencyExtent.searching";
    IPluginImport object;
    IProject parentProject;
    IPluginBase[] models = new IPluginBase[0];
    IPackageFragment[] packageFragments = new IPackageFragment[0];
    DependencyExtentSearchResultCollector resultCollector;

    public DependencyExtentSearchOperation(IPluginImport object) {
        this.object = object;
        this.parentProject = object.getModel().getUnderlyingResource().getProject();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.resultCollector = new DependencyExtentSearchResultCollector(this, monitor);
        try {
            try {
                HashSet set = new HashSet();
                PluginJavaSearchUtil.collectAllPrerequisites(PDECore.getDefault().findPlugin(this.object.getId()), set);
                this.models = ((AbstractCollection)set).toArray(new IPluginBase[set.size()]);
                if (this.parentProject.hasNature("org.eclipse.jdt.core.javanature")) {
                    this.packageFragments = PluginJavaSearchUtil.collectPackageFragments(this.models, this.parentProject);
                }
                monitor.setTaskName(PDEPlugin.getResourceString(KEY_SEARCHING));
                monitor.beginTask("", this.packageFragments.length + 1);
                this.resultCollector.searchStarted();
                this.findExtensionPoints(monitor);
                if (this.packageFragments.length > 0) {
                    this.doJavaSearch(monitor);
                }
            }
            catch (JavaModelException e) {
                PDEPlugin.log(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.resultCollector.done();
            throw throwable;
        }
        Object var3_6 = null;
        this.resultCollector.done();
    }

    private void findExtensionPoints(IProgressMonitor monitor) {
        HashSet<String> ids = new HashSet<String>();
        IPluginExtension[] extensions = this.object.getPluginBase().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IPluginExtensionPoint point;
            if (ids.add(extensions[i].getPoint()) && (point = this.getExtensionPoint(extensions[i].getPoint())) != null) {
                this.resultCollector.accept(point);
            }
            ++i;
        }
        monitor.worked(1);
    }

    private IPluginExtensionPoint getExtensionPoint(String targetId) {
        int i = 0;
        while (i < this.models.length) {
            IPluginExtensionPoint[] extPoints = this.models[i].getExtensionPoints();
            int j = 0;
            while (j < extPoints.length) {
                if (extPoints[j].getFullId().equals(targetId)) {
                    return extPoints[j];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private void doJavaSearch(IProgressMonitor monitor) throws JavaModelException {
        SearchEngine searchEngine = new SearchEngine();
        IJavaSearchScope scope = this.getSearchScope();
        int i = 0;
        while (i < this.packageFragments.length) {
            IPackageFragment packageFragment = this.packageFragments[i];
            if (!packageFragment.hasSubpackages()) {
                SearchResultCollector collector = new SearchResultCollector(monitor);
                searchEngine.search(PDEPlugin.getWorkspace(), SearchEngine.createSearchPattern((String)(String.valueOf(packageFragment.getElementName()) + ".*"), (int)0, (int)2, (boolean)true), scope, (IJavaSearchResultCollector)collector);
                IJavaElement[] enclosingElements = collector.getResult();
                if (enclosingElements.length > 0) {
                    this.searchForTypes(packageFragment, searchEngine, SearchEngine.createJavaSearchScope((IJavaElement[])enclosingElements), monitor);
                }
            } else {
                this.searchForTypes(packageFragment, searchEngine, scope, monitor);
            }
            monitor.worked(1);
            ++i;
        }
    }

    private void searchForTypes(IPackageFragment fragment, SearchEngine searchEngine, IJavaSearchScope scope, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] children = fragment.getChildren();
        int i = 0;
        while (i < children.length) {
            IJavaElement child = children[i];
            IType[] types = new IType[]{};
            if (child instanceof IClassFile) {
                types = new IType[]{((IClassFile)child).getType()};
            } else if (child instanceof ICompilationUnit) {
                types = ((ICompilationUnit)child).getAllTypes();
            }
            int j = 0;
            while (j < types.length) {
                SearchResultCollector collector = new SearchResultCollector(monitor);
                searchEngine.search(PDEPlugin.getWorkspace(), SearchEngine.createSearchPattern((IJavaElement)types[j], (int)2), scope, (IJavaSearchResultCollector)collector);
                if (collector.getResult().length > 0) {
                    this.resultCollector.accept(types[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private IJavaSearchScope getSearchScope() throws JavaModelException {
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)this.parentProject).getPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> filteredRoots = new ArrayList<IPackageFragmentRoot>();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getResource() != null && roots[i].getResource().getProject().equals((Object)this.parentProject)) {
                filteredRoots.add(roots[i]);
            }
            ++i;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])filteredRoots.toArray(new IJavaElement[filteredRoots.size()]));
    }

    public String getPluralLabel() {
        return String.valueOf(this.object.getId()) + " - {0} " + PDEPlugin.getResourceString(KEY_DEPENDENCIES);
    }

    public String getSingularLabel() {
        return String.valueOf(this.object.getId()) + " - 1 " + PDEPlugin.getResourceString(KEY_DEPENDENCY);
    }

    public IProject getProject() {
        return this.parentProject;
    }

    class SearchResultCollector
    implements IJavaSearchResultCollector {
        protected IProgressMonitor monitor;
        HashSet result = new HashSet();

        public SearchResultCollector(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
            if (accuracy == 0) {
                this.result.add(enclosingElement.getAncestor(4));
            }
        }

        public void aboutToStart() {
        }

        public void done() {
        }

        public IProgressMonitor getProgressMonitor() {
            return this.monitor;
        }

        public IJavaElement[] getResult() {
            return ((AbstractCollection)this.result).toArray(new IJavaElement[this.result.size()]);
        }
    }
}

