/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.preferences.ExternalPluginsBlock;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TargetPlatformPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String KEY_PLATFORM_HOME = "Preferences.TargetPlatformPage.PlatformHome";
    public static final String KEY_PLATFORM_HOME_BUTTON = "Preferences.TargetPlatformPage.PlatformHome.Button";
    public static final String KEY_DESCRIPTION = "Preferences.TargetPlatformPage.Description";
    public static final String KEY_TARGET_MODE = "Preferences.TargetPlatformPage.targetMode";
    public static final String KEY_USE_THIS = "Preferences.TargetPlatformPage.useThis";
    public static final String KEY_USE_OTHER = "Preferences.TargetPlatformPage.useOther";
    private Button thisRadio;
    private Button otherRadio;
    private Label homeLabel;
    private Text homeText;
    private Button browseButton;
    private ExternalPluginsBlock pluginsBlock;
    private boolean useOther = false;
    private Preferences preferences = null;
    private boolean needsReload = false;
    private String originalText;

    public TargetPlatformPreferencePage() {
        this.setDescription(PDEPlugin.getResourceString(KEY_DESCRIPTION));
        this.preferences = PDECore.getDefault().getPluginPreferences();
        this.pluginsBlock = new ExternalPluginsBlock(this);
    }

    public void dispose() {
        this.pluginsBlock.dispose();
        super.dispose();
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 9;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        Group group = new Group(container, 0);
        group.setText(PDEPlugin.getResourceString(KEY_TARGET_MODE));
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.thisRadio = new Button((Composite)group, 16);
        this.thisRadio.setText(PDEPlugin.getResourceString(KEY_USE_THIS));
        this.otherRadio = new Button((Composite)group, 16);
        this.otherRadio.setText(PDEPlugin.getResourceString(KEY_USE_OTHER));
        if (PDECore.inLaunchedInstance()) {
            this.thisRadio.setEnabled(false);
        }
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.modeChanged(TargetPlatformPreferencePage.this.otherRadio.getSelection());
            }
        };
        this.thisRadio.addSelectionListener((SelectionListener)listener);
        this.otherRadio.addSelectionListener((SelectionListener)listener);
        Composite home = new Composite((Composite)group, 0);
        home.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        home.setLayout((Layout)layout);
        this.homeLabel = new Label(home, 0);
        this.homeLabel.setText(PDEPlugin.getResourceString(KEY_PLATFORM_HOME));
        this.homeText = new Text(home, 2048);
        this.homeText.setLayoutData((Object)new GridData(768));
        this.browseButton = new Button(home, 8);
        this.browseButton.setText(PDEPlugin.getResourceString(KEY_PLATFORM_HOME_BUTTON));
        this.browseButton.setLayoutData((Object)new GridData(3));
        SWTUtil.setButtonDimensionHint(this.browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.handleBrowse();
            }
        });
        Control block = this.pluginsBlock.createContents(container);
        block.setLayoutData((Object)new GridData(1296));
        this.load();
        this.homeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetPlatformPreferencePage.this.needsReload = true;
            }
        });
        this.originalText = this.homeText.getText();
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.target_platform_preference_page");
        return container;
    }

    String getPlatformPath() {
        if (this.useOther) {
            return this.homeText.getText();
        }
        return ExternalModelManager.computeDefaultPlatformPath();
    }

    boolean getUseOther() {
        return this.otherRadio.getSelection();
    }

    private void load() {
        String mode = this.preferences.getString("target_mode");
        boolean useOther = mode.equals("useOther");
        String path = this.preferences.getString("platform_path");
        this.load(useOther, path);
        this.pluginsBlock.initialize();
    }

    private void load(boolean useOther, String path) {
        this.useOther = useOther;
        this.homeText.setText(path);
        this.thisRadio.setSelection(!useOther);
        this.otherRadio.setSelection(useOther);
        this.updateEnableState(useOther);
    }

    private void updateEnableState(boolean useOther) {
        this.homeLabel.setEnabled(useOther);
        this.homeText.setEnabled(useOther);
        this.browseButton.setEnabled(useOther);
    }

    private void modeChanged(boolean useOther) {
        this.updateEnableState(useOther);
        String oldPath = this.getPlatformPath();
        this.useOther = useOther;
        String newPath = this.getPlatformPath();
        boolean reloadNeeded = false;
        if (oldPath != null && newPath == null) {
            reloadNeeded = true;
        }
        if (oldPath == null && newPath != null) {
            reloadNeeded = true;
        }
        if (!oldPath.equals(newPath)) {
            reloadNeeded = true;
        }
        if (reloadNeeded) {
            this.pluginsBlock.handleReload();
            this.needsReload = false;
        }
    }

    private void handleBrowse() {
        String newPath;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        if (this.homeText.getText().length() > 0) {
            dialog.setFilterPath(this.homeText.getText());
        }
        if ((newPath = dialog.open()) != null) {
            this.homeText.setText(newPath);
        }
    }

    private void loadDefaults() {
        String mode = this.preferences.getDefaultString("target_mode");
        String path = ExternalModelManager.computeDefaultPlatformPath();
        this.load(mode.equals("useOther"), path);
    }

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        this.loadDefaults();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.needsReload && this.getUseOther() && !this.originalText.equals(this.homeText.getText())) {
            MessageDialog dialog = new MessageDialog(this.getShell(), PDEPlugin.getResourceString("Preferences.TargetPlatformPage.title"), null, PDEPlugin.getResourceString("Preferences.TargetPlatformPage.question"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
            if (dialog.open() == 1) {
                return false;
            }
            this.pluginsBlock.handleReload();
        }
        this.pluginsBlock.save();
        return super.performOk();
    }

    public void resetNeedsReload() {
        this.needsReload = false;
    }
}

