/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class MainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private static final String KEY_DESCRIPTION = "Preferences.MainPage.Description";
    private static final String KEY_NO_PDE_NATURE = "Preferences.MainPage.noPDENature";
    private static final String KEY_SHOW_OBJECTS = "Preferences.MainPage.showObjects";
    private static final String KEY_USE_IDS = "Preferences.MainPage.useIds";
    private static final String KEY_USE_FULL_NAMES = "Preferences.MainPage.useFullNames";
    private static final String KEY_BUILD_SCRIPT_NAME = "Preferences.MainPage.buildScriptName";
    private static final String KEY_CODE_GENERATION = "Preferences.MainPage.codeGeneration";
    private static final String KEY_ADD_TODO = "Preferences.MainPage.addTodo";
    private Button useID;
    private Button useName;
    private Text buildText;
    private Button addTodo;

    public MainPreferencePage() {
        this.setPreferenceStore(PDEPlugin.getDefault().getPreferenceStore());
        this.setDescription(PDEPlugin.getResourceString(KEY_DESCRIPTION));
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(PDEPlugin.getResourceString(KEY_SHOW_OBJECTS));
        group.setLayout((Layout)new GridLayout());
        this.useID = new Button((Composite)group, 16);
        this.useID.setText(PDEPlugin.getResourceString(KEY_USE_IDS));
        this.useName = new Button((Composite)group, 16);
        this.useName.setText(PDEPlugin.getResourceString(KEY_USE_FULL_NAMES));
        if (store.getString(KEY_SHOW_OBJECTS).equals("useIds")) {
            this.useID.setSelection(true);
        } else {
            this.useName.setSelection(true);
        }
        Composite buildArea = new Composite(composite, 0);
        buildArea.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buildArea.setLayout((Layout)layout);
        Label label = new Label(buildArea, 0);
        label.setText(PDEPlugin.getResourceString(KEY_BUILD_SCRIPT_NAME));
        this.buildText = new Text(buildArea, 2048);
        this.buildText.setText(store.getString(KEY_BUILD_SCRIPT_NAME));
        this.buildText.setLayoutData((Object)new GridData(768));
        group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(PDEPlugin.getResourceString(KEY_CODE_GENERATION));
        group.setLayout((Layout)new GridLayout());
        this.addTodo = new Button((Composite)group, 32);
        this.addTodo.setText(PDEPlugin.getResourceString(KEY_ADD_TODO));
        this.addTodo.setSelection(store.getBoolean(KEY_ADD_TODO));
        return composite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont((Control)this.getControl());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.main_preference_page");
    }

    public static boolean isFullNameModeEnabled() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getString(KEY_SHOW_OBJECTS).equals("useNames");
    }

    public static String getBuildScriptName() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getString(KEY_BUILD_SCRIPT_NAME);
    }

    public static boolean getAddTodo() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getString(KEY_ADD_TODO).equals("true");
    }

    public boolean performOk() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        if (this.useID.getSelection()) {
            store.setValue(KEY_SHOW_OBJECTS, "useIds");
        } else {
            store.setValue(KEY_SHOW_OBJECTS, "useNames");
        }
        store.setValue(KEY_BUILD_SCRIPT_NAME, this.buildText.getText());
        store.setValue(KEY_ADD_TODO, this.addTodo.getSelection() ? "true" : "false");
        PDEPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        if (store.getDefaultString(KEY_SHOW_OBJECTS).equals("useIds")) {
            this.useID.setSelection(true);
            this.useName.setSelection(false);
        } else {
            this.useID.setSelection(false);
            this.useName.setSelection(true);
        }
        this.buildText.setText(store.getDefaultString(KEY_BUILD_SCRIPT_NAME));
        this.addTodo.setSelection(store.getDefaultBoolean(KEY_ADD_TODO));
    }

    public void init(IWorkbench workbench) {
    }
}

