/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CompilersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IEnvironmentVariables {
    private ArrayList flagControls;
    private Preferences preferences;
    private HashSet changedControls = null;

    public CompilersPreferencePage() {
        this.setDescription(PDEPlugin.getResourceString("CompilersPreferencePage.desc"));
        this.preferences = PDECore.getDefault().getPluginPreferences();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(container, 0);
        GridData gd = new GridData(1808);
        folder.setLayoutData((Object)gd);
        this.flagControls = new ArrayList();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompilersPreferencePage.this.changedControls == null) {
                    CompilersPreferencePage.this.changedControls = new HashSet();
                }
                CompilersPreferencePage.this.changedControls.add(e.widget);
            }
        };
        ModifyListener mlistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CompilersPreferencePage.this.changedControls == null) {
                    CompilersPreferencePage.this.changedControls = new HashSet();
                }
                CompilersPreferencePage.this.changedControls.add(e.widget);
            }
        };
        String[] choices = new String[]{PDEPlugin.getResourceString("CompilersPreferencePage.error"), PDEPlugin.getResourceString("CompilersPreferencePage.warning"), PDEPlugin.getResourceString("CompilersPreferencePage.ignore")};
        this.createPage(folder, PDEPlugin.getResourceString("CompilersPreferencePage.plugins"), 0, choices);
        this.createPage(folder, PDEPlugin.getResourceString("CompilersPreferencePage.schemas"), 1, choices);
        this.createPage(folder, PDEPlugin.getResourceString("CompilersPreferencePage.features"), 2, choices);
        int i = 0;
        while (i < this.flagControls.size()) {
            Control control = (Control)this.flagControls.get(i);
            if (control instanceof Combo) {
                ((Combo)control).addSelectionListener((SelectionListener)listener);
            } else if (control instanceof Button) {
                ((Button)control).addSelectionListener((SelectionListener)listener);
            } else if (control instanceof Text) {
                ((Text)control).addModifyListener(mlistener);
            }
            ++i;
        }
        Dialog.applyDialogFont((Control)parent);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.compilers_preference_page");
        return container;
    }

    private void createPage(TabFolder folder, String name, int index, String[] choices) {
        Composite page = new Composite((Composite)folder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        page.setLayout((Layout)layout);
        TabItem tab = new TabItem(folder, 0);
        tab.setText(name);
        tab.setControl((Control)page);
        Label label = new Label(page, 0);
        String textKey = index == 1 ? "CompilersPreferencePage.altlabel" : "CompilersPreferencePage.label";
        label.setText(PDEPlugin.getResourceString(textKey));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        String[] flagIds = CompilerFlags.getFlags((int)index);
        int i = 0;
        while (i < flagIds.length) {
            Control control = this.createFlag(page, flagIds[i], choices);
            this.flagControls.add(control);
            ++i;
        }
    }

    private Control createFlag(Composite page, String flagId, String[] choices) {
        Combo control = null;
        if (CompilerFlags.getFlagType((String)flagId) == 0) {
            Label label = new Label(page, 0);
            label.setText(PDEPlugin.getResourceString(flagId));
            Combo combo = new Combo(page, 8);
            combo.setItems(choices);
            combo.select(CompilerFlags.getFlag((String)flagId));
            control = combo;
        } else if (CompilerFlags.getFlagType((String)flagId) == 1) {
            Button button = new Button(page, 32);
            button.setText(PDEPlugin.getResourceString(flagId));
            button.setSelection(CompilerFlags.getBoolean((String)flagId));
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            button.setLayoutData((Object)gd);
            control = button;
        } else if (CompilerFlags.getFlagType((String)flagId) == 2) {
            Label label = new Label(page, 0);
            label.setText(PDEPlugin.getResourceString(flagId));
            Text text = new Text(page, 2052);
            text.setText(CompilerFlags.getString((String)flagId));
            GridData gd = new GridData(768);
            text.setLayoutData((Object)gd);
            control = text;
        }
        control.setData((Object)flagId);
        return control;
    }

    protected void performDefaults() {
        int i = 0;
        while (i < this.flagControls.size()) {
            Control control = (Control)this.flagControls.get(i);
            String flagId = (String)control.getData();
            if (control instanceof Combo) {
                ((Combo)control).select(CompilerFlags.getDefaultFlag((String)flagId));
            } else if (control instanceof Button) {
                ((Button)control).setSelection(CompilerFlags.getDefaultBoolean((String)flagId));
            } else if (control instanceof Text) {
                ((Text)control).setText(CompilerFlags.getDefaultString((String)flagId));
            }
            ++i;
        }
        this.changedControls = null;
    }

    public boolean performOk() {
        if (this.changedControls != null) {
            String title = PDEPlugin.getResourceString("CompilersPreferencePage.rebuild.title");
            String message = PDEPlugin.getResourceString("CompilersPreferencePage.rebuild.message");
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int res = dialog.open();
            if (res != 0 && res != 1) {
                return false;
            }
            Iterator iter = this.changedControls.iterator();
            while (iter.hasNext()) {
                Control control = (Control)iter.next();
                String flagId = (String)control.getData();
                if (control instanceof Combo) {
                    int index = ((Combo)control).getSelectionIndex();
                    CompilerFlags.setFlag((String)flagId, (int)index);
                    continue;
                }
                if (control instanceof Button) {
                    boolean value = ((Button)control).getSelection();
                    CompilerFlags.setBoolean((String)flagId, (boolean)value);
                    continue;
                }
                if (!(control instanceof Text)) continue;
                String value = ((Text)control).getText();
                CompilerFlags.setString((String)flagId, (String)value);
            }
            CompilerFlags.save();
            if (res == 0) {
                this.doFullBuild();
            }
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private void doFullBuild() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        PDEPlugin.getWorkspace().build(6, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
    }
}

