/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.pde.internal.core.Choice;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class ComboFieldEditor
extends FieldEditor {
    private Combo combo;
    private Choice[] choices;

    public ComboFieldEditor(String name, String labelText, Choice[] choices, Composite parent) {
        this.choices = choices;
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.combo.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    public Combo getComboControl() {
        return this.combo;
    }

    public Combo getComboControl(Composite parent) {
        Combo control = new Combo(parent, 2048);
        control.setItems(this.createItems());
        return control;
    }

    private String[] createItems() {
        if (this.choices == null) {
            return new String[0];
        }
        String[] items = new String[this.choices.length];
        int i = 0;
        while (i < this.choices.length) {
            items[i] = this.choices[i].getLabel();
            ++i;
        }
        return items;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.combo = this.getComboControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        this.combo.setText(value);
    }

    protected void doLoadDefault() {
        String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.combo.setText(value);
    }

    private int getIndexOf(String value) {
        int i = 0;
        while (i < this.choices.length) {
            Choice choice = this.choices[i];
            if (value.equals(choice.getValue())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void selectItem(String value) {
        int index = this.getIndexOf(value);
        if (index != -1) {
            this.combo.select(index);
        } else {
            this.combo.setText(value);
        }
    }

    protected void doStore() {
        String newValue = this.combo.getText();
        int index = this.getIndexOf(newValue);
        if (index != -1) {
            Choice choice = this.choices[index];
            newValue = choice.getValue();
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), newValue);
    }

    public int getNumberOfControls() {
        return 2;
    }
}

