/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.AdvancedLauncherTab;
import org.eclipse.pde.internal.ui.launcher.BasicLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WorkbenchLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate,
ILauncherSettings {
    private static final String KEY_NO_JRE = "WorkbenchLauncherConfigurationDelegate.noJRE";
    private static final String KEY_JRE_PATH_NOT_FOUND = "WorkbenchLauncherConfigurationDelegate.jrePathNotFound";
    private static final String KEY_BAD_FEATURE_SETUP = "WorkbenchLauncherConfigurationDelegate.badFeatureSetup";
    private static final String KEY_STARTING = "WorkbenchLauncherConfigurationDelegate.starting";
    private static final String KEY_NO_BOOT = "WorkbenchLauncherConfigurationDelegate.noBoot";
    private static final String KEY_NO_STARTUP = "WorkbenchLauncherConfigurationDelegate.noStartup";
    private static final String KEY_BROKEN_PLUGINS = "WorkbenchLauncherConfigurationDelegate.brokenPlugins";
    private static final String KEY_PROBLEMS_DELETING = "WorkbenchLauncherConfigurationDelegate.problemsDeleting";
    private static final String KEY_TITLE = "WorkbenchLauncherConfigurationDelegate.title";
    private static final String KEY_DELETE_WORKSPACE = "WorkbenchLauncherConfigurationDelegate.confirmDeleteWorkspace";
    private static final String KEY_DUPLICATES = "WorkbenchLauncherConfigurationDelegate.duplicates";
    private static final String KEY_DUPLICATE_PLUGINS = "WorkbenchLauncherConfigurationDelegate.duplicatePlugins";
    private static String bootPath = null;
    private static boolean bootInSource = false;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean askClear;
        monitor.beginTask("", 3);
        String appName = configuration.getAttribute("application", null);
        String targetWorkspace = configuration.getAttribute("location0", null);
        IVMInstall launcher = this.createLauncher(configuration, monitor);
        monitor.worked(1);
        VMRunnerConfiguration runnerConfig = WorkbenchLaunchConfigurationDelegate.createWorkspaceRunnerConfiguration(configuration, targetWorkspace, appName, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        File workspaceFile = new Path(targetWorkspace).toFile();
        if (configuration.getAttribute("clearws", false) && workspaceFile.exists() && (!(askClear = configuration.getAttribute("askclear", true)) || this.confirmDeleteWorkspace(workspaceFile))) {
            try {
                this.deleteContent(workspaceFile);
            }
            catch (IOException iOException) {
                String message = PDEPlugin.getResourceString(KEY_PROBLEMS_DELETING);
                this.showWarningDialog(message);
            }
        }
        PDEPlugin.getDefault().getLaunchesListener().manage(launch);
        launcher.getVMRunner(mode).run(runnerConfig, launch, monitor);
        String id = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (id == null) {
            IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(JavaUISourceLocator.ID_PROMPTING_JAVA_SOURCE_LOCATOR);
            ILaunchConfigurationWorkingCopy wc = null;
            wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, JavaUISourceLocator.ID_PROMPTING_JAVA_SOURCE_LOCATOR);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            locator.initializeDefaults((ILaunchConfiguration)wc);
            wc.doSave();
            launch.setSourceLocator((ISourceLocator)locator);
        }
        monitor.worked(1);
    }

    public static VMRunnerConfiguration createWorkspaceRunnerConfiguration(String targetWorkspace, String appName, IProgressMonitor monitor) throws CoreException {
        return WorkbenchLaunchConfigurationDelegate.createWorkspaceRunnerConfiguration(null, targetWorkspace, appName, monitor);
    }

    protected static VMRunnerConfiguration createWorkspaceRunnerConfiguration(ILaunchConfiguration configuration, String targetWorkspace, String appName, IProgressMonitor monitor) throws CoreException {
        String[] classpath;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((classpath = WorkbenchLaunchConfigurationDelegate.constructClasspath()) == null) {
            String message = PDEPlugin.getResourceString(KEY_NO_STARTUP);
            monitor.setCanceled(true);
            throw new CoreException(WorkbenchLaunchConfigurationDelegate.createErrorStatus(message));
        }
        boolean useFeatures = false;
        boolean useDefault = true;
        if (configuration != null) {
            useFeatures = configuration.getAttribute("usefeatures", false);
            useDefault = configuration.getAttribute("default", true);
        }
        IPluginModelBase[] plugins = null;
        if (useFeatures) {
            WorkbenchLaunchConfigurationDelegate.validateFeatures(monitor);
        } else {
            bootPath = null;
            bootInSource = false;
            plugins = WorkbenchLaunchConfigurationDelegate.validatePlugins(WorkbenchLaunchConfigurationDelegate.getWorkspacePluginsToRun(configuration, useDefault), WorkbenchLaunchConfigurationDelegate.getExternalPluginsToRun(configuration, useDefault), monitor);
        }
        if (monitor.isCanceled()) {
            return null;
        }
        ArrayList<String> programArgs = new ArrayList<String>();
        if (appName != null && appName.length() > 0) {
            programArgs.add("-application");
            programArgs.add(appName);
        }
        programArgs.add("-pdelaunch");
        if (bootPath != null && bootInSource) {
            programArgs.add("-boot");
            programArgs.add("file:" + bootPath);
        }
        programArgs.add("-dev");
        programArgs.add(WorkbenchLaunchConfigurationDelegate.getBuildOutputFolders(WorkbenchLaunchConfigurationDelegate.getWorkspacePluginsToRun(configuration, useDefault)));
        if (useFeatures) {
            IPath installPath = PDEPlugin.getWorkspace().getRoot().getLocation();
            File installDir = installPath.removeLastSegments(1).toFile();
            programArgs.add("-install");
            programArgs.add("file:" + installDir.getPath() + File.separator);
            programArgs.add("-update");
        } else {
            programArgs.add("-configuration");
            String primaryFeatureId = WorkbenchLaunchConfigurationDelegate.getPrimaryFeatureId();
            File configFile = TargetPlatform.createPlatformConfiguration((IPluginModelBase[])plugins, (IPath)new Path(targetWorkspace), (String)primaryFeatureId);
            programArgs.add("file:" + configFile.getPath());
            if (primaryFeatureId != null) {
                programArgs.add("-feature");
                programArgs.add(primaryFeatureId);
            }
        }
        programArgs.add("-data");
        programArgs.add(targetWorkspace);
        if (configuration != null) {
            if (configuration.getAttribute("showSplash", true)) {
                programArgs.add("-showsplash");
                programArgs.add(WorkbenchLaunchConfigurationDelegate.computeShowsplashArgument((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            if (configuration.getAttribute("tracing", false)) {
                programArgs.add("-debug");
                programArgs.add(WorkbenchLaunchConfigurationDelegate.getTracingFileArgument(configuration));
            }
            StringTokenizer tokenizer = new StringTokenizer(configuration.getAttribute("progargs", ""), " ");
            while (tokenizer.hasMoreTokens()) {
                programArgs.add(tokenizer.nextToken());
            }
        } else {
            programArgs.add("-os");
            programArgs.add(TargetPlatform.getOS());
            programArgs.add("-ws");
            programArgs.add(TargetPlatform.getWS());
            programArgs.add("-arch");
            programArgs.add(TargetPlatform.getOSArch());
            programArgs.add("-nl");
            programArgs.add(TargetPlatform.getNL());
        }
        String[] vmArgs = new String[]{};
        if (configuration != null) {
            vmArgs = new ExecutionArguments(configuration.getAttribute("vmargs", ""), "").getVMArgumentsArray();
        }
        VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration("org.eclipse.core.launcher.Main", classpath);
        runnerConfig.setVMArguments(vmArgs);
        runnerConfig.setProgramArguments(programArgs.toArray(new String[programArgs.size()]));
        return runnerConfig;
    }

    private IVMInstall createLauncher(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String vmInstallName = configuration.getAttribute("vminstall", BasicLauncherTab.getDefaultVMInstallName());
        IVMInstall[] vmInstallations = BasicLauncherTab.getAllVMInstances();
        IVMInstall launcher = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int i = 0;
        while (i < vmInstallations.length) {
            if (vmInstallName.equals(vmInstallations[i].getName())) {
                launcher = vmInstallations[i];
                break;
            }
            ++i;
        }
        if (launcher == null) {
            monitor.setCanceled(true);
            throw new CoreException(WorkbenchLaunchConfigurationDelegate.createErrorStatus(PDEPlugin.getFormattedMessage(KEY_NO_JRE, vmInstallName)));
        }
        if (!launcher.getInstallLocation().exists()) {
            monitor.setCanceled(true);
            throw new CoreException(WorkbenchLaunchConfigurationDelegate.createErrorStatus(PDEPlugin.getResourceString(KEY_JRE_PATH_NOT_FOUND)));
        }
        return launcher;
    }

    private static boolean ignoreValidationErrors(final MultiStatus status) {
        final boolean[] result = new boolean[1];
        WorkbenchLaunchConfigurationDelegate.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = PDEPlugin.getResourceString(WorkbenchLaunchConfigurationDelegate.KEY_TITLE);
                result[0] = MessageDialog.openConfirm((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)status.getMessage());
            }
        });
        return result[0];
    }

    private static void validateFeatures(IProgressMonitor monitor) throws CoreException {
        IPath featuresPath;
        IPath installPath = PDEPlugin.getWorkspace().getRoot().getLocation();
        String lastSegment = installPath.lastSegment();
        boolean badStructure = false;
        if (!lastSegment.equalsIgnoreCase("plugins")) {
            badStructure = true;
        }
        if (!(featuresPath = installPath.removeLastSegments(1).append("features")).toFile().exists()) {
            badStructure = true;
        }
        if (badStructure) {
            monitor.setCanceled(true);
            throw new CoreException(WorkbenchLaunchConfigurationDelegate.createErrorStatus(PDEPlugin.getResourceString(KEY_BAD_FEATURE_SETUP)));
        }
        WorkbenchLaunchConfigurationDelegate.ensureProductFilesExist(WorkbenchLaunchConfigurationDelegate.getProductPath());
    }

    private static IPath getInstallPath() {
        return PDEPlugin.getWorkspace().getRoot().getLocation();
    }

    private static IPath getProductPath() {
        return WorkbenchLaunchConfigurationDelegate.getInstallPath().removeLastSegments(1);
    }

    protected static IPluginModelBase[] getWorkspacePluginsToRun(ILaunchConfiguration config, boolean useDefault) throws CoreException {
        IPluginModelBase[] wsmodels = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
        if (useDefault) {
            return wsmodels;
        }
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        TreeSet deselectedWSPlugins = AdvancedLauncherTab.parseDeselectedWSIds(config);
        int i = 0;
        while (i < wsmodels.length) {
            String id = wsmodels[i].getPluginBase().getId();
            if (id != null && !deselectedWSPlugins.contains(id)) {
                result.add(wsmodels[i]);
            }
            ++i;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    private static IPluginModelBase[] getExternalPluginsToRun(ILaunchConfiguration config, boolean useDefault) throws CoreException {
        if (useDefault) {
            return PDECore.getDefault().getExternalModelManager().getAllEnabledModels();
        }
        ArrayList<IPluginModelBase> exList = new ArrayList<IPluginModelBase>();
        TreeSet selectedExModels = AdvancedLauncherTab.parseSelectedExtIds(config);
        IPluginModelBase[] exmodels = PDECore.getDefault().getExternalModelManager().getAllModels();
        int i = 0;
        while (i < exmodels.length) {
            String id = exmodels[i].getPluginBase().getId();
            if (id != null && selectedExModels.contains(id)) {
                exList.add(exmodels[i]);
            }
            ++i;
        }
        return exList.toArray(new IPluginModelBase[exList.size()]);
    }

    private static IPluginModelBase[] validatePlugins(IPluginModelBase[] wsmodels, IPluginModelBase[] exmodels, IProgressMonitor monitor) throws CoreException {
        IPluginModelBase bootModel = null;
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        ArrayList<IStatus> statusEntries = new ArrayList<IStatus>();
        int i = 0;
        while (i < wsmodels.length) {
            IStatus status = WorkbenchLaunchConfigurationDelegate.validateModel(wsmodels[i]);
            if (status == null) {
                String id = wsmodels[i].getPluginBase().getId();
                if (id != null) {
                    result.add(wsmodels[i]);
                    if (id.equals("org.eclipse.core.boot")) {
                        bootModel = wsmodels[i];
                    }
                }
            } else {
                statusEntries.add(status);
            }
            ++i;
        }
        Vector<String> duplicates = new Vector<String>();
        int i2 = 0;
        while (i2 < exmodels.length) {
            IStatus status = WorkbenchLaunchConfigurationDelegate.validateModel(exmodels[i2]);
            if (status == null) {
                boolean duplicate = false;
                String id = exmodels[i2].getPluginBase().getId();
                if (id != null) {
                    int j = 0;
                    while (j < wsmodels.length) {
                        if (wsmodels[j].getPluginBase().getId() != null && WorkbenchLaunchConfigurationDelegate.isDuplicate(wsmodels[j], exmodels[i2])) {
                            duplicates.add(id);
                            duplicate = true;
                            break;
                        }
                        ++j;
                    }
                    if (!duplicate) {
                        result.add(exmodels[i2]);
                        if (id.equals("org.eclipse.core.boot")) {
                            bootModel = exmodels[i2];
                        }
                    }
                }
            } else {
                statusEntries.add(status);
            }
            ++i2;
        }
        bootPath = WorkbenchLaunchConfigurationDelegate.getBootPath(bootModel);
        if (bootPath == null) {
            monitor.setCanceled(true);
            MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(KEY_TITLE), (String)PDEPlugin.getResourceString(KEY_NO_BOOT));
            return null;
        }
        if (duplicates.size() > 0 && !WorkbenchLaunchConfigurationDelegate.continueRunning(duplicates)) {
            monitor.setCanceled(true);
            return null;
        }
        if (statusEntries.size() > 0) {
            IStatus[] children = statusEntries.toArray(new IStatus[statusEntries.size()]);
            String message = PDEPlugin.getResourceString(KEY_BROKEN_PLUGINS);
            MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, children, message, null);
            if (!WorkbenchLaunchConfigurationDelegate.ignoreValidationErrors(multiStatus)) {
                monitor.setCanceled(true);
                return null;
            }
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    private static IStatus validateModel(IPluginModelBase model) {
        Status status = null;
        if (!model.isLoaded()) {
            String message = model.getInstallLocation();
            if (model.getUnderlyingResource() != null) {
                message = model.getUnderlyingResource().getProject().getName();
            }
            status = new Status(2, PDEPlugin.getPluginId(), 0, message, null);
        }
        return status;
    }

    private static boolean isDuplicate(IPluginModelBase wsmodel, IPluginModelBase exmodel) {
        if (!wsmodel.isLoaded() || !exmodel.isLoaded()) {
            return false;
        }
        return wsmodel.getPluginBase().getId().equalsIgnoreCase(exmodel.getPluginBase().getId());
    }

    private static String getBuildOutputFolders(IPluginModelBase[] wsmodels) {
        HashSet<Object> set = new HashSet<Object>();
        set.add(new Path("bin"));
        int i = 0;
        while (i < wsmodels.length) {
            IPluginModelBase model = wsmodels[i];
            IProject project = model.getUnderlyingResource().getProject();
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    set.add(JavaCore.create((IProject)project).getOutputLocation().removeFirstSegments(1));
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException coreException) {}
            ++i;
        }
        StringBuffer result = new StringBuffer();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            result.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private static String computeShowsplashArgument(IProgressMonitor monitor) {
        IPath eclipseHome = ExternalModelManager.getEclipseHome((IProgressMonitor)monitor);
        IPath fullPath = eclipseHome.append("eclipse");
        return String.valueOf(fullPath.toOSString()) + " -showsplash 600";
    }

    private static String getTracingFileArgument(ILaunchConfiguration config) {
        Map options;
        TracingOptionsManager mng = PDECore.getDefault().getTracingOptionsManager();
        try {
            options = config.getAttribute("tracingOptions", (Map)mng.getTracingTemplateCopy());
        }
        catch (CoreException coreException) {
            return "";
        }
        mng.save(options);
        String optionsFileName = mng.getTracingFileName();
        String tracingArg = SWT.getPlatform().equals("motif") ? "file:" + optionsFileName : (SWT.getPlatform().equals("gtk") ? "file://localhost" + optionsFileName : "\"file:" + optionsFileName + "\"");
        return tracingArg;
    }

    private void deleteContent(File curr) throws IOException {
        if (curr.isDirectory()) {
            File[] children = curr.listFiles();
            int i = 0;
            while (i < children.length) {
                this.deleteContent(children[i]);
                ++i;
            }
        }
        curr.delete();
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private static IStatus createErrorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 0, message, null);
    }

    private static boolean continueRunning(final Vector duplicates) {
        final boolean[] result = new boolean[1];
        WorkbenchLaunchConfigurationDelegate.getDisplay().syncExec(new Runnable(){

            public void run() {
                StringBuffer message = new StringBuffer(PDEPlugin.getFormattedMessage(WorkbenchLaunchConfigurationDelegate.KEY_DUPLICATES, new Integer(duplicates.size()).toString()));
                if (duplicates.size() <= 5) {
                    String lineSeparator = System.getProperty("line.separator");
                    message.append(String.valueOf(lineSeparator) + lineSeparator + PDEPlugin.getResourceString(WorkbenchLaunchConfigurationDelegate.KEY_DUPLICATE_PLUGINS) + ":" + lineSeparator);
                    int i = 0;
                    while (i < duplicates.size()) {
                        message.append(duplicates.get(i) + lineSeparator);
                        ++i;
                    }
                }
                result[0] = MessageDialog.openConfirm((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(WorkbenchLaunchConfigurationDelegate.KEY_TITLE), (String)message.toString());
            }
        });
        return result[0];
    }

    private boolean confirmDeleteWorkspace(final File workspaceFile) {
        final boolean[] result = new boolean[1];
        WorkbenchLaunchConfigurationDelegate.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = PDEPlugin.getResourceString(WorkbenchLaunchConfigurationDelegate.KEY_TITLE);
                String message = PDEPlugin.getFormattedMessage(WorkbenchLaunchConfigurationDelegate.KEY_DELETE_WORKSPACE, workspaceFile.getPath());
                result[0] = MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
            }
        });
        return result[0];
    }

    private void showWarningDialog(final String message) {
        WorkbenchLaunchConfigurationDelegate.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = PDEPlugin.getResourceString(WorkbenchLaunchConfigurationDelegate.KEY_TITLE);
                MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
            }
        });
    }

    private static String[] constructClasspath() throws CoreException {
        File startupJar = ExternalModelManager.getEclipseHome(null).append("startup.jar").toFile();
        if (startupJar.exists()) {
            return new String[]{startupJar.getAbsolutePath()};
        }
        return null;
    }

    private static String getBootPath(IPluginModelBase bootModel) {
        if (bootModel == null) {
            return null;
        }
        try {
            IResource resource = bootModel.getUnderlyingResource();
            if (resource != null) {
                IProject project = resource.getProject();
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    resource = project.findMember("boot.jar");
                    if (resource != null) {
                        return "file:" + resource.getLocation().toOSString();
                    }
                    IPath path = JavaCore.create((IProject)project).getOutputLocation();
                    if (path != null) {
                        bootInSource = true;
                        IPath sourceBootPath = project.getParent().getLocation().append(path);
                        return sourceBootPath.addTrailingSeparator().toOSString();
                    }
                }
            } else {
                File binDir = new File(bootModel.getInstallLocation(), "bin/");
                if (binDir.exists()) {
                    return binDir.getAbsolutePath();
                }
                File bootJar = new File(bootModel.getInstallLocation(), "boot.jar");
                if (bootJar.exists()) {
                    return "file:" + bootJar.getAbsolutePath();
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private static String getPrimaryFeatureId() {
        IPath eclipsePath = ExternalModelManager.getEclipseHome(null);
        File iniFile = new File(eclipsePath.toFile(), "install.ini");
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        try {
            FileInputStream fis = new FileInputStream(iniFile);
            pini.load(fis);
            fis.close();
            return pini.getProperty("feature.default.id");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void ensureProductFilesExist(IPath productArea) {
        File productDir = productArea.toFile();
        File marker = new File(productDir, ".eclipseproduct");
        File ini = new File(productDir, "install.ini");
        if (marker.exists() && ini.exists()) {
            return;
        }
        IPath eclipsePath = ExternalModelManager.getEclipseHome(null);
        if (!marker.exists()) {
            WorkbenchLaunchConfigurationDelegate.copyFile(eclipsePath, ".eclipseproduct", marker);
        }
        if (!ini.exists()) {
            WorkbenchLaunchConfigurationDelegate.copyFile(eclipsePath, "install.ini", ini);
        }
    }

    private static void copyFile(IPath eclipsePath, String name, File target) {
        File source = new File(eclipsePath.toFile(), name);
        if (!source.exists()) {
            return;
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            try {
                is = new FileInputStream(source);
                os = new FileOutputStream(target);
                byte[] buf = new byte[1024];
                long currentLen = 0L;
                int len = is.read(buf);
                while (len != -1) {
                    currentLen += (long)len;
                    os.write(buf, 0, len);
                    len = is.read(buf);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var10_11 = null;
        try {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {}
    }
}

