/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.ui.launcher.TracingLauncherTab;
import org.eclipse.pde.internal.ui.util.ChoicePropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class TracingPropertySource
implements IPropertySource,
IAdaptable {
    private IPluginModel model;
    private Vector descriptors;
    private Hashtable template;
    private Hashtable values;
    private Hashtable dvalues;
    private static final String[] booleanChoices = new String[]{"false", "true"};
    private Properties masterOptions;
    private boolean modified;
    private TracingLauncherTab tab;
    static /* synthetic */ Class class$0;

    public TracingPropertySource(IPluginModel model, Properties masterOptions, Hashtable template, TracingLauncherTab tab) {
        this.model = model;
        this.masterOptions = masterOptions;
        this.template = template;
        this.tab = tab;
        this.values = new Hashtable();
        this.dvalues = new Hashtable();
    }

    private PropertyDescriptor createBooleanPropertyDescriptor(String key, String value) {
        ChoicePropertyDescriptor desc = new ChoicePropertyDescriptor(key, key, booleanChoices);
        desc.setLabelProvider((ILabelProvider)new BooleanLabelProvider(key));
        return desc;
    }

    private void createDescriptors() {
        this.descriptors = new Vector();
        Enumeration enumeration = this.template.keys();
        while (enumeration.hasMoreElements()) {
            Object dvalue;
            PropertyDescriptor desc;
            String key = (String)enumeration.nextElement();
            Path path = new Path(key);
            path = path.removeFirstSegments(1);
            String shortKey = path.toString().toLowerCase();
            String value = (String)this.template.get(key);
            String lvalue = null;
            String masterValue = this.masterOptions.getProperty(key);
            if (value != null) {
                lvalue = value.toLowerCase();
            }
            if (lvalue != null && (lvalue.equals("true") || lvalue.equals("false"))) {
                desc = this.createBooleanPropertyDescriptor(shortKey, value);
                dvalue = new Integer(lvalue.equals("true") ? 1 : 0);
                this.dvalues.put(shortKey, dvalue);
                if (masterValue != null) {
                    Integer mvalue = new Integer(masterValue.equals("true") ? 1 : 0);
                    this.values.put(shortKey, mvalue);
                }
            } else {
                desc = this.createTextPropertyDescriptor(shortKey, value);
                dvalue = value != null ? value : "";
                this.dvalues.put(shortKey, dvalue);
                if (masterValue != null) {
                    this.values.put(shortKey, masterValue);
                }
            }
            this.descriptors.add(desc);
        }
    }

    private PropertyDescriptor createTextPropertyDescriptor(String key, String value) {
        return new TextPropertyDescriptor((Object)key, key);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.createDescriptors();
        }
        return this.descriptors.toArray(new IPropertyDescriptor[this.descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        Object value = this.values.get(id);
        return value;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void reset() {
        this.values = (Hashtable)this.dvalues.clone();
        this.modified = true;
        this.tab.updateLaunchConfigurationDialog();
    }

    public void resetPropertyValue(Object id) {
    }

    public void save() {
        String pid = this.model.getPlugin().getId();
        Enumeration enumeration = this.values.keys();
        while (enumeration.hasMoreElements()) {
            String shortKey = (String)enumeration.nextElement();
            Object value = this.values.get(shortKey);
            String svalue = value.toString();
            if (value instanceof Integer) {
                svalue = booleanChoices[(Integer)value];
            }
            IPath path = new Path(pid).append(shortKey);
            this.masterOptions.setProperty(path.toString(), svalue);
        }
        this.modified = false;
    }

    public void setPropertyValue(Object id, Object value) {
        this.values.put(id, value);
        this.modified = true;
        this.tab.updateLaunchConfigurationDialog();
    }

    public boolean isModified() {
        return this.modified;
    }

    class BooleanLabelProvider
    extends LabelProvider {
        String id;

        public BooleanLabelProvider(String id) {
            this.id = id;
        }

        public String getText(Object obj) {
            Object value = TracingPropertySource.this.getPropertyValue(this.id);
            if (value instanceof Integer) {
                Integer ivalue = (Integer)value;
                return booleanChoices[ivalue];
            }
            return value.toString();
        }
    }
}

