/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.manifest.NullMenuManager;
import org.eclipse.pde.internal.ui.editor.manifest.NullToolBarManager;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.TracingPropertySource;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class TracingLauncherTab
extends AbstractLauncherTab
implements ILauncherSettings {
    public static final String KEY_NAME = "TracingLauncherTab.name";
    public static final String KEY_DESC = "TracingLauncherTab.desc";
    private static final String KEY_TRACING = "TracingLauncherTab.tracing";
    public static final String KEY_PLUGINS = "TracingLauncherTab.plugins";
    public static final String KEY_WORKSPACE_PLUGINS = "TracingLauncherTab.workspacePlugins";
    public static final String KEY_EXTERNAL_PLUGINS = "TracingLauncherTab.externalPlugins";
    public static final String KEY_OPTIONS = "TracingLauncherTab.options";
    public static final String KEY_MAXIMIZE = "TracingLauncherTab.maximize";
    public static final String KEY_RESTORE = "TracingLauncherTab.restore";
    private static final String S_SELECTED_PLUGIN = "selectedPlugin";
    private static final String S_MAXIMIZED = "maximized";
    private Button tracingCheck;
    private TreeViewer pluginTreeViewer;
    private NamedElement workspacePlugins;
    private NamedElement externalPlugins;
    private Properties masterOptions;
    private Hashtable propertySources = new Hashtable();
    private TracingPropertySource currentSource;
    private Vector externalList;
    private Vector workspaceList;
    private PropertySheetPage propertySheet;
    private SashForm sashForm;
    private Composite tableChild;
    private Label propertyLabel;
    private ToolItem maximizeItem;
    private Image image;

    public TracingLauncherTab() {
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.image = PDEPluginImages.DESC_DOC_SECTION_OBJ.createImage();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createStartingSpace(container, 1);
        this.tracingCheck = new Button(container, 32);
        this.tracingCheck.setText(PDEPlugin.getResourceString(KEY_TRACING));
        GridData gd = new GridData(768);
        this.tracingCheck.setLayoutData((Object)gd);
        this.tracingCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracingLauncherTab.this.masterCheckChanged(true);
                TracingLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label separator = new Label(container, 258);
        gd = new GridData(768);
        separator.setLayoutData((Object)gd);
        this.sashForm = new SashForm(container, 512);
        gd = new GridData(1808);
        this.sashForm.setLayoutData((Object)gd);
        Composite treeChild = new Composite((Composite)this.sashForm, 0);
        GridLayout clayout = new GridLayout();
        clayout.marginWidth = 0;
        clayout.marginHeight = 0;
        treeChild.setLayout((Layout)clayout);
        Label label = new Label(treeChild, 0);
        label.setText(PDEPlugin.getResourceString(KEY_PLUGINS));
        Control c = this.createPluginList(treeChild);
        gd = new GridData(1808);
        c.setLayoutData((Object)gd);
        this.tableChild = new Composite((Composite)this.sashForm, 0);
        clayout = new GridLayout();
        clayout.marginWidth = 0;
        clayout.marginHeight = 0;
        clayout.verticalSpacing = 2;
        this.tableChild.setLayout((Layout)clayout);
        Composite titleBar = new Composite(this.tableChild, 0);
        clayout = new GridLayout();
        clayout.numColumns = 2;
        clayout.marginHeight = 0;
        clayout.marginWidth = 0;
        titleBar.setLayout((Layout)clayout);
        gd = new GridData(768);
        titleBar.setLayoutData((Object)gd);
        this.propertyLabel = new Label(titleBar, 0);
        gd = new GridData(768);
        this.propertyLabel.setLayoutData((Object)gd);
        this.updatePropertyLabel(null);
        ToolBar toolbar = new ToolBar(titleBar, 0x800000);
        this.maximizeItem = new ToolItem(toolbar, 8);
        this.maximizeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracingLauncherTab.this.toggleMaximize();
            }
        });
        this.updateMaximizeItem();
        c = this.createPropertySheet(toolbar, this.tableChild);
        gd = new GridData(1808);
        c.setLayoutData((Object)gd);
        this.propertyLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TracingLauncherTab.this.toggleMaximize();
            }
        });
        this.initialize();
        this.setControl((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.launcher_tracing");
    }

    private void toggleMaximize() {
        this.doMaximize(this.sashForm.getMaximizedControl() == null);
    }

    private void doMaximize(boolean maximize) {
        Composite maxControl = maximize ? this.tableChild : null;
        this.sashForm.setMaximizedControl((Control)maxControl);
        this.updateMaximizeItem();
    }

    private void updateMaximizeItem() {
        String tooltip;
        Image image;
        boolean maximized;
        boolean bl = maximized = this.sashForm.getMaximizedControl() != null;
        if (maximized) {
            image = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_RESTORE);
            tooltip = PDEPlugin.getResourceString(KEY_RESTORE);
        } else {
            image = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_MAXIMIZE);
            tooltip = PDEPlugin.getResourceString(KEY_MAXIMIZE);
        }
        this.maximizeItem.setImage(image);
        this.maximizeItem.setToolTipText(tooltip);
        this.maximizeItem.getParent().redraw();
    }

    protected Control createPluginList(Composite parent) {
        this.pluginTreeViewer = new TreeViewer(parent, 2048);
        this.pluginTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginTreeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.pluginTreeViewer.setAutoExpandLevel(3);
        this.pluginTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object object) {
                if (object instanceof IPluginModel) {
                    return ((IPluginModel)object).isEnabled();
                }
                return true;
            }
        });
        this.pluginTreeViewer.setSorter((ViewerSorter)new ListUtil.PluginSorter(){

            public int category(Object obj) {
                if (obj == TracingLauncherTab.this.workspacePlugins) {
                    return -1;
                }
                if (obj == TracingLauncherTab.this.externalPlugins) {
                    return 1;
                }
                return 0;
            }
        });
        this.pluginTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                Object item = ((IStructuredSelection)e.getSelection()).getFirstElement();
                if (item instanceof IPluginModel) {
                    TracingLauncherTab.this.pluginSelected((IPluginModel)item);
                } else {
                    TracingLauncherTab.this.pluginSelected(null);
                }
            }
        });
        Image pluginsImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
        this.workspacePlugins = new NamedElement(PDEPlugin.getResourceString(KEY_WORKSPACE_PLUGINS), pluginsImage);
        this.externalPlugins = new NamedElement(PDEPlugin.getResourceString(KEY_EXTERNAL_PLUGINS), pluginsImage);
        return this.pluginTreeViewer.getTree();
    }

    protected Control createPropertySheet(ToolBar toolbar, Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.propertySheet = new PropertySheetPage();
        this.propertySheet.createControl(composite);
        GridData gd = new GridData(1808);
        this.propertySheet.getControl().setLayoutData((Object)gd);
        this.propertySheet.makeContributions((IMenuManager)new NullMenuManager(), (IToolBarManager)new NullToolBarManager(), null);
        return composite;
    }

    public void dispose() {
        if (this.propertySheet != null) {
            this.propertySheet.dispose();
        }
        this.image.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    private IDialogSettings getDialogSettings() {
        String sectionId;
        IDialogSettings master = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = master.getSection(sectionId = "tracingLauncherTab");
        if (section == null) {
            section = master.addNewSection(sectionId);
        }
        return section;
    }

    private void fillTraceableModelList(IPluginModel[] models, Vector result) {
        int i = 0;
        while (i < models.length) {
            IPluginModel model = models[i];
            if (TracingOptionsManager.isTraceable((IPluginModelBase)model)) {
                result.add(model);
            }
            ++i;
        }
    }

    private IAdaptable getAdaptable(IPluginModel model) {
        if (model == null) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)this.propertySources.get(model);
        if (adaptable == null) {
            String id = model.getPlugin().getId();
            Hashtable defaults = PDECore.getDefault().getTracingOptionsManager().getTemplateTable(id);
            adaptable = new TracingPropertySource(model, this.masterOptions, defaults, this);
            this.propertySources.put(model, adaptable);
        }
        return adaptable;
    }

    private Object[] getExternalTraceablePlugins() {
        if (this.externalList == null) {
            this.externalList = new Vector();
            IPluginModel[] models = PDECore.getDefault().getExternalModelManager().getModels();
            this.fillTraceableModelList(models, this.externalList);
        }
        return this.externalList.toArray();
    }

    private Object[] getWorkspaceTraceablePlugins() {
        if (this.workspaceList == null) {
            this.workspaceList = new Vector();
            IPluginModel[] models = PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModels();
            this.fillTraceableModelList(models, this.workspaceList);
        }
        return this.workspaceList.toArray();
    }

    private void initialize() {
        this.pluginTreeViewer.setInput((Object)PDEPlugin.getDefault());
        this.pluginTreeViewer.reveal((Object)this.workspacePlugins);
    }

    private void masterCheckChanged(boolean userChange) {
        boolean enabled = this.tracingCheck.getSelection();
        this.pluginTreeViewer.getTree().setEnabled(enabled);
        this.propertySheet.getControl().setEnabled(enabled);
        this.setChanged(userChange);
    }

    private void selectPlugin(String pluginId) {
        IPluginModel model = this.findModel(pluginId, this.workspaceList);
        if (model == null) {
            model = this.findModel(pluginId, this.externalList);
        }
        if (model != null) {
            this.pluginTreeViewer.setSelection((ISelection)new StructuredSelection((Object)model), true);
        }
    }

    private IPluginModel findModel(String id, Vector list) {
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.size()) {
            IPluginModel model = (IPluginModel)list.get(i);
            IPlugin plugin = model.getPlugin();
            if (plugin.getId().equals(id)) {
                return model;
            }
            ++i;
        }
        return null;
    }

    public void initializeFrom(final ILaunchConfiguration config) {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                TracingLauncherTab.this.doInitializeFrom(config);
            }
        });
    }

    private void doInitializeFrom(ILaunchConfiguration config) {
        this.masterOptions = PDECore.getDefault().getTracingOptionsManager().getTracingTemplateCopy();
        this.propertySources.clear();
        try {
            IDialogSettings settings;
            String selectedPlugin;
            boolean tracing = false;
            tracing = config.getAttribute("tracing", tracing);
            this.tracingCheck.setSelection(tracing);
            this.masterCheckChanged(false);
            Map options = config.getAttribute("tracingOptions", null);
            if (options != null) {
                this.initializeFrom(options);
            }
            if ((selectedPlugin = (settings = this.getDialogSettings()).get(S_SELECTED_PLUGIN)) != null && selectedPlugin.length() > 0) {
                this.selectPlugin(selectedPlugin);
            }
            boolean maximized = settings.getBoolean(S_MAXIMIZED);
            this.doMaximize(maximized);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        Object el;
        if (!this.isTracingEnabled() && !this.isChanged()) {
            return;
        }
        config.setAttribute("tracing", this.isTracingEnabled());
        boolean changes = false;
        Enumeration enumeration = this.propertySources.elements();
        while (enumeration.hasMoreElements()) {
            TracingPropertySource source = (TracingPropertySource)enumeration.nextElement();
            if (!source.isModified()) continue;
            changes = true;
            source.save();
        }
        boolean maximized = this.sashForm.getMaximizedControl() != null;
        IDialogSettings settings = this.getDialogSettings();
        settings.put(S_MAXIMIZED, maximized);
        IStructuredSelection sel = (IStructuredSelection)this.pluginTreeViewer.getSelection();
        if (!sel.isEmpty() && (el = sel.getFirstElement()) instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)sel.getFirstElement();
            IPluginBase pluginBase = model.getPluginBase();
            settings.put(S_SELECTED_PLUGIN, pluginBase.getId());
        }
        if (changes) {
            config.setAttribute("tracingOptions", (Map)this.masterOptions);
        }
        this.setChanged(false);
    }

    private void initializeFrom(Map options) {
        ((Hashtable)this.masterOptions).putAll(options);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("tracing", false);
    }

    public boolean isTracingEnabled() {
        return this.tracingCheck.getSelection();
    }

    private void updatePropertyLabel(IPluginModel model) {
        String text = model == null ? PDEPlugin.getResourceString(KEY_OPTIONS) : PDEPlugin.getDefault().getLabelProvider().getText(model);
        this.propertyLabel.setText(text);
    }

    private void pluginSelected(IPluginModel model) {
        IAdaptable adaptable = this.getAdaptable(model);
        StructuredSelection selection = adaptable != null ? new StructuredSelection((Object)adaptable) : new StructuredSelection();
        this.propertySheet.selectionChanged(null, (ISelection)selection);
        this.currentSource = (TracingPropertySource)adaptable;
        this.updatePropertyLabel(model);
    }

    public String getName() {
        return PDEPlugin.getResourceString(KEY_NAME);
    }

    public Image getImage() {
        return this.image;
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModel);
        }

        public Object[] getChildren(Object parent) {
            if (parent == TracingLauncherTab.this.externalPlugins) {
                return TracingLauncherTab.this.getExternalTraceablePlugins();
            }
            if (parent == TracingLauncherTab.this.workspacePlugins) {
                return TracingLauncherTab.this.getWorkspaceTraceablePlugins();
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginModel) {
                IPluginModel model = (IPluginModel)child;
                if (model.getUnderlyingResource() != null) {
                    return TracingLauncherTab.this.workspacePlugins;
                }
                return TracingLauncherTab.this.externalPlugins;
            }
            return null;
        }

        public Object[] getElements(Object input) {
            return new Object[]{TracingLauncherTab.this.workspacePlugins, TracingLauncherTab.this.externalPlugins};
        }
    }
}

