/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.BasicLauncherTab;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class RuntimeWorkbenchShortcut
implements ILaunchShortcut {
    public void run() {
        this.launch("run");
    }

    public void debug() {
        this.launch("debug");
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(mode);
    }

    public void launch(ISelection selection, String mode) {
        this.launch(mode);
    }

    protected void launch(String mode) {
        try {
            ILaunchConfiguration config = this.findLaunchConfiguration(mode);
            if (config != null) {
                DebugUITools.saveAndBuildBeforeLaunch();
                config.launch(mode, null);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(String mode) {
        ILaunchConfigurationType configType = this.getWorkbenchLaunchConfigType();
        ILaunchConfiguration[] configs = new ILaunchConfiguration[]{};
        try {
            configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        int candidateCount = configs.length;
        if (candidateCount < 1) {
            return this.createConfiguration();
        }
        if (candidateCount == 1) {
            return configs[0];
        }
        ILaunchConfiguration config = this.chooseConfiguration(configs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(ILaunchConfiguration[] configs, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs);
        dialog.setTitle(PDEPlugin.getResourceString("RuntimeWorkbenchShortcut.title"));
        if (mode.equals("debug")) {
            dialog.setMessage(PDEPlugin.getResourceString("RuntimeWorkbenchShortcut.select.debug"));
        } else {
            dialog.setMessage(PDEPlugin.getResourceString("RuntimeWorkbenchShortcut.select.run"));
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration() {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getWorkbenchLaunchConfigType();
            String computedName = this.getComputedName(configType.getName());
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, computedName);
            wc.setAttribute("location0", BasicLauncherTab.getDefaultWorkspace());
            wc.setAttribute("vmargs", "");
            wc.setAttribute("progargs", BasicLauncherTab.getDefaultProgramArguments());
            wc.setAttribute("vminstall", BasicLauncherTab.getDefaultVMInstallName());
            String appName = "org.eclipse.ui.workbench";
            wc.setAttribute("application", appName);
            wc.setAttribute("default", true);
            wc.setAttribute("usefeatures", false);
            wc.setAttribute(IDebugUIConstants.ATTR_TARGET_DEBUG_PERSPECTIVE, "perspective_default");
            wc.setAttribute(IDebugUIConstants.ATTR_TARGET_RUN_PERSPECTIVE, "perspective_none");
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, JavaUISourceLocator.ID_PROMPTING_JAVA_SOURCE_LOCATOR);
            wc.setAttribute("clearws", false);
            wc.setAttribute("askclear", true);
            wc.setAttribute("showSplash", true);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            PDEPlugin.logException(ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getWorkbenchLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
    }

    private String getComputedName(String prefix) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.generateUniqueLaunchConfigurationNameFrom(prefix);
    }

    protected Shell getShell() {
        return PDEPlugin.getActiveWorkbenchShell();
    }
}

