/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class BasicLauncherTab
extends AbstractLauncherTab
implements ILauncherSettings {
    private static final String KEY_DESC = "";
    private static final String KEY_NAME = "BasicLauncherTab.name";
    private static final String KEY_WORKSPACE = "BasicLauncherTab.workspace";
    private static final String KEY_BROWSE = "BasicLauncherTab.browse";
    private static final String KEY_CLEAR = "BasicLauncherTab.clear";
    private static final String KEY_ASK_CLEAR = "BasicLauncherTab.askClear";
    private static final String KEY_JRE = "BasicLauncherTab.jre";
    private static final String KEY_VMARGS = "BasicLauncherTab.vmArgs";
    private static final String KEY_PARGS = "BasicLauncherTab.programArgs";
    private static final String KEY_APPNAME = "BasicLauncherTab.appName";
    private static final String KEY_SHOW_SPLASH = "BasicLauncherTab.showSplash";
    private static final String KEY_RESTORE = "BasicLauncherTab.restore";
    private static final String KEY_RESTORE_TEXT = "BasicLauncherTab.restoreText";
    private static final String KEY_WTITLE = "BasicLauncherTab.workspace.title";
    private static final String KEY_WMESSAGE = "BasicLauncherTab.workspace.message";
    private static final String KEY_NO_JRE = "BasicLauncherTab.noJRE";
    private static final String KEY_ENTER_WORKSPACE = "BasicLauncherTab.enterWorkspace";
    private static final String KEY_INVALID_WORKSPACE = "BasicLauncherTab.invalidWorkspace";
    private static final String KEY_EXISTING_WORKSPACE = "BasicLauncherTab.workspaceExisting";
    public static final String RT_WORKSPACE = "runtime-workspace";
    private Combo workspaceCombo;
    private Button browseButton;
    private Button clearWorkspaceCheck;
    private Button askClearCheck;
    private Combo jreCombo;
    private Text vmArgsText;
    private Text progArgsText;
    private Text applicationNameText;
    private Button showSplashCheck;
    private Button defaultsButton;
    private Image image;
    private IStatus jreSelectionStatus = AbstractLauncherTab.createStatus(0, "");
    private IStatus workspaceSelectionStatus = AbstractLauncherTab.createStatus(0, "");
    private IVMInstall[] vmInstallations = BasicLauncherTab.getAllVMInstances();
    private boolean blockChanges = false;

    public BasicLauncherTab() {
        this.image = PDEPluginImages.DESC_ARGUMENT_TAB.createImage();
    }

    public void dispose() {
        super.dispose();
        this.image.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createStartingSpace(composite, 3);
        Label label = new Label(composite, 0);
        label.setText(PDEPlugin.getResourceString(KEY_WORKSPACE));
        this.workspaceCombo = new Combo(composite, 4);
        this.fillIntoGrid((Control)this.workspaceCombo, 1, true);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(PDEPlugin.getResourceString(KEY_BROWSE));
        this.clearWorkspaceCheck = new Button(composite, 32);
        this.clearWorkspaceCheck.setText(PDEPlugin.getResourceString(KEY_CLEAR));
        this.fillIntoGrid((Control)this.clearWorkspaceCheck, 3, false);
        this.askClearCheck = new Button(composite, 32);
        this.askClearCheck.setText(PDEPlugin.getResourceString(KEY_ASK_CLEAR));
        this.fillIntoGrid((Control)this.askClearCheck, 3, false);
        label = new Label(composite, 258);
        this.fillIntoGrid((Control)label, 3, false);
        label = new Label(composite, 0);
        label.setText(PDEPlugin.getResourceString(KEY_JRE));
        this.jreCombo = new Combo(composite, 12);
        this.fillIntoGrid((Control)this.jreCombo, 2, false);
        label = new Label(composite, 0);
        label.setText(PDEPlugin.getResourceString(KEY_VMARGS));
        this.vmArgsText = new Text(composite, 2052);
        this.fillIntoGrid((Control)this.vmArgsText, 2, false);
        label = new Label(composite, 0);
        label.setText(PDEPlugin.getResourceString(KEY_PARGS));
        this.progArgsText = new Text(composite, 2052);
        this.fillIntoGrid((Control)this.progArgsText, 2, false);
        label = new Label(composite, 0);
        label.setText(PDEPlugin.getResourceString(KEY_APPNAME));
        this.applicationNameText = new Text(composite, 2052);
        this.fillIntoGrid((Control)this.applicationNameText, 2, false);
        this.showSplashCheck = new Button(composite, 32);
        this.showSplashCheck.setText(PDEPlugin.getResourceString(KEY_SHOW_SPLASH));
        this.fillIntoGrid((Control)this.showSplashCheck, 3, false);
        label = new Label(composite, 258);
        this.fillIntoGrid((Control)label, 3, false);
        this.defaultsButton = new Button(composite, 8);
        this.defaultsButton.setText(PDEPlugin.getResourceString(KEY_RESTORE));
        GridData data = new GridData(256);
        this.defaultsButton.setLayoutData((Object)data);
        SWTUtil.setButtonDimensionHint(this.defaultsButton);
        this.hookListeners();
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.pde.doc.user.launcher_basic");
    }

    private GridData fillIntoGrid(Control control, int horizontalSpan, boolean grab) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = horizontalSpan;
        gd.grabExcessHorizontalSpace = grab;
        control.setLayoutData((Object)gd);
        return gd;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.blockChanges = true;
            this.vmArgsText.setText(config.getAttribute("vmargs", KEY_DESC));
            this.progArgsText.setText(config.getAttribute("progargs", BasicLauncherTab.getDefaultProgramArguments()));
            this.applicationNameText.setText(config.getAttribute("application", KEY_DESC));
            this.clearWorkspaceCheck.setSelection(config.getAttribute("clearws", false));
            this.askClearCheck.setSelection(config.getAttribute("askclear", true));
            this.showSplashCheck.setSelection(config.getAttribute("showSplash", true));
            this.askClearCheck.setEnabled(this.clearWorkspaceCheck.getSelection());
            this.jreCombo.setItems(this.getVMInstallNames(this.vmInstallations));
            String vmInstallName = config.getAttribute("vminstall", BasicLauncherTab.getDefaultVMInstallName());
            int i = 0;
            while (i < this.vmInstallations.length) {
                if (vmInstallName.equals(this.vmInstallations[i].getName())) {
                    this.jreCombo.select(i);
                    break;
                }
                ++i;
            }
            ArrayList<String> items = new ArrayList<String>();
            int i2 = 0;
            while (i2 < 6) {
                String curr = config.getAttribute("location" + String.valueOf(i2), null);
                if (curr != null && !items.contains(curr)) {
                    items.add(curr);
                }
                ++i2;
            }
            this.workspaceCombo.setItems(items.toArray(new String[items.size()]));
            if (this.workspaceCombo.getItemCount() > 0) {
                this.workspaceCombo.select(0);
            } else {
                this.workspaceCombo.setText(BasicLauncherTab.getDefaultWorkspace());
            }
            this.workspaceSelectionStatus = this.validateWorkspaceSelection();
            this.jreSelectionStatus = this.validateJRESelection();
            this.updateStatus();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.blockChanges = false;
    }

    static String getDefaultWorkspace() {
        IPath path = PDEPlugin.getWorkspace().getRoot().getLocation().removeLastSegments(1);
        path = path.append(RT_WORKSPACE);
        return path.toOSString();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("location0", BasicLauncherTab.getDefaultWorkspace());
        config.setAttribute("application", KEY_DESC);
        config.setAttribute("clearws", false);
        config.setAttribute("progargs", BasicLauncherTab.getDefaultProgramArguments());
        config.setAttribute("showSplash", true);
        config.setAttribute("askclear", true);
        config.setAttribute("vmargs", KEY_DESC);
    }

    private void doRestoreDefaults() {
        this.progArgsText.setText(BasicLauncherTab.getDefaultProgramArguments());
        this.vmArgsText.setText(KEY_DESC);
        this.applicationNameText.setText(KEY_DESC);
        this.workspaceCombo.setText(BasicLauncherTab.getDefaultWorkspace());
        this.clearWorkspaceCheck.setSelection(false);
        this.showSplashCheck.setSelection(true);
        this.askClearCheck.setSelection(true);
        this.askClearCheck.setEnabled(false);
        this.jreCombo.select(this.jreCombo.indexOf(String.valueOf(JavaRuntime.getDefaultVMInstall().getName()) + " - " + JavaRuntime.getDefaultVMInstall().getVMInstallType().getName()));
    }

    static String getDefaultVMInstallName() {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            return install.getName();
        }
        return null;
    }

    static String getDefaultProgramArguments() {
        String os = TargetPlatform.getOS();
        String ws = TargetPlatform.getWS();
        String arch = TargetPlatform.getOSArch();
        String nl = TargetPlatform.getNL();
        return "-os " + os + " -ws " + ws + " -arch " + arch + " -nl " + nl;
    }

    private void hookListeners() {
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = BasicLauncherTab.this.chooseWorkspaceLocation();
                if (chosen != null) {
                    BasicLauncherTab.this.workspaceCombo.setText(chosen.toOSString());
                    BasicLauncherTab.this.updateStatus();
                }
            }
        });
        this.workspaceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.workspaceSelectionStatus = BasicLauncherTab.this.validateWorkspaceSelection();
                if (!BasicLauncherTab.this.blockChanges) {
                    BasicLauncherTab.this.updateStatus();
                }
            }
        });
        this.workspaceCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicLauncherTab.this.workspaceSelectionStatus = BasicLauncherTab.this.validateWorkspaceSelection();
                if (!BasicLauncherTab.this.blockChanges) {
                    BasicLauncherTab.this.updateStatus();
                }
            }
        });
        this.clearWorkspaceCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.askClearCheck.setEnabled(BasicLauncherTab.this.clearWorkspaceCheck.getSelection());
                BasicLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.askClearCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.showSplashCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.vmArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!BasicLauncherTab.this.blockChanges) {
                    BasicLauncherTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.progArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!BasicLauncherTab.this.blockChanges) {
                    BasicLauncherTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.applicationNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!BasicLauncherTab.this.blockChanges) {
                    BasicLauncherTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.jreCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.jreSelectionStatus = BasicLauncherTab.this.validateJRESelection();
                BasicLauncherTab.this.updateStatus();
            }
        });
        this.defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.doRestoreDefaults();
                BasicLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void updateStatus() {
        this.updateStatus(AbstractLauncherTab.getMoreSevere(this.workspaceSelectionStatus, this.jreSelectionStatus));
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (!this.isChanged()) {
            return;
        }
        config.setAttribute("vmargs", this.getVMArguments());
        config.setAttribute("progargs", this.getProgramArguments());
        try {
            IVMInstall vmInstall = this.getVMInstall();
            if (vmInstall != null) {
                if (config.getAttribute("vminstall", null) != null) {
                    config.setAttribute("vminstall", vmInstall.getName());
                } else {
                    config.setAttribute("vminstall", vmInstall.getName().equals(BasicLauncherTab.getDefaultVMInstallName()) ? null : vmInstall.getName());
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        config.setAttribute("application", this.getApplicationName());
        config.setAttribute("clearws", this.doClearWorkspace());
        config.setAttribute("askclear", this.doAskClear());
        config.setAttribute("showSplash", this.doShowSplash());
        config.setAttribute("location" + String.valueOf(0), this.workspaceCombo.getText());
        String[] items = this.workspaceCombo.getItems();
        int nEntries = Math.min(items.length, 5);
        int i = 0;
        while (i < nEntries) {
            config.setAttribute("location" + String.valueOf(i + 1), items[i]);
            ++i;
        }
        this.setChanged(false);
    }

    private IPath chooseWorkspaceLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getControl().getShell());
        dialog.setFilterPath(this.workspaceCombo.getText());
        dialog.setText(PDEPlugin.getResourceString(KEY_WTITLE));
        dialog.setMessage(PDEPlugin.getResourceString(KEY_WMESSAGE));
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    private IStatus validateJRESelection() {
        IVMInstall curr = this.getVMInstall();
        if (curr == null) {
            return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString(KEY_NO_JRE));
        }
        return AbstractLauncherTab.createStatus(0, KEY_DESC);
    }

    private IStatus validateWorkspaceSelection() {
        IPath curr = this.getWorkspaceLocation();
        if (curr.segmentCount() == 0) {
            return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString(KEY_ENTER_WORKSPACE));
        }
        if (!Path.ROOT.isValidPath(this.workspaceCombo.getText())) {
            return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString(KEY_INVALID_WORKSPACE));
        }
        File file = curr.toFile();
        if (file.isFile()) {
            return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString(KEY_EXISTING_WORKSPACE));
        }
        return AbstractLauncherTab.createStatus(0, KEY_DESC);
    }

    public IVMInstall getVMInstall() {
        int index = this.jreCombo.getSelectionIndex();
        if (index >= 0 && index < this.vmInstallations.length) {
            return this.vmInstallations[index];
        }
        return null;
    }

    public String getVMArguments() {
        return this.vmArgsText.getText().trim();
    }

    public String getProgramArguments() {
        return this.progArgsText.getText().trim();
    }

    public IPath getWorkspaceLocation() {
        return new Path(this.workspaceCombo.getText().trim());
    }

    public boolean doClearWorkspace() {
        return this.clearWorkspaceCheck.getSelection();
    }

    public boolean doAskClear() {
        return this.askClearCheck.getSelection();
    }

    public boolean doShowSplash() {
        return this.showSplashCheck.getSelection();
    }

    public String getApplicationName() {
        return this.applicationNameText.getText().trim();
    }

    static IVMInstall[] getAllVMInstances() {
        ArrayList<IVMInstall> res = new ArrayList<IVMInstall>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] installs = types[i].getVMInstalls();
            int k = 0;
            while (k < installs.length) {
                res.add(installs[k]);
                ++k;
            }
            ++i;
        }
        return res.toArray(new IVMInstall[res.size()]);
    }

    private String[] getVMInstallNames(IVMInstall[] installs) {
        String[] names = new String[installs.length];
        int i = 0;
        while (i < installs.length) {
            names[i] = String.valueOf(installs[i].getName()) + " - " + installs[i].getVMInstallType().getName();
            ++i;
        }
        return names;
    }

    public String getName() {
        return PDEPlugin.getResourceString(KEY_NAME);
    }

    public Image getImage() {
        return this.image;
    }
}

