/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.PluginPathDialog;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class AdvancedLauncherTab
extends AbstractLauncherTab
implements ILaunchConfigurationTab,
ILauncherSettings {
    private static final String KEY_NAME = "AdvancedLauncherTab.name";
    private static final String KEY_WORKSPACE_PLUGINS = "AdvancedLauncherTab.workspacePlugins";
    private static final String KEY_EXTERNAL_PLUGINS = "AdvancedLauncherTab.externalPlugins";
    private static final String KEY_USE_DEFAULT = "AdvancedLauncherTab.useDefault";
    private static final String KEY_USE_FEATURES = "AdvancedLauncherTab.useFeatures";
    private static final String KEY_USE_LIST = "AdvancedLauncherTab.useList";
    private static final String KEY_VISIBLE_LIST = "AdvancedLauncherTab.visibleList";
    private static final String KEY_DEFAULTS = "AdvancedLauncherTab.defaults";
    private static final String KEY_PLUGIN_PATH = "AdvancedLauncherTab.pluginPath";
    private static final String KEY_PLUGIN_PATH_TITLE = "AdvancedLauncherTab.pluginPath.title";
    private static final String KEY_ERROR_NO_PLUGINS = "AdvancedLauncherTab.error.no_plugins";
    private static final String KEY_ERROR_NO_BOOT = "AdvancedLauncherTab.error.no_boot";
    private static final String KEY_ERROR_BROKEN_PLUGINS = "AdvancedLauncherTab.error.brokenPlugins";
    private static final String KEY_ERROR_FEATURE_SETUP = "AdvancedLauncherTab.error.featureSetup";
    private Button useDefaultRadio;
    private Button useFeaturesRadio;
    private Button useListRadio;
    private CheckboxTreeViewer pluginTreeViewer;
    private Label visibleLabel;
    private Label restoreLabel;
    private NamedElement workspacePlugins;
    private NamedElement externalPlugins;
    private IPluginModelBase[] externalModels;
    private IPluginModelBase[] workspaceModels;
    private Button defaultsButton;
    private Button pluginPathButton;
    private int numExternalChecked = 0;
    private int numWorkspaceChecked = 0;
    private boolean firstReveal = true;
    private Image image;

    public AdvancedLauncherTab() {
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.image = PDEPluginImages.DESC_REQ_PLUGINS_OBJ.createImage();
        this.externalModels = PDECore.getDefault().getExternalModelManager().getAllModels();
        this.workspaceModels = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        this.image.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createStartingSpace(composite, 1);
        this.useDefaultRadio = new Button(composite, 16);
        this.useDefaultRadio.setText(PDEPlugin.getResourceString(KEY_USE_DEFAULT));
        this.fillIntoGrid((Control)this.useDefaultRadio, 1, false);
        this.useFeaturesRadio = new Button(composite, 16);
        this.useFeaturesRadio.setText(PDEPlugin.getResourceString(KEY_USE_FEATURES));
        this.fillIntoGrid((Control)this.useFeaturesRadio, 1, false);
        this.useListRadio = new Button(composite, 16);
        this.useListRadio.setText(PDEPlugin.getResourceString(KEY_USE_LIST));
        this.fillIntoGrid((Control)this.useListRadio, 1, false);
        this.visibleLabel = new Label(composite, 0);
        this.visibleLabel.setText(PDEPlugin.getResourceString(KEY_VISIBLE_LIST));
        this.fillIntoGrid((Control)this.visibleLabel, 1, false);
        Control list = this.createPluginList(composite);
        GridData gd = new GridData(1808);
        list.setLayoutData((Object)gd);
        Composite buttonContainer = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 10;
        buttonContainer.setLayout((Layout)layout);
        gd = new GridData(256);
        buttonContainer.setLayoutData((Object)gd);
        this.pluginPathButton = new Button(buttonContainer, 8);
        this.pluginPathButton.setText(PDEPlugin.getResourceString(KEY_PLUGIN_PATH));
        this.pluginPathButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.pluginPathButton);
        this.defaultsButton = new Button(buttonContainer, 8);
        this.defaultsButton.setText(PDEPlugin.getResourceString(KEY_DEFAULTS));
        this.defaultsButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.defaultsButton);
        this.hookListeners();
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.pde.doc.user.launcher_advanced");
    }

    private void hookListeners() {
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AdvancedLauncherTab.this.firstReveal) {
                    AdvancedLauncherTab.this.pluginTreeViewer.reveal((Object)AdvancedLauncherTab.this.workspacePlugins);
                    AdvancedLauncherTab.this.firstReveal = false;
                }
                AdvancedLauncherTab.this.useDefaultChanged();
            }
        };
        this.useDefaultRadio.addSelectionListener((SelectionListener)adapter);
        this.useFeaturesRadio.addSelectionListener((SelectionListener)adapter);
        this.defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)AdvancedLauncherTab.this.pluginTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        AdvancedLauncherTab.access$8(2.access$0(this.this$1));
                        AdvancedLauncherTab.access$9(2.access$0(this.this$1));
                        2.access$0(this.this$1).setChanged(true);
                    }
                });
            }

            static /* synthetic */ AdvancedLauncherTab access$0(2 var0) {
                return var0.AdvancedLauncherTab.this;
            }
        });
        this.pluginPathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.showPluginPaths();
            }
        });
    }

    private void useDefaultChanged() {
        boolean useDefault = !this.useListRadio.getSelection();
        this.adjustCustomControlEnableState(!useDefault);
        this.pluginPathButton.setEnabled(!this.useFeaturesRadio.getSelection());
        this.updateStatus();
    }

    private void adjustCustomControlEnableState(boolean enable) {
        this.visibleLabel.setVisible(enable);
        this.pluginTreeViewer.getTree().setVisible(enable);
        this.defaultsButton.setVisible(enable);
    }

    private GridData fillIntoGrid(Control control, int hspan, boolean grab) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = hspan;
        gd.grabExcessHorizontalSpace = grab;
        control.setLayoutData((Object)gd);
        return gd;
    }

    protected Control createPluginList(final Composite parent) {
        this.pluginTreeViewer = new CheckboxTreeViewer(parent, 2048);
        this.pluginTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginTreeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.pluginTreeViewer.setAutoExpandLevel(2);
        this.pluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(this, element, event){
                    private final /* synthetic */ Object val$element;
                    private final /* synthetic */ CheckStateChangedEvent val$event;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$element = object;
                        this.val$event = checkStateChangedEvent;
                    }

                    public void run() {
                        if (this.val$element instanceof IPluginModelBase) {
                            IPluginModelBase model = (IPluginModelBase)this.val$event.getElement();
                            AdvancedLauncherTab.access$11(5.access$0(this.this$1), model, this.val$event.getChecked());
                        } else {
                            AdvancedLauncherTab.access$12(5.access$0(this.this$1), this.val$element, this.val$event.getChecked());
                        }
                        AdvancedLauncherTab.access$9(5.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ AdvancedLauncherTab access$0(5 var0) {
                return var0.AdvancedLauncherTab.this;
            }
        });
        this.pluginTreeViewer.setSorter((ViewerSorter)new ListUtil.PluginSorter(){

            public int category(Object obj) {
                if (obj == AdvancedLauncherTab.this.workspacePlugins) {
                    return -1;
                }
                if (obj == AdvancedLauncherTab.this.externalPlugins) {
                    return 1;
                }
                return 0;
            }
        });
        Image pluginsImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
        this.workspacePlugins = new NamedElement(PDEPlugin.getResourceString(KEY_WORKSPACE_PLUGINS), pluginsImage);
        this.externalPlugins = new NamedElement(PDEPlugin.getResourceString(KEY_EXTERNAL_PLUGINS), pluginsImage);
        return this.pluginTreeViewer.getTree();
    }

    public void initializeFrom(ILaunchConfiguration config) {
    }

    public static TreeSet parseDeselectedWSIds(ILaunchConfiguration config) throws CoreException {
        TreeSet<String> deselected = new TreeSet<String>();
        String deselectedPluginIDs = config.getAttribute("wsproject", null);
        if (deselectedPluginIDs != null) {
            StringTokenizer tok = new StringTokenizer(deselectedPluginIDs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                deselected.add(token);
            }
        }
        return deselected;
    }

    public static TreeSet parseSelectedExtIds(ILaunchConfiguration config) throws CoreException {
        TreeSet<String> selected = new TreeSet<String>();
        String selectedPluginIDs = config.getAttribute("extplugins", null);
        if (selectedPluginIDs != null) {
            StringTokenizer tok = new StringTokenizer(selectedPluginIDs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int loc = token.lastIndexOf(44);
                if (loc == -1) {
                    selected.add(token);
                    continue;
                }
                if (token.charAt(loc + 1) != 't') continue;
                selected.add(token.substring(0, loc));
            }
        }
        return selected;
    }

    private void initWorkspacePluginsState(ILaunchConfiguration config) throws CoreException {
        this.numWorkspaceChecked = this.workspaceModels.length;
        this.pluginTreeViewer.setSubtreeChecked((Object)this.workspacePlugins, true);
        TreeSet deselected = AdvancedLauncherTab.parseDeselectedWSIds(config);
        int i = 0;
        while (i < this.workspaceModels.length) {
            if (deselected.contains(this.workspaceModels[i].getPluginBase().getId()) && this.pluginTreeViewer.setChecked((Object)this.workspaceModels[i], false)) {
                --this.numWorkspaceChecked;
            }
            ++i;
        }
        if (this.numWorkspaceChecked == 0) {
            this.pluginTreeViewer.setChecked((Object)this.workspacePlugins, false);
        }
        this.pluginTreeViewer.setGrayed((Object)this.workspacePlugins, this.numWorkspaceChecked > 0 && this.numWorkspaceChecked < this.workspaceModels.length);
    }

    private void initExternalPluginsState(ILaunchConfiguration config) throws CoreException {
        this.numExternalChecked = this.externalModels.length;
        this.pluginTreeViewer.setSubtreeChecked((Object)this.externalPlugins, true);
        TreeSet selected = AdvancedLauncherTab.parseSelectedExtIds(config);
        int i = 0;
        while (i < this.externalModels.length) {
            if (!selected.contains(this.externalModels[i].getPluginBase().getId()) && this.pluginTreeViewer.setChecked((Object)this.externalModels[i], false)) {
                --this.numExternalChecked;
            }
            ++i;
        }
        if (this.numExternalChecked == 0) {
            this.pluginTreeViewer.setChecked((Object)this.externalPlugins, false);
        }
        this.pluginTreeViewer.setGrayed((Object)this.externalPlugins, this.numExternalChecked > 0 && this.numExternalChecked < this.externalModels.length);
    }

    public void initialize(ILaunchConfiguration config) {
        try {
            this.useDefaultRadio.setSelection(config.getAttribute("default", true));
            this.useFeaturesRadio.setSelection(config.getAttribute("usefeatures", false));
            this.useListRadio.setSelection(!this.useDefaultRadio.getSelection() && !this.useFeaturesRadio.getSelection());
            if (this.pluginTreeViewer.getInput() == null) {
                this.pluginTreeViewer.setInput((Object)PDEPlugin.getDefault());
            }
            if (this.useDefaultRadio.getSelection()) {
                this.computeInitialCheckState();
            } else if (this.useListRadio.getSelection()) {
                this.initWorkspacePluginsState(config);
                this.initExternalPluginsState(config);
            } else {
                this.pluginPathButton.setEnabled(false);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.adjustCustomControlEnableState(this.useListRadio.getSelection());
        this.updateStatus();
    }

    private void computeInitialCheckState() {
        IPluginModelBase model;
        TreeSet<String> wtable = new TreeSet<String>();
        this.numWorkspaceChecked = 0;
        this.numExternalChecked = 0;
        int i = 0;
        while (i < this.workspaceModels.length) {
            model = this.workspaceModels[i];
            ++this.numWorkspaceChecked;
            String id = model.getPluginBase().getId();
            if (id != null) {
                wtable.add(model.getPluginBase().getId());
            }
            ++i;
        }
        if (this.numWorkspaceChecked > 0) {
            this.pluginTreeViewer.setSubtreeChecked((Object)this.workspacePlugins, true);
        }
        this.pluginTreeViewer.setSubtreeChecked((Object)this.externalPlugins, true);
        this.numExternalChecked = this.externalModels.length;
        i = 0;
        while (i < this.externalModels.length) {
            model = this.externalModels[i];
            boolean masked = wtable.contains(model.getPluginBase().getId());
            if (masked || !model.isEnabled()) {
                this.pluginTreeViewer.setChecked((Object)model, false);
                --this.numExternalChecked;
            }
            ++i;
        }
        if (this.numExternalChecked == 0) {
            this.pluginTreeViewer.setChecked((Object)this.externalPlugins, false);
        }
        this.pluginTreeViewer.setGrayed((Object)this.externalPlugins, this.numExternalChecked > 0 && this.numExternalChecked < this.externalModels.length);
    }

    private void handleCheckStateChanged(IPluginModelBase model, boolean checked) {
        if (model.getUnderlyingResource() == null) {
            this.numExternalChecked = checked ? ++this.numExternalChecked : --this.numExternalChecked;
            this.pluginTreeViewer.setChecked((Object)this.externalPlugins, this.numExternalChecked > 0);
            this.pluginTreeViewer.setGrayed((Object)this.externalPlugins, this.numExternalChecked > 0 && this.numExternalChecked < this.externalModels.length);
        } else {
            this.numWorkspaceChecked = checked ? ++this.numWorkspaceChecked : --this.numWorkspaceChecked;
            this.pluginTreeViewer.setChecked((Object)this.workspacePlugins, this.numWorkspaceChecked > 0);
            this.pluginTreeViewer.setGrayed((Object)this.workspacePlugins, this.numWorkspaceChecked > 0 && this.numWorkspaceChecked < this.workspaceModels.length);
        }
        this.setChanged(true);
    }

    private void handleGroupStateChanged(Object group, boolean checked) {
        this.pluginTreeViewer.setSubtreeChecked(group, checked);
        this.pluginTreeViewer.setGrayed(group, false);
        if (group == this.workspacePlugins) {
            this.numWorkspaceChecked = checked ? this.workspaceModels.length : 0;
        } else if (group == this.externalPlugins) {
            this.numExternalChecked = checked ? this.externalModels.length : 0;
        }
        this.setChanged(true);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("default", true);
        config.setAttribute("usefeatures", false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (!this.isChanged()) {
            return;
        }
        final ILaunchConfigurationWorkingCopy config = configuration;
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                config.setAttribute("default", AdvancedLauncherTab.this.useDefaultRadio.getSelection());
                config.setAttribute("usefeatures", AdvancedLauncherTab.this.useFeaturesRadio.getSelection());
                if (!AdvancedLauncherTab.this.useListRadio.getSelection()) {
                    AdvancedLauncherTab.this.setChanged(false);
                    return;
                }
                StringBuffer wbuf = new StringBuffer();
                int i = 0;
                while (i < AdvancedLauncherTab.this.workspaceModels.length) {
                    IPluginModelBase model = AdvancedLauncherTab.this.workspaceModels[i];
                    if (!AdvancedLauncherTab.this.pluginTreeViewer.getChecked((Object)model)) {
                        wbuf.append(String.valueOf(model.getPluginBase().getId()) + File.pathSeparatorChar);
                    }
                    ++i;
                }
                config.setAttribute("wsproject", wbuf.toString());
                StringBuffer exbuf = new StringBuffer();
                Object[] checked = AdvancedLauncherTab.this.pluginTreeViewer.getCheckedElements();
                int i2 = 0;
                while (i2 < checked.length) {
                    Object element = checked[i2];
                    if (element instanceof ExternalPluginModelBase) {
                        ExternalPluginModelBase model = (ExternalPluginModelBase)element;
                        exbuf.append(String.valueOf(model.getPluginBase().getId()) + File.pathSeparatorChar);
                    }
                    ++i2;
                }
                config.setAttribute("extplugins", exbuf.toString());
                AdvancedLauncherTab.this.setChanged(false);
            }
        });
    }

    private void showPluginPaths() {
        IPluginModelBase[] plugins = this.getPlugins();
        try {
            URL[] urls = TargetPlatform.createPluginPath((IPluginModelBase[])plugins);
            PluginPathDialog dialog = new PluginPathDialog(this.pluginPathButton.getShell(), urls);
            dialog.create();
            dialog.getShell().setText(PDEPlugin.getResourceString(KEY_PLUGIN_PATH_TITLE));
            dialog.getShell().setSize(500, 500);
            dialog.open();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void updateStatus() {
        this.updateStatus(this.validatePlugins());
    }

    private IStatus validatePlugins() {
        if (!this.useFeaturesRadio.getSelection()) {
            IPluginModelBase[] plugins = this.getPlugins();
            if (plugins.length == 0) {
                return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString(KEY_ERROR_NO_PLUGINS));
            }
            IPluginModelBase boot = this.findModel("org.eclipse.core.boot", plugins);
            if (boot == null) {
                return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString(KEY_ERROR_NO_BOOT));
            }
            int i = 0;
            while (i < plugins.length) {
                IPluginModelBase model = plugins[i];
                if (!model.isLoaded()) {
                    return AbstractLauncherTab.createStatus(2, PDEPlugin.getResourceString(KEY_ERROR_BROKEN_PLUGINS));
                }
                ++i;
            }
        } else {
            IPath featurePath;
            IPath workspacePath = PDEPlugin.getWorkspace().getRoot().getLocation();
            String lastSegment = workspacePath.lastSegment();
            boolean badSetup = false;
            if (!lastSegment.equalsIgnoreCase("plugins")) {
                badSetup = true;
            }
            if (!(featurePath = workspacePath.removeLastSegments(1).append("features")).toFile().exists()) {
                badSetup = true;
            }
            if (badSetup) {
                return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString(KEY_ERROR_FEATURE_SETUP));
            }
        }
        return AbstractLauncherTab.createStatus(0, "");
    }

    private IPluginModelBase findModel(String id, IPluginModelBase[] models) {
        int i = 0;
        while (i < models.length) {
            String pid;
            IPluginModelBase model = models[i];
            IPluginBase pluginBase = model.getPluginBase();
            if (pluginBase != null && (pid = pluginBase.getId()) != null && pid.equals(id)) {
                return model;
            }
            ++i;
        }
        return null;
    }

    public IPluginModelBase[] getPlugins() {
        ArrayList<Object> res = new ArrayList<Object>();
        boolean useDefault = this.useDefaultRadio.getSelection();
        if (useDefault) {
            TreeSet<String> wtable = new TreeSet<String>();
            int i = 0;
            while (i < this.workspaceModels.length) {
                if (this.workspaceModels[i].getPluginBase().getId() != null) {
                    res.add(this.workspaceModels[i]);
                    wtable.add(this.workspaceModels[i].getPluginBase().getId());
                }
                ++i;
            }
            i = 0;
            while (i < this.externalModels.length) {
                IPluginModelBase model = this.externalModels[i];
                boolean masked = wtable.contains(model.getPluginBase().getId());
                if (!masked && this.externalModels[i].isEnabled()) {
                    res.add(this.externalModels[i]);
                }
                ++i;
            }
        } else {
            Object[] elements = this.pluginTreeViewer.getCheckedElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IPluginModelBase) {
                    res.add(elements[i]);
                }
                ++i;
            }
        }
        return res.toArray(new IPluginModelBase[res.size()]);
    }

    public String getName() {
        return PDEPlugin.getResourceString(KEY_NAME);
    }

    public Image getImage() {
        return this.image;
    }

    static /* synthetic */ void access$8(AdvancedLauncherTab advancedLauncherTab) {
        advancedLauncherTab.computeInitialCheckState();
    }

    static /* synthetic */ void access$9(AdvancedLauncherTab advancedLauncherTab) {
        advancedLauncherTab.updateStatus();
    }

    static /* synthetic */ void access$11(AdvancedLauncherTab advancedLauncherTab, IPluginModelBase iPluginModelBase, boolean bl) {
        advancedLauncherTab.handleCheckStateChanged(iPluginModelBase, bl);
    }

    static /* synthetic */ void access$12(AdvancedLauncherTab advancedLauncherTab, Object object, boolean bl) {
        advancedLauncherTab.handleGroupStateChanged(object, bl);
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModelBase);
        }

        public Object[] getChildren(Object parent) {
            if (parent == AdvancedLauncherTab.this.externalPlugins) {
                return AdvancedLauncherTab.this.externalModels;
            }
            if (parent == AdvancedLauncherTab.this.workspacePlugins) {
                return AdvancedLauncherTab.this.workspaceModels;
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)child;
                if (model.getUnderlyingResource() != null) {
                    return AdvancedLauncherTab.this.workspacePlugins;
                }
                return AdvancedLauncherTab.this.externalPlugins;
            }
            return null;
        }

        public Object[] getElements(Object input) {
            return new Object[]{AdvancedLauncherTab.this.workspacePlugins, AdvancedLauncherTab.this.externalPlugins};
        }
    }
}

