/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class AbstractLauncherTab
extends AbstractLaunchConfigurationTab {
    private boolean valid = true;
    private boolean changed = false;

    protected boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    protected void createStartingSpace(Composite parent, int span) {
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalSpan = span;
        label.setLayoutData((Object)data);
    }

    public void launched(ILaunch launch) {
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.valid;
    }

    public void setValid(boolean value) {
        this.valid = value;
    }

    protected void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        AbstractLauncherTab.applyToStatusLine(this, status);
    }

    public static void applyToStatusLine(AbstractLauncherTab tab, IStatus status) {
        String errorMessage = null;
        String warningMessage = null;
        String statusMessage = status.getMessage();
        if (statusMessage.length() > 0) {
            if (status.matches(4)) {
                errorMessage = statusMessage;
            } else if (!status.isOK()) {
                warningMessage = statusMessage;
            }
        }
        tab.setErrorMessage(errorMessage);
        tab.setMessage(warningMessage);
        tab.updateLaunchConfigurationDialog();
    }

    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1.getSeverity() >= s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    public static IStatus createStatus(int severity, String message) {
        return new Status(severity, PDEPlugin.getPluginId(), severity, message, null);
    }

    protected void updateLaunchConfigurationDialog() {
        this.setChanged(true);
        super.updateLaunchConfigurationDialog();
    }
}

