/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.feature.SiteData;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewSiteProjectWizard
extends NewWizard
implements IExecutableExtension {
    public static final String KEY_WTITLE = "NewSiteWizard.wtitle";
    public static final String MAIN_PAGE_TITLE = "NewSiteWizard.MainPage.title";
    public static final String CREATING_PROJECT = "NewSiteWizard.creatingProject";
    public static final String CREATING_FOLDERS = "NewSiteWizard.creatingFolders";
    public static final String CREATING_MANIFEST = "NewSiteWizard.creatingManifest";
    public static final String MAIN_PAGE_DESC = "NewSiteWizard.MainPage.desc";
    public static final String OVERWRITE_SITE = "NewFeatureWizard.overwriteSite";
    private WizardNewProjectCreationPage mainPage;
    private IConfigurationElement config;

    public NewSiteProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWSITEPRJ_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
    }

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage("main");
        this.mainPage.setTitle(PDEPlugin.getResourceString(MAIN_PAGE_TITLE));
        this.mainPage.setDescription(PDEPlugin.getResourceString(MAIN_PAGE_DESC));
        this.addPage((IWizardPage)this.mainPage);
    }

    private IFile createSiteManifest(IProject project, SiteData data) throws CoreException {
        IFile file = project.getFile("site.xml");
        if (file.exists()) {
            return file;
        }
        WorkspaceSiteModel model = new WorkspaceSiteModel();
        model.setFile(file);
        ISite site = model.getSite();
        String name = project.getName();
        site.setLabel(name);
        site.setType(data.type);
        site.setURL(data.url);
        model.save();
        model.dispose();
        WorkspaceSiteBuildModel buildModel = new WorkspaceSiteBuildModel();
        IFile buildFile = project.getFile(".sitebuild/sitebuild.xml");
        buildModel.setFile(buildFile);
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        siteBuild.setAutobuild(false);
        siteBuild.setPluginLocation((IPath)new Path("plugins"));
        siteBuild.setFeatureLocation((IPath)new Path("features"));
        siteBuild.setShowConsole(true);
        buildModel.save();
        buildModel.dispose();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getEditorRegistry().setDefaultEditor(file, "org.eclipse.pde.ui.siteEditor");
        return file;
    }

    private void createSiteProject(IProject project, IPath location, SiteData data, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(CREATING_PROJECT), 4);
        boolean overwrite = true;
        if (location.append(project.getName()).toFile().exists()) {
            overwrite = MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)this.getWindowTitle(), (String)PDEPlugin.getResourceString(OVERWRITE_SITE));
        }
        if (overwrite) {
            CoreUtility.createProject((IProject)project, (IPath)location, (IProgressMonitor)monitor);
            project.open(monitor);
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.UpdateSiteNature", (IProgressMonitor)monitor);
            this.createFolders(project, monitor);
            monitor.worked(2);
            monitor.subTask(PDEPlugin.getResourceString(CREATING_MANIFEST));
            IFile file = this.createSiteManifest(project, data);
            monitor.worked(1);
            this.openSiteManifest(file);
            monitor.worked(1);
        } else {
            project.create(monitor);
            project.open(monitor);
            IFile siteFile = project.getFile("site.xml");
            if (siteFile.exists()) {
                this.openSiteManifest(siteFile);
            }
            monitor.worked(4);
        }
    }

    private void createFolders(IProject project, IProgressMonitor monitor) throws CoreException {
        this.createFolder(project, "features", monitor);
        this.createFolder(project, "plugins", monitor);
        this.createFolder(project, ".sitebuild", monitor);
    }

    private void createFolder(IProject project, String name, IProgressMonitor monitor) throws CoreException {
        IFolder plugins = project.getFolder(name);
        if (!plugins.exists()) {
            plugins.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    private void openSiteManifest(IFile manifestFile) {
        IWorkbenchPage page = PDEPlugin.getActivePage();
        StructuredSelection selection = new StructuredSelection((Object)manifestFile);
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$selection);
                }
            });
        }
        FileEditorInput input = new FileEditorInput(manifestFile);
        String id = "org.eclipse.pde.ui.siteEditor";
        try {
            page.openEditor((IEditorInput)input, id);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    public boolean performFinish() {
        final IProject project = this.mainPage.getProjectHandle();
        final IPath location = this.mainPage.getLocationPath();
        final SiteData data = new SiteData();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        NewSiteProjectWizard.this.createSiteProject(project, location, data, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_5 = null;
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String property, Object data) throws CoreException {
        this.config = config;
    }
}

