/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.FragmentBuildScriptGenerator;
import org.eclipse.pde.internal.build.PluginBuildScriptGenerator;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class BuildPluginAction
implements IObjectActionDelegate {
    public static final String KEY_ERRORS_TITLE = "GeneratePluginJars.errorsTitle";
    public static final String KEY_ERRORS_MESSAGE = "GeneratePluginJars.errorsMessage";
    public static final String KEY_ERRORS_FMESSAGE = "GeneratePluginJars.errorsFMessage";
    public static final String KEY_VERIFYING = "GeneratePluginJars.verifying";
    public static final String KEY_GENERATING = "GeneratePluginJars.generating";
    public static final String KEY_UPDATING = "GeneratePluginJars.updating";
    private IWorkbenchPart targetPart;
    private IFile pluginBaseFile;
    private boolean fragment;
    private boolean errors;

    public IFile getPluginBaseFile() {
        return this.pluginBaseFile;
    }

    public void run(IAction action) {
        if (this.pluginBaseFile == null) {
            return;
        }
        if (!this.pluginBaseFile.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IWorkspaceRunnable wop = new IWorkspaceRunnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            BuildPluginAction.access$0(1.access$0(this.this$1), monitor);
                        }
                        catch (InvocationTargetException e) {
                            BuildPluginAction.access$1(1.access$0(this.this$1), e);
                        }
                    }
                };
                try {
                    PDEPlugin.getWorkspace().run(wop, monitor);
                }
                catch (CoreException e) {
                    BuildPluginAction.this.syncLogException(e);
                }
            }

            static /* synthetic */ BuildPluginAction access$0(1 var0) {
                return var0.BuildPluginAction.this;
            }
        };
        this.errors = false;
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(PDEPlugin.getActiveWorkbenchShell());
        try {
            pmd.run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
    }

    private void syncLogException(final Throwable e) {
        Display display = SWTUtil.getStandardDisplay();
        if (display != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    PDEPlugin.logException(e);
                }
            });
        } else {
            PDEPlugin.log(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        IFile file = null;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IFile) {
            file = (IFile)obj;
            String name = file.getName().toLowerCase();
            if (name.equals("plugin.xml")) {
                this.fragment = false;
            } else if (name.equals("fragment.xml")) {
                this.fragment = true;
            } else {
                file = null;
            }
        }
        this.pluginBaseFile = file;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void setPluginBaseFile(IFile pluginBaseFile) {
        this.pluginBaseFile = pluginBaseFile;
    }

    private void doBuildPlugin(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(KEY_VERIFYING), 3);
        if (!this.ensureValid(monitor)) {
            this.errors = true;
            return;
        }
        monitor.worked(1);
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_GENERATING));
        this.makeScripts(monitor);
        monitor.worked(1);
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_UPDATING));
        this.refreshLocal(monitor);
        monitor.worked(1);
        monitor.done();
    }

    private boolean ensureValid(IProgressMonitor monitor) throws CoreException {
        IProject project = this.pluginBaseFile.getProject();
        if (!project.getWorkspace().isAutoBuilding()) {
            project.build(10, monitor);
        }
        if (this.hasErrors(this.pluginBaseFile)) {
            String message = this.fragment ? PDEPlugin.getResourceString(KEY_ERRORS_FMESSAGE) : PDEPlugin.getResourceString(KEY_ERRORS_MESSAGE);
            MessageDialog.openError(null, (String)PDEPlugin.getResourceString(KEY_ERRORS_TITLE), (String)message);
            return false;
        }
        return true;
    }

    private boolean hasErrors(IFile file) throws CoreException {
        IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        int i = 0;
        while (i < markers.length) {
            Integer severity;
            IMarker marker = markers[i];
            Object att = marker.getAttribute("severity");
            if (att != null && att instanceof Integer && (severity = (Integer)att) == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        Object generator = this.fragment ? new FragmentBuildScriptGenerator() : new PluginBuildScriptGenerator();
        String scriptName = MainPreferencePage.getBuildScriptName();
        generator.setBuildScriptName(scriptName);
        IProject project = this.pluginBaseFile.getProject();
        IPluginModelBase model = (IPluginModelBase)PDECore.getDefault().getWorkspaceModelManager().getWorkspaceModel(project);
        IPath platform = Platform.getLocation().append(model.getUnderlyingResource().getProject().getName());
        generator.setInstallLocation(platform.toOSString());
        generator.setDevEntries(new String[]{"bin"});
        URL[] pluginPath = TargetPlatform.createPluginPath();
        generator.setPluginPath(pluginPath);
        try {
            generator.setModelId(model.getPluginBase().getId());
            generator.generate();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private void refreshLocal(IProgressMonitor monitor) throws CoreException {
        this.pluginBaseFile.getProject().refreshLocal(2, monitor);
    }

    static /* synthetic */ void access$0(BuildPluginAction buildPluginAction, IProgressMonitor iProgressMonitor) {
        buildPluginAction.doBuildPlugin(iProgressMonitor);
    }
}

