/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class BuildFeatureAction
implements IObjectActionDelegate {
    public static final String KEY_ERRORS_TITLE = "GenerateFeatureJars.errorsTitle";
    public static final String KEY_ERRORS_MESSAGE = "GenerateFeatureJars.errorsMessage";
    public static final String KEY_VERIFYING = "GenerateFeatureJars.verifying";
    public static final String KEY_GENERATING = "GenerateFeatureJars.generating";
    public static final String KEY_UPDATING = "GenerateFeatureJars.updating";
    private IWorkbenchPart targetPart;
    private IFile featureFile;
    private boolean errors;

    public IFile getFeatureFile() {
        return this.featureFile;
    }

    public void run(IAction action) {
        if (this.featureFile == null) {
            return;
        }
        if (!this.featureFile.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IWorkspaceRunnable wop = new IWorkspaceRunnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            BuildFeatureAction.access$0(1.access$0(this.this$1), monitor);
                        }
                        catch (InvocationTargetException e) {
                            BuildFeatureAction.access$1(1.access$0(this.this$1), e);
                        }
                    }
                };
                try {
                    PDEPlugin.getWorkspace().run(wop, monitor);
                }
                catch (CoreException e) {
                    BuildFeatureAction.this.syncLogException(e);
                }
            }

            static /* synthetic */ BuildFeatureAction access$0(1 var0) {
                return var0.BuildFeatureAction.this;
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(PDEPlugin.getActiveWorkbenchShell());
        try {
            this.errors = false;
            pmd.run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
    }

    private void syncLogException(final Throwable e) {
        Display display = SWTUtil.getStandardDisplay();
        if (display != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    PDEPlugin.logException(e);
                }
            });
        } else {
            PDEPlugin.log(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        String name;
        Object obj;
        IFile file = null;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IFile && !(name = (file = (IFile)obj).getName().toLowerCase()).equals("feature.xml")) {
            file = null;
        }
        this.featureFile = file;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void setFeatureFile(IFile featureFile) {
        this.featureFile = featureFile;
    }

    private void doBuildFeature(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(KEY_VERIFYING), 3);
        if (!this.ensureValid(monitor)) {
            this.errors = true;
            return;
        }
        monitor.worked(1);
        WorkspaceFeatureModel model = new WorkspaceFeatureModel(this.featureFile);
        model.load();
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_GENERATING));
        this.makeScripts((IFeatureModel)model, monitor);
        monitor.worked(1);
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_UPDATING));
        this.refreshLocal((IFeatureModel)model, monitor);
        monitor.worked(1);
        monitor.done();
    }

    private boolean ensureValid(IProgressMonitor monitor) throws CoreException {
        IProject project = this.featureFile.getProject();
        if (!project.getWorkspace().isAutoBuilding()) {
            project.build(10, monitor);
        }
        if (this.hasErrors(this.featureFile)) {
            String message = PDEPlugin.getResourceString(KEY_ERRORS_MESSAGE);
            MessageDialog.openError(null, (String)PDEPlugin.getResourceString(KEY_ERRORS_TITLE), (String)message);
            return false;
        }
        return true;
    }

    private boolean hasErrors(IFile file) throws CoreException {
        IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        int i = 0;
        while (i < markers.length) {
            Integer severity;
            IMarker marker = markers[i];
            Object att = marker.getAttribute("severity");
            if (att != null && att instanceof Integer && (severity = (Integer)att) == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void makeScripts(IFeatureModel model, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        FeatureBuildScriptGenerator generator = new FeatureBuildScriptGenerator();
        String scriptName = MainPreferencePage.getBuildScriptName();
        generator.setBuildScriptName(scriptName);
        generator.setFeatureRootLocation(this.getFeatureFile().getParent().getLocation().toOSString());
        IPath platform = Platform.getLocation().append(this.featureFile.getProject().getName());
        generator.setInstallLocation(platform.toOSString());
        generator.setDevEntries(new String[]{"bin"});
        URL[] pluginPath = TargetPlatform.createPluginPath();
        generator.setPluginPath(pluginPath);
        try {
            monitor.subTask(PDEPlugin.getResourceString(KEY_GENERATING));
            generator.setFeature(model.getFeature().getId());
            generator.generate();
            monitor.subTask(PDEPlugin.getResourceString(KEY_UPDATING));
        }
        catch (Exception e) {
            PDEPlugin.logException(e);
        }
    }

    private void refreshLocal(IFeature feature, IProgressMonitor monitor) throws CoreException {
        IFeaturePlugin[] references = feature.getPlugins();
        int i = 0;
        while (i < references.length) {
            IFeaturePlugin ref = references[i];
            IPluginModelBase refmodel = feature.getReferencedModel(ref);
            if (refmodel != null) {
                refmodel.getUnderlyingResource().getProject().refreshLocal(2, monitor);
            }
            ++i;
        }
    }

    private void refreshLocal(IFeatureModel model, IProgressMonitor monitor) throws CoreException {
        this.featureFile.getProject().refreshLocal(2, monitor);
        IFeature feature = model.getFeature();
        this.refreshLocal(feature, monitor);
    }

    static /* synthetic */ void access$0(BuildFeatureAction buildFeatureAction, IProgressMonitor iProgressMonitor) {
        buildFeatureAction.doBuildFeature(iProgressMonitor);
    }
}

