/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;

public class StateListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private ArrayList dirtyProjects = new ArrayList();
    private ISiteModel model;
    private boolean active = false;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public StateListener(ISiteModel siteModel) {
        this.model = siteModel;
        PDEPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 8);
    }

    public void resourceChanged(IResourceChangeEvent e) {
        if (e.getType() == 8) {
            try {
                e.getDelta().accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException ex) {
                PDEPlugin.logException(ex);
            }
        }
    }

    public void setBuilt(ISiteBuildFeature sbfeature) {
        IProject sbproject = this.getProject(sbfeature);
        if (sbproject != null) {
            this.removeProject(sbproject);
        }
    }

    public void removeProject(IProject project) {
        if (this.dirtyProjects.contains(project)) {
            ((AbstractCollection)this.dirtyProjects).remove(project);
        }
    }

    public void removeAllProjects() {
        this.dirtyProjects.clear();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource instanceof IProject) {
            this.handleDirtyProject((IProject)resource);
            return false;
        }
        return true;
    }

    private void handleDirtyProject(IProject project) {
        IProject relatedProject = this.getRelatedProject(project);
        if (relatedProject != null && !this.dirtyProjects.contains(relatedProject)) {
            this.dirtyProjects.add(relatedProject);
        }
    }

    public boolean isDirty(ISiteBuildFeature sbfeature) {
        IProject sbproject = this.getProject(sbfeature);
        if (sbproject != null) {
            return this.dirtyProjects.contains(sbproject);
        }
        return false;
    }

    private IProject getRelatedProject(IProject project) {
        ISiteBuildModel buildModel = this.model.getBuildModel();
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        ISiteBuildFeature[] features = siteBuild.getFeatures();
        int i = 0;
        while (i < features.length) {
            ISiteBuildFeature sbfeature = features[i];
            IProject sbproject = this.getProject(sbfeature);
            if (sbproject != null && sbproject.equals((Object)project)) {
                return sbproject;
            }
            if (this.isReferencedPluginProject(sbfeature, project)) {
                return sbproject;
            }
            ++i;
        }
        return null;
    }

    private boolean isReferencedPluginProject(ISiteBuildFeature sbfeature, IProject project) {
        IFeature referencedFeature = sbfeature.getReferencedFeature();
        if (referencedFeature != null) {
            IFeaturePlugin[] plugins = referencedFeature.getPlugins();
            int i = 0;
            while (i < plugins.length) {
                IResource resource;
                IFeaturePlugin plugin = plugins[i];
                String id = plugin.getId();
                String version = plugin.getVersion();
                boolean fragment = plugin.isFragment();
                IPluginModelBase model = PDECore.getDefault().getModelManager().findPlugin(id, version, 3);
                if (model != null && model.isFragmentModel() == fragment && (resource = model.getUnderlyingResource()) != null && resource.getProject().equals((Object)project)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private IProject getProject(ISiteBuildFeature sbfeature) {
        IResource resource;
        IFeature referencedFeature = sbfeature.getReferencedFeature();
        if (referencedFeature != null && (resource = referencedFeature.getModel().getUnderlyingResource()) != null) {
            return resource.getProject();
        }
        return null;
    }

    public void dispose() {
        PDEPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }
}

