/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.core.site.SiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;

public class SiteUndoManager
extends ModelUndoManager {
    ISiteModel model;
    ISiteBuildModel buildModel;

    public SiteUndoManager(PDEMultiPageEditor editor) {
        super(editor);
        this.setUndoLevelLimit(30);
    }

    public void connect(IModelChangeProvider provider) {
        this.model = (ISiteModel)provider;
        this.buildModel = this.model.getBuildModel();
        super.connect(provider);
        super.connect((IModelChangeProvider)this.buildModel);
    }

    public void disconnect(IModelChangeProvider provider) {
        this.model = (ISiteModel)provider;
        this.buildModel = this.model.getBuildModel();
        super.disconnect(provider);
        super.disconnect((IModelChangeProvider)this.buildModel);
    }

    protected String getPageId(Object obj) {
        if (obj instanceof ISiteBuildFeature) {
            return "BuildPage";
        }
        if (obj instanceof ISiteFeature) {
            return "FeaturePage";
        }
        if (obj instanceof ISiteArchive) {
            return "ArchivePage";
        }
        if (obj instanceof ISiteCategory) {
            return "FeaturePage";
        }
        if (obj instanceof ISiteCategoryDefinition) {
            return "SitePage";
        }
        return null;
    }

    protected void execute(IModelChangedEvent event, boolean undo) {
        Object[] elements = event.getChangedObjects();
        int type = event.getChangeType();
        String propertyName = event.getChangedProperty();
        switch (type) {
            case 1: {
                if (undo) {
                    this.executeRemove(elements);
                    break;
                }
                this.executeAdd(elements);
                break;
            }
            case 2: {
                if (undo) {
                    this.executeAdd(elements);
                    break;
                }
                this.executeRemove(elements);
                break;
            }
            case 3: {
                if (undo) {
                    this.executeChange(elements[0], propertyName, event.getNewValue(), event.getOldValue());
                    break;
                }
                this.executeChange(elements[0], propertyName, event.getOldValue(), event.getNewValue());
            }
        }
    }

    private void executeAdd(Object[] elements) {
        ISite site = this.model.getSite();
        ISiteBuild siteBuild = this.model.getBuildModel().getSiteBuild();
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof ISiteFeature) {
                    site.addFeatures(new ISiteFeature[]{(ISiteFeature)element});
                } else if (element instanceof ISiteBuildFeature) {
                    siteBuild.addFeatures(new ISiteBuildFeature[]{(ISiteBuildFeature)element});
                } else if (element instanceof ISiteArchive) {
                    site.addArchives(new ISiteArchive[]{(ISiteArchive)element});
                } else if (element instanceof ISiteCategoryDefinition) {
                    site.addCategoryDefinitions(new ISiteCategoryDefinition[]{(ISiteCategoryDefinition)element});
                } else if (element instanceof ISiteCategory) {
                    ISiteCategory category = (ISiteCategory)element;
                    ISiteFeature feature = (ISiteFeature)category.getParent();
                    feature.addCategories(new ISiteCategory[]{category});
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeRemove(Object[] elements) {
        ISite site = this.model.getSite();
        ISiteBuild siteBuild = this.model.getBuildModel().getSiteBuild();
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof ISiteFeature) {
                    site.removeFeatures(new ISiteFeature[]{(ISiteFeature)element});
                } else if (element instanceof ISiteBuildFeature) {
                    siteBuild.removeFeatures(new ISiteBuildFeature[]{(ISiteBuildFeature)element});
                } else if (element instanceof ISiteArchive) {
                    site.removeArchives(new ISiteArchive[]{(ISiteArchive)element});
                } else if (element instanceof ISiteCategoryDefinition) {
                    site.removeCategoryDefinitions(new ISiteCategoryDefinition[]{(ISiteCategoryDefinition)element});
                } else if (element instanceof ISiteCategory) {
                    ISiteCategory category = (ISiteCategory)element;
                    ISiteFeature feature = (ISiteFeature)category.getParent();
                    feature.removeCategories(new ISiteCategory[]{category});
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeChange(Object element, String propertyName, Object oldValue, Object newValue) {
        if (element instanceof SiteObject) {
            SiteObject sobj = (SiteObject)element;
            try {
                sobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        ISiteObject obj;
        if (event.getChangeType() == 3 && !((obj = (ISiteObject)event.getChangedObjects()[0]) instanceof ISite) && !obj.isInTheModel()) {
            return;
        }
        super.modelChanged(event);
    }
}

