/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.site.ArchivePage;
import org.eclipse.pde.internal.ui.editor.site.FeaturePage;
import org.eclipse.pde.internal.ui.editor.site.SitePage;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.swt.widgets.Composite;

public class SiteOutlinePage
extends FormOutlinePage {
    private static final String KEY_REFERENCED_PLUGINS = "FeatureEditor.Outline.referencedPlugins";
    private static final String KEY_REQUIRED_PLUGINS = "FeatureEditor.Outline.requiredPlugins";
    private NamedElement referencedPlugins;
    private NamedElement requiredPlugins;

    public SiteOutlinePage(PDEFormPage formPage) {
        super(formPage);
    }

    protected ITreeContentProvider createContentProvider() {
        return new ContentProvider();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        ISiteModel model = (ISiteModel)this.formPage.getModel();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    protected ILabelProvider createLabelProvider() {
        return PDEPlugin.getDefault().getLabelProvider();
    }

    public void dispose() {
        super.dispose();
        ISiteModel model = (ISiteModel)this.formPage.getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
    }

    public IPDEEditorPage getParentPage(Object item) {
        if (item instanceof ISiteFeature) {
            return this.formPage.getEditor().getPage("FeaturePage");
        }
        if (item instanceof ISiteCategoryDefinition) {
            return this.formPage.getEditor().getPage("SitePage");
        }
        if (item instanceof ISiteArchive) {
            return this.formPage.getEditor().getPage("ArchivePage");
        }
        return super.getParentPage(item);
    }

    private Object[] getCategoryDefs() {
        ISiteModel model = (ISiteModel)this.formPage.getModel();
        ISite site = model.getSite();
        return site.getCategoryDefinitions();
    }

    private Object[] getFeatures() {
        ISiteModel model = (ISiteModel)this.formPage.getModel();
        ISite site = model.getSite();
        return site.getFeatures();
    }

    private Object[] getArchives() {
        ISiteModel model = (ISiteModel)this.formPage.getModel();
        ISite site = model.getSite();
        return site.getArchives();
    }

    public Object getParent(Object object) {
        return this.getParentPage(object);
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.treeViewer.refresh();
            return;
        }
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
    }

    class ContentProvider
    extends FormOutlinePage.BasicContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof SitePage) {
                return SiteOutlinePage.this.getCategoryDefs();
            }
            if (parent instanceof FeaturePage) {
                return SiteOutlinePage.this.getFeatures();
            }
            if (parent instanceof ArchivePage) {
                return SiteOutlinePage.this.getArchives();
            }
            return super.getChildren(parent);
        }

        public Object getParent(Object child) {
            IPDEEditorPage parent = SiteOutlinePage.this.getParentPage(child);
            if (parent != null) {
                return parent;
            }
            return super.getParent(child);
        }
    }
}

