/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.editor.site.CategoryDefinitionSection;
import org.eclipse.pde.internal.ui.editor.site.SiteDescriptionSection;
import org.eclipse.pde.internal.ui.editor.site.SitePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.ScrollableSectionForm;

public class SiteForm
extends ScrollableSectionForm {
    private SitePage page;
    private SiteDescriptionSection descriptionSection;
    private CategoryDefinitionSection categorySection;

    public SiteForm(SitePage page) {
        this.page = page;
        this.setVerticalFit(true);
    }

    protected void createFormClient(Composite parent) {
        FormWidgetFactory factory = this.getFactory();
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 15;
        this.descriptionSection = new SiteDescriptionSection(this.page);
        Control control = this.descriptionSection.createControl(parent, factory);
        GridData gd = new GridData(770);
        control.setLayoutData((Object)gd);
        this.categorySection = new CategoryDefinitionSection(this.page);
        control = this.categorySection.createControl(parent, factory);
        gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        this.registerSection(this.descriptionSection);
        this.registerSection(this.categorySection);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.manifest_site_overview");
    }

    public void expandTo(Object object) {
        this.categorySection.expandTo(object);
    }

    public void initialize(Object modelObject) {
        ISiteModel model = (ISiteModel)modelObject;
        super.initialize((Object)model);
        IEditorInput input = this.page.getEditor().getEditorInput();
        String name = input.getName();
        this.setHeadingText(model.getResourceString(name));
        ((Composite)this.getControl()).layout(true);
    }

    public void setFocus() {
        this.descriptionSection.setFocus();
    }
}

