/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEEditorContributor;
import org.eclipse.pde.internal.ui.editor.site.BuildControlSection;
import org.eclipse.pde.internal.ui.editor.site.SiteEditor;
import org.eclipse.swt.dnd.Clipboard;

public class SiteEditorContributor
extends PDEEditorContributor {
    private Action buildAction;
    private Action rebuildAllAction;

    public SiteEditorContributor() {
        super("Site");
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        super.contextMenuAboutToShow(mng);
        mng.add((IContributionItem)new Separator());
        mng.add((IAction)this.buildAction);
        mng.add((IAction)this.rebuildAllAction);
    }

    protected void makeActions() {
        super.makeActions();
        this.buildAction = new Action(){

            public void run() {
                SiteEditor editor = (SiteEditor)SiteEditorContributor.this.getEditor();
                BuildControlSection.handleBuild(editor, false);
            }
        };
        this.buildAction.setText(PDEPlugin.getResourceString("SiteEditorContributor.build"));
        this.rebuildAllAction = new Action(){

            public void run() {
                SiteEditor editor = (SiteEditor)SiteEditorContributor.this.getEditor();
                BuildControlSection.handleBuild(editor, true);
            }
        };
        this.rebuildAllAction.setText(PDEPlugin.getResourceString("SiteEditorContributor.rebuildAll"));
    }

    protected boolean hasKnownTypes(Clipboard clipboard) {
        return true;
    }
}

