/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageXMLEditor;
import org.eclipse.pde.internal.ui.editor.site.ArchivePage;
import org.eclipse.pde.internal.ui.editor.site.BuildPage;
import org.eclipse.pde.internal.ui.editor.site.FeaturePage;
import org.eclipse.pde.internal.ui.editor.site.SitePage;
import org.eclipse.pde.internal.ui.editor.site.SiteSourcePage;
import org.eclipse.pde.internal.ui.editor.site.SiteUndoManager;
import org.eclipse.pde.internal.ui.editor.site.StateListener;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class SiteEditor
extends PDEMultiPageXMLEditor {
    public static final String SITE_PAGE = "SitePage";
    public static final String BUILD_PAGE = "BuildPage";
    public static final String FEATURE_PAGE = "FeaturePage";
    public static final String ARCHIVE_PAGE = "ArchivePage";
    public static final String SOURCE_PAGE = "SourcePage";
    public static final String SITE_PAGE_TITLE = "MultiPageSiteEditor.SitePage.title";
    public static final String BUILD_PAGE_TITLE = "MultiPageSiteEditor.BuildPage.title";
    public static final String FEATURE_PAGE_TITLE = "MultiPageSiteEditor.FeaturePage.title";
    public static final String ARCHIVE_PAGE_TITLE = "MultiPageSiteEditor.ArchivePage.title";
    public static final String SOURCE_PAGE_TITLE = "MultiPageSiteEditor.SourcePage.title";
    private boolean storageModel = false;
    private StateListener stateListener;

    protected IModelUndoManager createModelUndoManager() {
        return new SiteUndoManager(this);
    }

    public boolean canCopy(ISelection selection) {
        return true;
    }

    protected Object createModel(Object input) throws CoreException {
        if (input instanceof IFile) {
            return this.createResourceModel((IFile)input);
        }
        if (input instanceof IStorage) {
            return this.createStorageModel((IStorage)input);
        }
        return null;
    }

    protected void createPages() {
        this.firstPageId = SITE_PAGE;
        this.formWorkbook.setFirstPageSelected(false);
        SitePage sitePage = new SitePage(this, PDEPlugin.getResourceString(SITE_PAGE_TITLE));
        BuildPage buildPage = new BuildPage(sitePage, PDEPlugin.getResourceString(BUILD_PAGE_TITLE));
        FeaturePage featurePage = new FeaturePage(sitePage, PDEPlugin.getResourceString(FEATURE_PAGE_TITLE));
        ArchivePage archivePage = new ArchivePage(sitePage, PDEPlugin.getResourceString(ARCHIVE_PAGE_TITLE));
        this.addPage(SITE_PAGE, sitePage);
        this.addPage(BUILD_PAGE, buildPage);
        this.addPage(FEATURE_PAGE, featurePage);
        this.addPage(ARCHIVE_PAGE, archivePage);
        this.addPage(SOURCE_PAGE, new SiteSourcePage(this));
    }

    private ISiteModel createResourceModel(IFile file) throws CoreException {
        InputStream stream = null;
        stream = file.getContents(false);
        WorkspaceModelManager provider = PDECore.getDefault().getWorkspaceModelManager();
        provider.connect((Object)file, (Object)this);
        ISiteModel model = (ISiteModel)provider.getModel((Object)file, (Object)this);
        try {
            model.load(stream, false);
        }
        catch (CoreException coreException) {}
        IPath buildPath = file.getProject().getFullPath().append(".sitebuild").append("sitebuild.xml");
        IFile buildFile = file.getWorkspace().getRoot().getFile(buildPath);
        provider.connect((Object)buildFile, (Object)this);
        ISiteBuildModel buildModel = (ISiteBuildModel)provider.getModel((Object)buildFile, (Object)this);
        try {
            buildModel.load();
        }
        catch (CoreException coreException) {}
        model.setBuildModel(buildModel);
        try {
            stream.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        this.stateListener = new StateListener(model);
        return model;
    }

    private ISiteModel createStorageModel(IStorage storage) {
        return null;
    }

    public StateListener getStateListener() {
        return this.stateListener;
    }

    public void dispose() {
        super.dispose();
        WorkspaceModelManager provider = PDECore.getDefault().getWorkspaceModelManager();
        ISiteModel model = (ISiteModel)this.getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (this.storageModel) {
            model.dispose();
            if (buildModel != null) {
                buildModel.dispose();
            }
        } else {
            provider.disconnect((Object)model.getUnderlyingResource(), (Object)this);
            if (buildModel != null) {
                provider.disconnect((Object)buildModel.getUnderlyingResource(), (Object)this);
            }
        }
        if (this.stateListener != null) {
            this.stateListener.dispose();
        }
    }

    public IPDEEditorPage getHomePage() {
        return this.getPage(SITE_PAGE);
    }

    protected String getSourcePageId() {
        return SOURCE_PAGE;
    }

    public String getTitle() {
        if (!this.isModelCorrect(this.getModel())) {
            return super.getTitle();
        }
        ISiteModel model = (ISiteModel)this.getModel();
        String name = model.getSite().getLabel();
        if (name == null) {
            return super.getTitle();
        }
        return model.getResourceString(name);
    }

    protected boolean hasKnownTypes() {
        try {
            Object data = this.getClipboard().getContents((Transfer)TextTransfer.getInstance());
            return data != null;
        }
        catch (SWTError sWTError) {
            return false;
        }
    }

    protected boolean isModelCorrect(Object model) {
        return model != null ? ((ISiteModel)model).isValid() : false;
    }

    protected boolean isModelDirty(Object model) {
        return model != null && model instanceof IEditable && model instanceof IModel && ((IModel)model).isEditable() && ((IEditable)model).isDirty();
    }

    protected boolean isValidContentType(IEditorInput input) {
        String name = input.getName().toLowerCase();
        return input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput) ? name.startsWith("site.xml") : name.equals("site.xml");
    }

    protected boolean updateModel() {
        ISiteModel model = (ISiteModel)this.getModel();
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        boolean cleanModel = true;
        String text = document.get();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            try {
                model.reload((InputStream)stream, false);
            }
            catch (CoreException coreException) {
                cleanModel = false;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
        }
        return cleanModel;
    }

    public void updateTitle() {
        this.firePropertyChange(1);
    }
}

