/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteDescription;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.site.SitePage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormTextListener;

public class SiteDescriptionSection
extends PDEFormSection {
    public static final String SECTION_TITLE = "SiteEditor.SiteDescriptionSection.title";
    public static final String SECTION_DESC = "SiteEditor.SiteDescriptionSection.desc";
    public static final String SECTION_URL = "SiteEditor.SiteDescriptionSection.url";
    public static final String SECTION_TEXT = "SiteEditor.SiteDescriptionSection.text";
    private FormEntry url;
    private FormEntry text;
    private boolean updateNeeded;

    public SiteDescriptionSection(SitePage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    public void commitChanges(boolean onSave) {
        this.url.commit();
        this.text.commit();
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        this.url = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_URL), factory, 1));
        this.url.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                SiteDescriptionSection.this.setDescriptionURL(text.getValue());
            }

            public void textDirty(FormEntry text) {
                SiteDescriptionSection.this.forceDirty();
            }
        });
        this.text = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_TEXT), factory, 1, 66));
        this.text.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                SiteDescriptionSection.this.setDescriptionText(text.getValue());
            }

            public void textDirty(FormEntry text) {
                SiteDescriptionSection.this.forceDirty();
            }
        });
        GridData gd = (GridData)this.text.getControl().getLayoutData();
        gd.heightHint = 150;
        gd.widthHint = 100;
        factory.paintBordersFor(container);
        return container;
    }

    private void setDescriptionURL(String text) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISite site = model.getSite();
        ISiteDescription description = site.getDescription();
        boolean defined = false;
        if (description == null) {
            description = model.getFactory().createDescription(null);
            defined = true;
        }
        try {
            description.setURL(text);
            if (defined) {
                site.setDescription(description);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setDescriptionText(String text) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISite site = model.getSite();
        ISiteDescription description = site.getDescription();
        boolean defined = false;
        if (description == null) {
            description = model.getFactory().createDescription(null);
            defined = true;
        }
        try {
            description.setText(text);
            if (defined) {
                site.setDescription(description);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void forceDirty() {
        this.setDirty(true);
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        if (model instanceof IEditable) {
            ((IEditable)model).setDirty(true);
        }
        this.getFormPage().getEditor().fireSaveNeeded();
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void initialize(Object input) {
        ISiteModel model = (ISiteModel)input;
        this.update(input);
        if (!model.isEditable()) {
            this.url.getControl().setEditable(false);
            this.text.getControl().setEditable(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public boolean isDirty() {
        return this.url.isDirty() || this.text.isDirty();
    }

    public void modelChanged(IModelChangedEvent e) {
        Object[] objs;
        if (e.getChangeType() == 99) {
            this.updateNeeded = true;
        } else if (e.getChangeType() == 3 && (objs = e.getChangedObjects()).length > 0 && objs[0] instanceof ISite) {
            this.updateNeeded = true;
            if (this.getFormPage().isVisible()) {
                this.update();
            }
        }
    }

    public void setFocus() {
        if (this.url != null) {
            this.url.getControl().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    private void setIfDefined(Text text, String value) {
        if (value != null) {
            text.setText(value);
        }
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        ISiteModel model = (ISiteModel)input;
        ISite site = model.getSite();
        this.setIfDefined(this.url, site.getDescription() != null ? site.getDescription().getURL() : null);
        this.setIfDefined(this.text, site.getDescription() != null ? site.getDescription().getText() : null);
        this.updateNeeded = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return clipboard.getContents((Transfer)TextTransfer.getInstance()) != null;
    }
}

