/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.site.ArchivePage;
import org.eclipse.pde.internal.ui.editor.site.NewArchiveDialog;
import org.eclipse.pde.internal.ui.editor.site.ObjectListSection;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class SiteArchiveSection
extends ObjectListSection {
    private static final String SECTION_TITLE = "SiteEditor.SiteArchiveSection.title";
    private static final String SECTION_DESC = "SiteEditor.SiteArchiveSection.desc";
    private static final String KEY_NEW = "SiteEditor.SiteArchiveSection.new";

    public SiteArchiveSection(ArchivePage page) {
        super(page, PDEPlugin.getResourceString(SECTION_TITLE), PDEPlugin.getResourceString(SECTION_DESC), new String[]{PDEPlugin.getResourceString(KEY_NEW)});
    }

    protected Object[] getElements(Object parent) {
        if (parent instanceof ISite) {
            return ((ISite)parent).getArchives();
        }
        return new Object[0];
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
            }
        }
    }

    protected boolean isApplicable(Object object) {
        return object instanceof ISiteArchive;
    }

    protected String getOpenPopupLabel() {
        return null;
    }

    protected boolean isOpenable() {
        return false;
    }

    protected void handleNew() {
        final ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        BusyIndicator.showWhile((Display)this.tableViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewArchiveDialog dialog = new NewArchiveDialog(SiteArchiveSection.this.tableViewer.getControl().getShell(), model);
                dialog.create();
                SWTUtil.setDialogSize(dialog, 400, -1);
                dialog.open();
            }
        });
    }

    protected void remove(Object input, List objects) throws CoreException {
        ISiteArchive[] array = objects.toArray(new ISiteArchive[objects.size()]);
        ISite site = (ISite)input;
        site.removeArchives(array);
    }

    protected void handleOpen() {
    }

    protected void setButtonsEnabled(boolean value) {
        this.getTablePart().setButtonEnabled(0, value);
    }

    protected boolean isValidObject(Object obj) {
        return obj instanceof ISiteArchive;
    }

    protected void accept(ISite site, ArrayList archives) throws CoreException {
        site.addArchives(archives.toArray(new ISiteArchive[archives.size()]));
    }
}

