/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormTextListener;

public class PropertySection
extends PDEFormSection {
    public static final String KEY_URL = "SiteEditor.PropertySection.url";
    public static final String KEY_ID = "SiteEditor.PropertySection.id";
    private static final String KEY_VERSION = "SiteEditor.PropertySection.version";
    private static final String KEY_TYPE = "SiteEditor.PropertySection.type";
    private static final String KEY_PATH = "SiteEditor.PropertySection.path";
    private Class objClass;
    private FormEntry[] entries;
    private Object currentInput;
    private boolean updateNeeded;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PropertySection(PDEFormPage page, String title, String desc, Class objClass) {
        super(page);
        this.setHeaderText(title);
        this.setDescription(desc);
        this.objClass = objClass;
    }

    public void commitChanges(boolean onSave) {
        int i = 0;
        while (i < this.entries.length) {
            this.entries[i].commit();
            ++i;
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        int index;
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.isite.ISiteFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.objClass.equals(clazz)) {
            this.entries = new FormEntry[4];
            index = 0;
            this.createEntry(container, PDEPlugin.getResourceString(KEY_URL), factory, index++);
            this.createEntry(container, PDEPlugin.getResourceString(KEY_ID), factory, index++);
            this.createEntry(container, PDEPlugin.getResourceString(KEY_VERSION), factory, index++);
            this.createEntry(container, PDEPlugin.getResourceString(KEY_TYPE), factory, index++);
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.pde.internal.core.isite.ISiteArchive");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (this.objClass.equals(clazz2)) {
                this.entries = new FormEntry[2];
                index = 0;
                this.createEntry(container, PDEPlugin.getResourceString(KEY_PATH), factory, index++);
                this.createEntry(container, PDEPlugin.getResourceString(KEY_URL), factory, index++);
            }
        }
        GridData gd = (GridData)this.entries[0].getControl().getLayoutData();
        gd.widthHint = 100;
        factory.paintBordersFor(container);
        return container;
    }

    private void createEntry(Composite container, String name, FormWidgetFactory factory, final int index) {
        FormEntry entry = new FormEntry(this.createText(container, name, factory, 1));
        entry.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                PropertySection.this.setEntryText(index, text.getValue());
            }

            public void textDirty(FormEntry text) {
                PropertySection.this.forceDirty();
            }
        });
        this.entries[index] = entry;
    }

    private void setEntryText(int index, String text) {
        block21: {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.isite.ISiteFeature");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.objClass.equals(clazz)) {
                    ISiteFeature feature = (ISiteFeature)this.currentInput;
                    switch (index) {
                        case 0: {
                            feature.setURL(text);
                            break;
                        }
                        case 1: {
                            feature.setId(text);
                            break;
                        }
                        case 2: {
                            feature.setVersion(text);
                            break;
                        }
                        case 3: {
                            feature.setType(text);
                        }
                    }
                    break block21;
                }
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.pde.internal.core.isite.ISiteArchive");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.objClass.equals(clazz2)) {
                    ISiteArchive archive = (ISiteArchive)this.currentInput;
                    switch (index) {
                        case 0: {
                            archive.setPath(text);
                            break;
                        }
                        case 1: {
                            archive.setURL(text);
                        }
                    }
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void forceDirty() {
        this.setDirty(true);
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        if (model instanceof IEditable) {
            ((IEditable)model).setDirty(true);
        }
        this.getFormPage().getEditor().fireSaveNeeded();
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void initialize(Object input) {
        ISiteModel model = (ISiteModel)input;
        this.update(input);
        if (!model.isEditable()) {
            int i = 0;
            while (i < this.entries.length) {
                this.entries[i].getControl().setEditable(false);
                ++i;
            }
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public boolean isDirty() {
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i].isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void modelChanged(IModelChangedEvent e) {
        Object[] objs;
        if (e.getChangeType() == 99) {
            this.updateNeeded = true;
        } else if (e.getChangeType() == 3 && (objs = e.getChangedObjects()).length > 0 && this.objClass.isAssignableFrom(objs[0].getClass())) {
            this.updateNeeded = true;
            if (this.getFormPage().isVisible()) {
                this.update();
            }
        }
    }

    public void setFocus() {
        if (this.entries != null) {
            this.entries[0].getControl().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    private void setIfDefined(Text text, String value) {
        if (value != null) {
            text.setText(value);
        }
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        this.inputChanged(this.currentInput);
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        if (changeType == 1) {
            this.inputChanged(changeObject);
        }
    }

    private void inputChanged(Object changeObject) {
        this.currentInput = changeObject;
        if (this.currentInput == null) {
            this.clearEntries();
            return;
        }
        this.setEntriesEditable(true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.isite.ISiteFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.objClass.isAssignableFrom(clazz)) {
            ISiteFeature feature = (ISiteFeature)changeObject;
            this.entries[0].setValue(feature.getURL(), true);
            this.entries[1].setValue(feature.getId(), true);
            this.entries[2].setValue(feature.getVersion(), true);
            this.entries[3].setValue(feature.getType(), true);
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.pde.internal.core.isite.ISiteArchive");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (this.objClass.isAssignableFrom(clazz2)) {
                ISiteArchive archive = (ISiteArchive)changeObject;
                this.entries[0].setValue(archive.getPath(), true);
                this.entries[1].setValue(archive.getURL(), true);
            }
        }
    }

    private void clearEntries() {
        int i = 0;
        while (i < this.entries.length) {
            FormEntry entry = this.entries[i];
            entry.setValue(null, true);
            entry.getControl().setEditable(false);
            ++i;
        }
    }

    private void setEntriesEditable(boolean value) {
        int i = 0;
        while (i < this.entries.length) {
            FormEntry entry = this.entries[i];
            entry.getControl().setEditable(value);
            ++i;
        }
    }

    public boolean canPaste(Clipboard clipboard) {
        return clipboard.getContents((Transfer)TextTransfer.getInstance()) != null;
    }
}

