/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.site.BaseNewDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewFeatureDialog
extends BaseNewDialog {
    private static final String KEY_TITLE = "NewFeatureDialog.title";
    private static final String KEY_URL = "NewFeatureDialog.url";
    private static final String KEY_EMPTY = "NewFeatureDialog.empty";
    private static final String SETTINGS_SECTION = "NewFeatureDialog";
    private static final String S_URL = "url";
    private Text urlText;

    public NewFeatureDialog(Shell shell, ISiteModel siteModel) {
        super(shell, siteModel, null);
    }

    protected void createEntries(Composite container) {
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_URL));
        this.urlText = new Text(container, 2052);
        this.presetURL();
        GridData gd = new GridData(768);
        this.urlText.setLayoutData((Object)gd);
    }

    private void presetURL() {
        IDialogSettings settings = this.getDialogSettings(SETTINGS_SECTION);
        String initialText = settings.get(S_URL);
        if (initialText == null) {
            ISiteBuildModel siteBuildModel = this.getSiteModel().getBuildModel();
            IPath featureLocation = siteBuildModel.getSiteBuild().getFeatureLocation();
            initialText = featureLocation.addTrailingSeparator().toString();
        }
        this.urlText.setText(initialText);
        this.urlText.setSelection(this.urlText.getText().length());
    }

    protected String getDialogTitle() {
        return PDEPlugin.getResourceString(KEY_TITLE);
    }

    protected String getHelpId() {
        return "org.eclipse.pde.doc.user.new_feature_dialog";
    }

    protected String getEmptyErrorMessage() {
        return PDEPlugin.getResourceString(KEY_EMPTY);
    }

    protected void hookListeners(ModifyListener modifyListener) {
        this.urlText.addModifyListener(modifyListener);
    }

    protected void dialogChanged() {
        IStatus status = null;
        String text = this.urlText.getText();
        if (text.length() == 0) {
            status = this.getEmptyErrorStatus();
        } else if (this.sameURL(text)) {
            status = this.createErrorStatus(PDEPlugin.getResourceString("NewFeatureDialog.alreadyDefined"));
        }
        if (status == null) {
            status = this.getOKStatus();
        }
        this.updateStatus(status);
    }

    private boolean sameURL(String url) {
        ISiteFeature[] features = this.getSiteModel().getSite().getFeatures();
        int i = 0;
        while (i < features.length) {
            ISiteFeature feature = features[i];
            String furl = feature.getURL();
            if (furl != null && furl.equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void execute() {
        ISiteModel siteModel = this.getSiteModel();
        ISiteFeature feature = siteModel.getFactory().createFeature();
        try {
            feature.setURL(this.urlText.getText());
            Path path = new Path(feature.getURL());
            String jarName = path.removeFileExtension().lastSegment();
            int underLoc = jarName.indexOf(95);
            if (underLoc != -1) {
                String id = jarName.substring(0, underLoc);
                String version = jarName.substring(underLoc + 1);
                feature.setId(id);
                feature.setVersion(version);
            }
            siteModel.getSite().addFeatures(new ISiteFeature[]{feature});
            this.getDialogSettings(SETTINGS_SECTION).put(S_URL, feature.getURL());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }
}

