/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.site.BaseNewDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewArchiveDialog
extends BaseNewDialog {
    private static final String KEY_TITLE = "NewArchiveDialog.title";
    private static final String KEY_PATH = "NewArchiveDialog.path";
    private static final String KEY_URL = "NewArchiveDialog.url";
    private static final String KEY_EMPTY = "NewArchiveDialog.empty";
    private static final String SETTINGS_SECTION = "NewArchiveDialog";
    private static final String S_URL = "url";
    private static final String S_PATH = "path";
    private Text pathText;
    private Text urlText;

    public NewArchiveDialog(Shell shell, ISiteModel siteModel) {
        super(shell, siteModel, null);
    }

    protected void createEntries(Composite container) {
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_PATH));
        this.pathText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.pathText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_URL));
        this.urlText = new Text(container, 2052);
        gd = new GridData(768);
        this.urlText.setLayoutData((Object)gd);
        this.presetEntries();
    }

    private void presetEntries() {
        IDialogSettings settings = this.getDialogSettings(SETTINGS_SECTION);
        String initialURL = settings.get(S_URL);
        String initialPath = settings.get(S_PATH);
        this.setIfDefined(this.urlText, initialURL);
        this.setIfDefined(this.pathText, initialPath);
    }

    protected String getDialogTitle() {
        return PDEPlugin.getResourceString(KEY_TITLE);
    }

    protected String getHelpId() {
        return "org.eclipse.pde.doc.user.new_archive_dialog";
    }

    protected String getEmptyErrorMessage() {
        return PDEPlugin.getResourceString(KEY_EMPTY);
    }

    protected void hookListeners(ModifyListener modifyListener) {
        this.pathText.addModifyListener(modifyListener);
        this.urlText.addModifyListener(modifyListener);
    }

    protected void dialogChanged() {
        IStatus status = null;
        if (this.urlText.getText().length() == 0 || this.pathText.getText().length() == 0) {
            status = this.getEmptyErrorStatus();
        } else if (this.hasPath(this.pathText.getText())) {
            status = this.createErrorStatus(PDEPlugin.getResourceString("NewArchiveDialog.alreadyExists"));
        }
        if (status == null) {
            status = this.getOKStatus();
        }
        this.updateStatus(status);
    }

    private boolean hasPath(String path) {
        ISiteModel model = this.getSiteModel();
        ISiteArchive[] archives = model.getSite().getArchives();
        int i = 0;
        while (i < archives.length) {
            ISiteArchive archive = archives[i];
            String apath = archive.getPath();
            if (apath != null && apath.equals(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void execute() {
        ISiteModel siteModel = this.getSiteModel();
        ISiteArchive archive = siteModel.getFactory().createArchive();
        try {
            archive.setURL(this.urlText.getText());
            archive.setPath(this.pathText.getText());
            siteModel.getSite().addArchives(new ISiteArchive[]{archive});
            IDialogSettings settings = this.getDialogSettings(SETTINGS_SECTION);
            settings.put(S_PATH, archive.getPath());
            settings.put(S_URL, archive.getURL());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }
}

