/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.IModelProviderEvent;
import org.eclipse.pde.internal.core.IModelProviderListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.site.BuildPage;
import org.eclipse.pde.internal.ui.editor.site.BuiltFeaturesWizard;
import org.eclipse.pde.internal.ui.editor.site.CheckboxObjectListSection;
import org.eclipse.pde.internal.ui.editor.site.FeatureBuildOperation;
import org.eclipse.pde.internal.ui.editor.site.SiteEditor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class FeatureProjectSection
extends CheckboxObjectListSection {
    private static final String SECTION_TITLE = "SiteEditor.FeatureProjectSection.title";
    private static final String SECTION_DESC = "SiteEditor.FeatureProjectSection.desc";
    private static final String KEY_NEW = "SiteEditor.FeatureProjectSection.new";
    private static final String KEY_SELECT_ALL = "SiteEditor.FeatureProjectSection.selectAll";
    private static final String KEY_DESELECT_ALL = "SiteEditor.FeatureProjectSection.deselectAll";
    private Action buildAction;

    public FeatureProjectSection(BuildPage page) {
        String[] stringArray = new String[4];
        stringArray[0] = PDEPlugin.getResourceString(KEY_NEW);
        stringArray[2] = PDEPlugin.getResourceString(KEY_SELECT_ALL);
        stringArray[3] = PDEPlugin.getResourceString(KEY_DESELECT_ALL);
        super(page, PDEPlugin.getResourceString(SECTION_TITLE), PDEPlugin.getResourceString(SECTION_DESC), stringArray);
    }

    protected Object[] getElements(Object input) {
        if (input instanceof ISiteBuild) {
            return ((ISiteBuild)input).getFeatures();
        }
        return new Object[0];
    }

    protected boolean isApplicable(Object object) {
        return object instanceof ISiteBuildFeature;
    }

    public void commitChanges(boolean onSave) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (onSave && buildModel instanceof WorkspaceSiteBuildModel && ((WorkspaceSiteBuildModel)buildModel).isDirty()) {
            ((WorkspaceSiteBuildModel)buildModel).save();
        }
    }

    protected boolean canDelete(IStructuredSelection ssel) {
        return true;
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 2: {
                this.handleSelectAll(true);
                break;
            }
            case 3: {
                this.handleSelectAll(false);
            }
        }
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel != null) {
            buildModel.removeModelChangedListener((IModelChangedListener)this);
        }
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        mng.removeModelProviderListener((IModelProviderListener)this);
        super.dispose();
    }

    public void expandTo(Object object) {
        if (object instanceof ISiteBuildFeature) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(object), true);
        }
    }

    public void handleNew() {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        final ISiteBuildModel buildModel = model.getBuildModel();
        BusyIndicator.showWhile((Display)this.tableViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                BuiltFeaturesWizard wizard = new BuiltFeaturesWizard(buildModel);
                WizardDialog dialog = new WizardDialog(FeatureProjectSection.this.tableViewer.getControl().getShell(), (IWizard)wizard);
                dialog.open();
                FeatureProjectSection.this.forceDirty();
            }
        });
    }

    private void forceDirty() {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (((IEditable)buildModel).isDirty()) {
            this.setDirty(true);
            ((IEditable)model).setDirty(true);
            this.getFormPage().getEditor().fireSaveNeeded();
        }
    }

    private void handleSelectAll() {
        IStructuredContentProvider provider = (IStructuredContentProvider)this.tableViewer.getContentProvider();
        Object[] elements = provider.getElements(this.tableViewer.getInput());
        StructuredSelection ssel = new StructuredSelection(elements);
        this.tableViewer.setSelection((ISelection)ssel);
    }

    protected void handleOpen() {
    }

    protected void remove(Object input, List removed) throws CoreException {
        ISiteBuildFeature[] array = removed.toArray(new ISiteBuildFeature[removed.size()]);
        ISiteBuild siteBuild = (ISiteBuild)input;
        siteBuild.removeFeatures(array);
        this.forceDirty();
    }

    public boolean isOpenable() {
        return true;
    }

    public void initialize(Object input) {
        ISiteModel model = (ISiteModel)input;
        this.update(input);
        if (!model.isEditable()) {
            this.tableViewer.setAllGrayed(true);
            this.getTablePart().setButtonEnabled(2, false);
            this.getTablePart().setButtonEnabled(3, false);
        }
        ISiteBuildModel buildModel = model.getBuildModel();
        this.getTablePart().setButtonEnabled(0, buildModel.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
        buildModel.addModelChangedListener((IModelChangedListener)this);
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        mng.addModelProviderListener((IModelProviderListener)this);
    }

    protected void makeActions() {
        super.makeActions();
        this.buildAction = new Action(){

            public void run() {
                FeatureProjectSection.this.doBuild();
            }
        };
        this.buildAction.setText("Build Selected");
    }

    protected void fillClientActions(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.size() > 0) {
            manager.add((IAction)this.buildAction);
            manager.add((IContributionItem)new Separator());
        }
    }

    private void doBuild() {
        ArrayList<ISiteBuildFeature> result = new ArrayList<ISiteBuildFeature>();
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            ISiteBuildFeature sbfeature = (ISiteBuildFeature)iter.next();
            if (sbfeature.getReferencedFeature() == null) continue;
            result.add(sbfeature);
        }
        if (result.size() != 0) {
            SiteEditor editor = (SiteEditor)this.getFormPage().getEditor();
            FeatureBuildOperation op = new FeatureBuildOperation(result, editor.getStateListener(), false, false);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.tableViewer.getControl().getShell());
            try {
                dialog.run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    protected void setButtonsEnabled(boolean value) {
    }

    protected String getOpenPopupLabel() {
        return "&Open";
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.updateNeeded = true;
        this.update();
    }

    public void update(Object input) {
        ISiteModel model = (ISiteModel)input;
        ISiteBuildModel buildModel = model.getBuildModel();
        ISiteBuild build = buildModel.getSiteBuild();
        build.resetReferences();
        this.tableViewer.setInput((Object)build);
        this.updateChecks(model, buildModel);
        this.updateNeeded = false;
    }

    protected void elementChecked(Object element, boolean checked) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        if (!model.isEditable()) {
            this.tableViewer.setChecked(element, !checked);
            return;
        }
        ISiteBuildFeature selection = (ISiteBuildFeature)element;
        this.updateSiteFeature(selection, checked);
    }

    protected void handleSelectAll(boolean selected) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        this.tableViewer.setAllChecked(selected);
        ISiteBuildFeature[] sbfeatures = buildModel.getSiteBuild().getFeatures();
        ArrayList<ISiteFeature> result = new ArrayList<ISiteFeature>();
        try {
            int i = 0;
            while (i < sbfeatures.length) {
                ISiteBuildFeature sbfeature = sbfeatures[i];
                ISiteFeature sfeature = this.findMatchingSiteFeature(sbfeature);
                if (selected && sfeature == null) {
                    sfeature = this.createSiteFeature(model, sbfeature);
                    result.add(sfeature);
                } else if (!selected && sfeature != null) {
                    result.add(sfeature);
                }
                ++i;
            }
            if (result.size() > 0) {
                ISiteFeature[] array = result.toArray(new ISiteFeature[result.size()]);
                if (selected) {
                    model.getSite().addFeatures(array);
                } else {
                    model.getSite().removeFeatures(array);
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private ISiteFeature createSiteFeature(ISiteModel model, ISiteBuildFeature sbfeature) throws CoreException {
        ISiteFeature sfeature = model.getFactory().createFeature();
        sfeature.setId(sbfeature.getId());
        sfeature.setVersion(sbfeature.getVersion());
        sfeature.setURL(sbfeature.getTargetURL());
        return sfeature;
    }

    private void updateSiteFeature(ISiteBuildFeature sbfeature, boolean add) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISite site = model.getSite();
        ISiteFeature sfeature = this.findMatchingSiteFeature(sbfeature);
        if (add) {
            if (sfeature == null) {
                try {
                    sfeature = this.createSiteFeature(model, sbfeature);
                    site.addFeatures(new ISiteFeature[]{sfeature});
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        } else if (sfeature != null) {
            try {
                site.removeFeatures(new ISiteFeature[]{sfeature});
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private ISiteFeature findMatchingSiteFeature(ISiteBuildFeature sbfeature) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteFeature[] sfeatures = model.getSite().getFeatures();
        return this.findMatchingSiteFeature(sbfeature, sfeatures);
    }

    private ISiteFeature findMatchingSiteFeature(ISiteBuildFeature sbfeature, ISiteFeature[] sfeatures) {
        int j = 0;
        while (j < sfeatures.length) {
            ISiteFeature sfeature = sfeatures[j];
            if (this.matches(sfeature, sbfeature)) {
                return sfeature;
            }
            ++j;
        }
        return null;
    }

    private void updateChecks(ISiteModel model, ISiteBuildModel buildModel) {
        ISiteBuildFeature[] sbfeatures = buildModel.getSiteBuild().getFeatures();
        ISiteFeature[] sfeatures = model.getSite().getFeatures();
        ArrayList<ISiteBuildFeature> checked = new ArrayList<ISiteBuildFeature>();
        int i = 0;
        while (i < sbfeatures.length) {
            ISiteBuildFeature sbfeature = sbfeatures[i];
            ISiteFeature sfeature = this.findMatchingSiteFeature(sbfeature, sfeatures);
            if (sfeature != null) {
                checked.add(sbfeature);
            }
            ++i;
        }
        this.tableViewer.setCheckedElements(checked.toArray());
    }

    private boolean matches(ISiteFeature sfeature, ISiteBuildFeature sbfeature) {
        String targetURL = sbfeature.getTargetURL();
        String url = sfeature.getURL();
        return url != null && targetURL != null && url.equalsIgnoreCase(targetURL);
    }
}

