/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.internal.build.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.site.StateListener;

public class FeatureBuildOperation
implements IRunnableWithProgress {
    public static final String KEY_ERRORS_MESSAGE = "GenerateFeatureJars.errorsMessage";
    public static final String KEY_VERIFYING = "GenerateFeatureJars.verifying";
    public static final String KEY_GENERATING = "GenerateFeatureJars.generating";
    public static final String KEY_RUNNING = "FeatureBuildOperation.running";
    private static final String BUILD_LISTENER_CLASS = "org.eclipse.pde.internal.ui.ant.SiteBuildListener";
    private ArrayList features;
    private StateListener stateListener;
    private boolean scrubOutput;
    private boolean fullBuild;
    private File logFile = null;
    private static FeatureBuildOperation instance;

    public FeatureBuildOperation(ArrayList features, StateListener stateListener, boolean scrubOutput, boolean fullBuild) {
        this.features = features;
        this.stateListener = stateListener;
        instance = this;
        this.fullBuild = fullBuild;
        this.scrubOutput = scrubOutput;
    }

    public FeatureBuildOperation(ISiteBuildFeature sbfeature, boolean scrubOutput) {
        this.features = new ArrayList();
        this.features.add(sbfeature);
        this.scrubOutput = scrubOutput;
        this.fullBuild = false;
        instance = this;
    }

    public static FeatureBuildOperation getDefault() {
        return instance;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                int count = this.scrubOutput ? 2 * this.features.size() + 1 : 2 * this.features.size();
                monitor.beginTask("Building:", count);
                if (this.scrubOutput) {
                    monitor.setTaskName("Scrubbing output folders ...");
                    this.scrubOutput((ISiteBuildFeature)this.features.get(0), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                monitor.setTaskName("Building:");
                int i = 0;
                while (i < this.features.size()) {
                    if (monitor.isCanceled()) break;
                    ISiteBuildFeature sbfeature = (ISiteBuildFeature)this.features.get(i);
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 2, 4);
                    this.doBuildFeature(sbfeature, (IProgressMonitor)subMonitor);
                    ++i;
                }
                if (this.fullBuild && this.stateListener != null) {
                    if (!this.stateListener.isActive()) {
                        this.stateListener.setActive(true);
                    }
                    this.stateListener.removeAllProjects();
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.postBuildCleanup((ISiteBuildFeature)this.features.get(0));
            monitor.done();
            throw throwable;
        }
        Object var6_9 = null;
        this.postBuildCleanup((ISiteBuildFeature)this.features.get(0));
        monitor.done();
    }

    private void scrubOutput(ISiteBuildFeature sbfeature, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 2);
        ISiteBuildModel model = sbfeature.getModel();
        IProject project = model.getUnderlyingResource().getProject();
        ISiteBuild siteBuild = model.getSiteBuild();
        IFolder pluginFolder = project.getFolder(siteBuild.getPluginLocation());
        IFolder featureFolder = project.getFolder(siteBuild.getFeatureLocation());
        this.scrubFolder(pluginFolder, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.scrubFolder(featureFolder, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private void scrubFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IResource[] members = folder.members();
        monitor.beginTask("Scrubbing " + folder.getName(), members.length);
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            member.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i;
        }
    }

    private void doBuildFeature(ISiteBuildFeature sbfeature, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        IFeatureModel featureModel = sbfeature.getReferencedFeature().getModel();
        monitor.subTask("'" + featureModel.getFeature().getLabel() + "'");
        monitor.beginTask(PDEPlugin.getResourceString(KEY_VERIFYING), 5);
        monitor.worked(1);
        this.ensureValid(featureModel, monitor);
        monitor.worked(1);
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_GENERATING));
        IFile scriptFile = this.makeScript(featureModel, monitor);
        monitor.worked(1);
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_RUNNING));
        this.runScript(scriptFile, sbfeature.getModel(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IProject buildProject = sbfeature.getModel().getUnderlyingResource().getProject();
        buildProject.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (this.stateListener != null) {
            this.stateListener.setBuilt(sbfeature);
        }
    }

    private void postBuildCleanup(ISiteBuildFeature sbfeature) {
        ISiteBuildModel model = sbfeature.getModel();
        IProject siteProject = model.getUnderlyingResource().getProject();
        IFolder tempFolder = siteProject.getFolder(".sitebuild/temp.folder");
        if (tempFolder.exists()) {
            try {
                tempFolder.delete(true, false, null);
            }
            catch (CoreException coreException) {}
        }
    }

    private void ensureValid(IFeatureModel featureModel, IProgressMonitor monitor) throws CoreException {
        IFile file = (IFile)featureModel.getUnderlyingResource();
        IProject project = file.getProject();
        if (!project.getWorkspace().isAutoBuilding()) {
            project.build(10, monitor);
        }
        if (this.hasErrors(file)) {
            String message = PDEPlugin.getResourceString(KEY_ERRORS_MESSAGE);
            Status status = new Status(4, "org.eclipse.pde.ui", 0, message, null);
            throw new CoreException((IStatus)status);
        }
    }

    private boolean hasErrors(IFile file) throws CoreException {
        IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        int i = 0;
        while (i < markers.length) {
            Integer severity;
            IMarker marker = markers[i];
            Object att = marker.getAttribute("severity");
            if (att != null && att instanceof Integer && (severity = (Integer)att) == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IFile makeScript(IFeatureModel featureModel, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        FeatureBuildScriptGenerator generator = new FeatureBuildScriptGenerator();
        IFile featureFile = (IFile)featureModel.getUnderlyingResource();
        String scriptName = "build.xml";
        generator.setBuildScriptName(scriptName);
        generator.setFeatureRootLocation(featureFile.getParent().getLocation().toOSString());
        generator.setGenerateChildrenScript(true);
        IPath platform = Platform.getLocation().append(featureFile.getProject().getName());
        generator.setInstallLocation(platform.toOSString());
        generator.setDevEntries(new String[]{"bin"});
        URL[] pluginPath = TargetPlatform.createPluginPath();
        generator.setPluginPath(pluginPath);
        generator.setFeature(featureModel.getFeature().getId());
        generator.generate();
        return featureFile.getProject().getFile(scriptName);
    }

    private void runScript(IFile scriptFile, ISiteBuildModel buildModel, IProgressMonitor monitor) throws CoreException {
        AntRunner runner = new AntRunner();
        this.createLogFile(buildModel);
        runner.setBuildFileLocation(scriptFile.getLocation().toOSString());
        runner.setArguments(this.computeBuildArguments(buildModel));
        this.computeCustomClasspath();
        runner.setExecutionTargets(this.computeTargets());
        runner.setMessageOutputLevel(0);
        runner.addBuildListener(BUILD_LISTENER_CLASS);
        runner.run(monitor);
    }

    private URL[] computeCustomClasspath() {
        AntCorePreferences preferences = AntCorePlugin.getPlugin().getPreferences();
        URL[] defaultAntURLs = preferences.getDefaultAntURLs();
        URL installURL = PDEPlugin.getDefault().getDescriptor().getInstallURL();
        try {
            int length = defaultAntURLs.length;
            URL[] customURLs = new URL[length + 1];
            System.arraycopy(defaultAntURLs, 0, customURLs, 0, length);
            customURLs[length] = new URL(installURL, "bin/");
            return customURLs;
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
            return null;
        }
    }

    private void createLogFile(ISiteBuildModel buildModel) {
        IProject project = buildModel.getUnderlyingResource().getProject();
        IPath location = project.getLocation().append(".sitebuild").append("build.log");
        this.logFile = new File(location.toOSString());
    }

    public File getLogFile() {
        return this.logFile;
    }

    private String computeBuildArguments(ISiteBuildModel buildModel) {
        StringBuffer buff = new StringBuffer();
        IProject project = buildModel.getUnderlyingResource().getProject();
        IPath projectLocation = project.getLocation();
        IPath resultFolder = projectLocation.append(".sitebuild");
        resultFolder = resultFolder.append("temp.folder");
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        buff.append(this.createArgument("build.result.folder", resultFolder.toOSString()));
        String location = projectLocation.append(siteBuild.getPluginLocation()).toOSString();
        buff.append(this.createArgument("plugin.destination", location));
        location = projectLocation.append(siteBuild.getFeatureLocation()).toOSString();
        buff.append(this.createArgument("feature.destination", location));
        return buff.toString().trim();
    }

    private String createArgument(String name, String value) {
        return "-D" + name + "=" + "\"" + value + "\" ";
    }

    private String[] computeTargets() {
        return new String[]{"build.update.jar", "refresh"};
    }
}

