/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.IModelProviderEvent;
import org.eclipse.pde.internal.core.IModelProviderListener;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.CheckboxTableSection;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.CheckboxTablePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public abstract class CheckboxObjectListSection
extends CheckboxTableSection
implements IModelProviderListener {
    private static final String POPUP_NEW = "Menus.new.label";
    private static final String POPUP_DELETE = "Actions.delete.label";
    protected boolean updateNeeded;
    protected CheckboxTableViewer tableViewer;
    private Action openAction;
    private Action newAction;
    private Action deleteAction;

    public CheckboxObjectListSection(PDEFormPage page, String title, String desc, String[] buttons) {
        super(page, buttons);
        this.setHeaderText(title);
        this.setDescription(desc);
    }

    protected abstract Object[] getElements(Object var1);

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = this.createClientContainer(parent, 2, factory);
        GridLayout layout = (GridLayout)container.getLayout();
        layout.verticalSpacing = 9;
        this.createViewerPartControl(container, 2, 2, factory);
        CheckboxTablePart tablePart = this.getTablePart();
        this.tableViewer = tablePart.getTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        factory.paintBordersFor(container);
        this.makeActions();
        return container;
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleOpen();
    }

    protected void buttonSelected(int index) {
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    protected abstract boolean isApplicable(Object var1);

    public void expandTo(Object object) {
        if (this.isApplicable(object)) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(object), true);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.newAction);
        manager.add((IContributionItem)new Separator());
        if (this.isOpenable()) {
            manager.add((IAction)this.openAction);
        }
        if (this.canDelete((IStructuredSelection)this.tableViewer.getSelection())) {
            manager.add((IAction)this.deleteAction);
        }
        this.fillClientActions(manager);
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
    }

    protected void fillClientActions(IMenuManager manager) {
    }

    protected abstract void handleOpen();

    protected abstract void handleNew();

    protected abstract String getOpenPopupLabel();

    protected abstract boolean canDelete(IStructuredSelection var1);

    protected void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.tableViewer.getSelection();
        if (ssel.isEmpty()) {
            return;
        }
        try {
            if (this.canDelete(ssel)) {
                this.remove(this.tableViewer.getInput(), ssel.toList());
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected abstract void remove(Object var1, List var2) throws CoreException;

    private void handleSelectAll() {
        IStructuredContentProvider provider = (IStructuredContentProvider)this.tableViewer.getContentProvider();
        Object[] elements = provider.getElements(this.tableViewer.getInput());
        StructuredSelection ssel = new StructuredSelection(elements);
        this.tableViewer.setSelection((ISelection)ssel);
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals("delete")) {
            BusyIndicator.showWhile((Display)this.tableViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    CheckboxObjectListSection.this.handleDelete();
                }
            });
            return true;
        }
        if (actionId.equals("selectAll")) {
            BusyIndicator.showWhile((Display)this.tableViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    CheckboxObjectListSection.this.handleSelectAll();
                }
            });
            return true;
        }
        if (actionId.equals("cut")) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals("paste")) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getFormPage().setSelection((ISelection)selection);
        if (selection.size() == 1) {
            this.fireSelectionNotification(selection.getFirstElement());
        } else {
            this.fireSelectionNotification(null);
        }
    }

    public void initialize(Object input) {
        ISiteModel model = (ISiteModel)input;
        this.update(input);
        if (!model.isEditable()) {
            this.setButtonsEnabled(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    protected abstract void setButtonsEnabled(boolean var1);

    protected abstract boolean isOpenable();

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.updateNeeded = true;
            if (this.getFormPage().isVisible()) {
                this.update();
            }
        } else {
            Object obj = e.getChangedObjects()[0];
            if (this.isApplicable(obj)) {
                if (e.getChangeType() == 3) {
                    this.tableViewer.update(obj, null);
                } else if (e.getChangeType() == 1) {
                    this.tableViewer.add(e.getChangedObjects());
                } else if (e.getChangeType() == 2) {
                    this.tableViewer.remove(e.getChangedObjects());
                }
            }
        }
    }

    protected void makeActions() {
        IModel model = (IModel)this.getFormPage().getModel();
        this.newAction = new Action(){

            public void run() {
                CheckboxObjectListSection.this.handleNew();
            }
        };
        this.newAction.setText(PDEPlugin.getResourceString(POPUP_NEW));
        this.newAction.setEnabled(model.isEditable());
        this.deleteAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)CheckboxObjectListSection.this.tableViewer.getTable().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        4.access$0(this.this$1).handleDelete();
                    }
                });
            }

            static /* synthetic */ CheckboxObjectListSection access$0(4 var0) {
                return var0.CheckboxObjectListSection.this;
            }
        };
        this.deleteAction.setEnabled(model.isEditable());
        this.deleteAction.setText(PDEPlugin.getResourceString(POPUP_DELETE));
        if (this.isOpenable()) {
            this.openAction = new Action(){

                public void run() {
                    CheckboxObjectListSection.this.handleOpen();
                }
            };
            this.openAction.setEnabled(model.isEditable());
            this.openAction.setText(this.getOpenPopupLabel());
        }
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.updateNeeded = true;
        this.update();
    }

    public void setFocus() {
        if (this.tableViewer != null) {
            this.tableViewer.getTable().setFocus();
        }
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        ISiteModel model = (ISiteModel)input;
        ISite site = model.getSite();
        this.tableViewer.setInput((Object)site);
        this.updateNeeded = false;
    }

    protected void doPaste() {
        ModelDataTransfer modelTransfer;
        Clipboard clipboard = this.getFormPage().getEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)(modelTransfer = ModelDataTransfer.getInstance()));
        if (objects != null) {
            this.doPaste(null, objects);
        }
    }

    protected void doPaste(Object target, Object[] objects) {
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return CheckboxObjectListSection.this.getElements(parent);
        }
    }
}

