/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.site.CategoryDefinitionSection;
import org.eclipse.pde.internal.ui.editor.site.CheckboxObjectListSection;
import org.eclipse.pde.internal.ui.editor.site.FeaturePage;
import org.eclipse.update.ui.forms.internal.FormSection;

public class CategorySection
extends CheckboxObjectListSection {
    private static final String SECTION_TITLE = "SiteEditor.CategorySection.title";
    private static final String SECTION_DESC = "SiteEditor.CategorySection.desc";
    private static final String KEY_NEW = "SiteEditor.CategorySection.new";
    private ISiteFeature currentInput;

    public CategorySection(FeaturePage page) {
        super(page, PDEPlugin.getResourceString(SECTION_TITLE), PDEPlugin.getResourceString(SECTION_DESC), new String[]{PDEPlugin.getResourceString(KEY_NEW)});
    }

    protected Object[] getElements(Object parent) {
        if (parent instanceof ISite && this.currentInput != null) {
            return ((ISite)parent).getCategoryDefinitions();
        }
        return new Object[0];
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
            }
        }
    }

    protected boolean isApplicable(Object object) {
        return object instanceof ISiteCategoryDefinition;
    }

    protected String getOpenPopupLabel() {
        return null;
    }

    protected boolean isOpenable() {
        return false;
    }

    protected void handleNew() {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        CategoryDefinitionSection.showCategoryDialog((Viewer)this.tableViewer, model, null);
    }

    protected boolean canDelete(IStructuredSelection ssel) {
        return false;
    }

    protected void remove(Object input, List objects) throws CoreException {
    }

    protected void handleOpen() {
    }

    protected void setButtonsEnabled(boolean value) {
        this.getTablePart().setButtonEnabled(0, value);
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        if (changeType == 1) {
            this.inputChanged(changeObject);
        }
    }

    private void inputChanged(Object changeObject) {
        if (changeObject instanceof ISiteFeature) {
            this.currentInput = (ISiteFeature)changeObject;
            this.tableViewer.refresh();
            this.refresh();
        } else {
            this.currentInput = null;
            this.tableViewer.refresh();
        }
    }

    private void refresh() {
        ArrayList<ISiteCategoryDefinition> checked = new ArrayList<ISiteCategoryDefinition>();
        if (this.currentInput != null) {
            ISiteCategoryDefinition[] defs = this.currentInput.getSite().getCategoryDefinitions();
            int i = 0;
            while (i < defs.length) {
                ISiteCategoryDefinition def = defs[i];
                if (this.findMatchingCategory(def) != null) {
                    checked.add(def);
                }
                ++i;
            }
        }
        this.tableViewer.setCheckedElements(checked.toArray());
    }

    public void update(Object input) {
        this.refresh();
        this.updateNeeded = false;
    }

    private ISiteCategory findMatchingCategory(ISiteCategoryDefinition def) {
        ISiteCategory[] categories = this.currentInput.getCategories();
        int j = 0;
        while (j < categories.length) {
            ISiteCategory category = categories[j];
            if (category.getName().equalsIgnoreCase(def.getName())) {
                return category;
            }
            ++j;
        }
        return null;
    }

    protected void elementChecked(Object element, boolean checked) {
        if (this.currentInput == null || !(this.getFormPage().getModel() instanceof IEditable)) {
            this.tableViewer.setChecked(element, !checked);
            return;
        }
        try {
            ISiteCategoryDefinition def = (ISiteCategoryDefinition)element;
            ISiteCategory category = this.findMatchingCategory(def);
            if (checked && category == null) {
                category = this.currentInput.getModel().getFactory().createCategory(this.currentInput);
                category.setName(def.getName());
                this.currentInput.addCategories(new ISiteCategory[]{category});
            } else if (!checked && category != null) {
                this.currentInput.removeCategories(new ISiteCategory[]{category});
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void initialize(Object input) {
        super.initialize(input);
        ISiteModel model = (ISiteModel)input;
        this.getTablePart().getViewer().setInput((Object)model.getSite());
    }
}

