/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.site.BuildPage;
import org.eclipse.pde.internal.ui.editor.site.FeatureBuildOperation;
import org.eclipse.pde.internal.ui.editor.site.SiteEditor;
import org.eclipse.pde.internal.ui.editor.site.StateListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.HyperlinkAdapter;
import org.eclipse.update.ui.forms.internal.IFormTextListener;
import org.eclipse.update.ui.forms.internal.IHyperlinkListener;
import org.eclipse.update.ui.forms.internal.SelectableFormLabel;

public class BuildControlSection
extends PDEFormSection {
    public static final String SECTION_TITLE = "SiteEditor.BuildControlSection.title";
    public static final String SECTION_DESC = "SiteEditor.BuildControlSection.desc";
    public static final String SECTION_PLUGIN_DEST = "SiteEditor.BuildControlSection.pluginDest";
    public static final String SECTION_FEATURE_DEST = "SiteEditor.BuildControlSection.featureDest";
    public static final String SECTION_CONSOLE = "SiteEditor.BuildControlSection.console";
    public static final String SECTION_AUTOBUILD = "SiteEditor.BuildControlSection.autobuild";
    public static final String SECTION_SCRUB_OUTPUT = "SiteEditor.BuildControlSection.scrubOutput";
    public static final String SECTION_BUILD = "SiteEditor.BuildControlSection.build";
    public static final String SECTION_REBUILD_ALL = "SiteEditor.BuildControlSection.rebuildAll";
    private FormEntry pluginDest;
    private FormEntry featureDest;
    private Button consoleButton;
    private Button autobuildButton;
    private Button scrubOutputButton;
    private Button buildButton;
    private Button rebuildAllButton;
    private boolean updateNeeded;

    public BuildControlSection(BuildPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    public void commitChanges(boolean onSave) {
        this.pluginDest.commit();
        this.featureDest.commit();
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (onSave && buildModel instanceof WorkspaceSiteBuildModel && ((WorkspaceSiteBuildModel)buildModel).isDirty()) {
            ((WorkspaceSiteBuildModel)buildModel).save();
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        this.pluginDest = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_PLUGIN_DEST), factory, 1));
        this.pluginDest.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                BuildControlSection.this.setPluginDestination(text.getValue());
            }

            public void textDirty(FormEntry text) {
                BuildControlSection.this.forceDirty();
            }
        });
        Button browse = factory.createButton(container, "Browse...", 8);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.featureDest = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_FEATURE_DEST), factory, 1));
        this.featureDest.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                BuildControlSection.this.setFeatureDestination(text.getValue());
            }

            public void textDirty(FormEntry text) {
                BuildControlSection.this.forceDirty();
            }
        });
        browse = factory.createButton(container, "Browse...", 8);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.scrubOutputButton = factory.createButton(container, PDEPlugin.getResourceString(SECTION_SCRUB_OUTPUT), 32);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        this.scrubOutputButton.setLayoutData((Object)gd);
        this.scrubOutputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildControlSection.this.setScrubOutput(BuildControlSection.this.scrubOutputButton.getSelection());
            }
        });
        Composite buttonContainer = factory.createComposite(container);
        gd = new GridData(32);
        gd.horizontalSpan = 3;
        buttonContainer.setLayoutData((Object)gd);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 3;
        buttonContainer.setLayout((Layout)blayout);
        blayout.marginWidth = 0;
        this.buildButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(SECTION_BUILD), 8);
        this.buildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildControlSection.handleBuild((SiteEditor)BuildControlSection.this.getFormPage().getEditor(), false);
            }
        });
        gd = new GridData(34);
        this.buildButton.setLayoutData((Object)gd);
        this.rebuildAllButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(SECTION_REBUILD_ALL), 8);
        this.rebuildAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildControlSection.handleBuild((SiteEditor)BuildControlSection.this.getFormPage().getEditor(), true);
            }
        });
        gd = new GridData(34);
        this.rebuildAllButton.setLayoutData((Object)gd);
        SelectableFormLabel openLogLink = factory.createSelectableLabel(buttonContainer, "Build Log");
        final IPath buildLogPath = new Path(".sitebuild").append("build.log");
        factory.turnIntoHyperlink((Control)openLogLink, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(Control link) {
                BuildControlSection.this.openBuildLog(buildLogPath);
            }
        });
        openLogLink.setToolTipText(buildLogPath.toString());
        factory.paintBordersFor(container);
        return container;
    }

    private void openBuildLog(IPath buildLogPath) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        IProject project = model.getUnderlyingResource().getProject();
        final IFile file = project.getFile(buildLogPath);
        if (file.exists()) {
            BusyIndicator.showWhile((Display)this.buildButton.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PDEPlugin.getActivePage();
                        page.openEditor(file);
                    }
                    catch (PartInitException e) {
                        PDEPlugin.logException(e);
                    }
                }
            });
        }
    }

    private void setPluginDestination(String text) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel == null) {
            return;
        }
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        try {
            siteBuild.setPluginLocation((IPath)new Path(text));
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setFeatureDestination(String text) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel == null) {
            return;
        }
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        try {
            siteBuild.setFeatureLocation((IPath)new Path(text));
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setAutobuild(boolean value) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel == null) {
            return;
        }
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        try {
            siteBuild.setAutobuild(value);
            this.forceDirty();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setScrubOutput(boolean value) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel == null) {
            return;
        }
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        try {
            siteBuild.setScrubOutput(value);
            this.forceDirty();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setShowConsole(boolean value) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel == null) {
            return;
        }
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        try {
            siteBuild.setShowConsole(value);
            this.forceDirty();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void forceDirty() {
        this.setDirty(true);
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel instanceof IEditable) {
            IEditable editable = (IEditable)buildModel;
            editable.setDirty(true);
            if (model instanceof IEditable) {
                ((IEditable)model).setDirty(true);
            }
            this.getFormPage().getEditor().fireSaveNeeded();
        }
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    static void handleBuild(SiteEditor editor, boolean fullBuild) {
        StateListener stateListener = editor.getStateListener();
        ISiteModel model = (ISiteModel)editor.getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        ISiteBuildFeature[] features = siteBuild.getFeatures();
        if (stateListener != null && !stateListener.isActive()) {
            fullBuild = true;
        }
        ArrayList<ISiteBuildFeature> result = new ArrayList<ISiteBuildFeature>();
        int i = 0;
        while (i < features.length) {
            ISiteBuildFeature sbfeature = features[i];
            if (sbfeature.getReferencedFeature() != null) {
                boolean shouldBuild = false;
                if (fullBuild) {
                    shouldBuild = true;
                } else {
                    boolean bl = shouldBuild = stateListener != null ? stateListener.isDirty(sbfeature) : true;
                }
                if (shouldBuild) {
                    result.add(sbfeature);
                }
            }
            ++i;
        }
        if (result.size() == 0) {
            return;
        }
        FeatureBuildOperation op = new FeatureBuildOperation(result, stateListener, siteBuild.getScrubOutput(), fullBuild);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(editor.getControl().getShell());
        try {
            dialog.run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
    }

    public void initialize(Object input) {
        ISiteModel model = (ISiteModel)input;
        this.update(input);
        ISiteBuildModel buildModel = model.getBuildModel();
        if (!buildModel.isEditable()) {
            this.featureDest.getControl().setEditable(false);
            this.pluginDest.getControl().setEditable(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        Object[] objs;
        if (e.getChangeType() == 99) {
            this.updateNeeded = true;
        } else if (e.getChangeType() == 3 && (objs = e.getChangedObjects()).length > 0 && objs[0] instanceof ISite) {
            this.updateNeeded = true;
            if (this.getFormPage().isVisible()) {
                this.update();
            }
        }
    }

    public void setFocus() {
        if (this.pluginDest != null) {
            this.pluginDest.getControl().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    private void setIfDefined(Text text, String value) {
        if (value != null) {
            text.setText(value);
        }
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        ISiteModel model = (ISiteModel)input;
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel != null) {
            ISiteBuild siteBuild = buildModel.getSiteBuild();
            this.setIfDefined(this.featureDest, siteBuild.getFeatureLocation() != null ? siteBuild.getFeatureLocation().toOSString() : null);
            this.setIfDefined(this.pluginDest, siteBuild.getPluginLocation() != null ? siteBuild.getPluginLocation().toOSString() : null);
            this.scrubOutputButton.setSelection(siteBuild.getScrubOutput());
        }
        this.updateNeeded = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return clipboard.getContents((Transfer)TextTransfer.getInstance()) != null;
    }
}

