/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaDocPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormPage;
import org.eclipse.swt.graphics.Image;

public class SchemaFormOutlinePage
extends FormOutlinePage {
    private Object[] topics;

    public SchemaFormOutlinePage(PDEFormPage formPage) {
        super(formPage);
    }

    protected ITreeContentProvider createContentProvider() {
        return new ContentProvider();
    }

    protected ILabelProvider createLabelProvider() {
        return new OutlineLabelProvider();
    }

    protected Object[] createTopics() {
        ISchema schema = (ISchema)this.formPage.getModel();
        IDocumentSection[] sections = schema.getDocumentSections();
        Object[] result = new Object[sections.length + 1];
        result[0] = schema;
        int i = 1;
        while (i <= sections.length) {
            result[i] = sections[i - 1];
            ++i;
        }
        return result;
    }

    Object[] getAttributes(ISchemaElement element) {
        ISchemaType type = element.getType();
        if (type instanceof ISchemaComplexType) {
            return ((ISchemaComplexType)type).getAttributes();
        }
        return new Object[0];
    }

    Object[] getMarkup() {
        ISchema schema = (ISchema)this.formPage.getModel();
        return schema.getElements();
    }

    String getObjectLabel(Object obj) {
        if (obj instanceof ISchema) {
            return PDEPlugin.getResourceString("SchemaEditor.topic.overview");
        }
        if (obj instanceof IDocumentSection) {
            IDocumentSection section = (IDocumentSection)obj;
            String sectionId = section.getSectionId();
            if (sectionId.equals("examples")) {
                return PDEPlugin.getResourceString("SchemaEditor.topic.examples");
            }
            if (sectionId.equals("since")) {
                return PDEPlugin.getResourceString("SchemaEditor.topic.since");
            }
            if (sectionId.equals("implementation")) {
                return PDEPlugin.getResourceString("SchemaEditor.topic.implementation");
            }
            if (sectionId.equals("apiInfo")) {
                return PDEPlugin.getResourceString("SchemaEditor.topic.api");
            }
            if (sectionId.equals("copyright")) {
                return PDEPlugin.getResourceString("SchemaEditor.topic.copyright");
            }
        }
        return null;
    }

    public IPDEEditorPage getParentPage(Object item) {
        if (item instanceof IDocumentSection || item instanceof ISchema) {
            return this.formPage.getEditor().getPage("documentation");
        }
        if (item instanceof ISchemaObject) {
            return this.formPage.getEditor().getPage("definition");
        }
        return super.getParentPage(item);
    }

    Object[] getTopics() {
        if (this.topics == null) {
            this.topics = this.createTopics();
        }
        return this.topics;
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.topics = null;
            this.treeViewer.refresh();
            return;
        }
        Object object = event.getChangedObjects()[0];
        if (event.getChangeType() == 3) {
            this.treeViewer.update(object, null);
        } else {
            Object parent = null;
            if (object instanceof ISchemaObject) {
                parent = ((ISchemaObject)object).getParent();
            }
            if (parent != null) {
                if (parent instanceof ISchema) {
                    parent = this.formPage.getEditor().getPage("definition");
                }
                this.treeViewer.refresh(parent);
                this.treeViewer.expandToLevel(parent, 2);
            } else {
                this.treeViewer.refresh();
                this.treeViewer.expandAll();
            }
        }
    }

    class ContentProvider
    extends FormOutlinePage.BasicContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof SchemaFormPage) {
                return SchemaFormOutlinePage.this.getMarkup();
            }
            if (parent instanceof ISchemaElement) {
                return SchemaFormOutlinePage.this.getAttributes((ISchemaElement)parent);
            }
            if (parent instanceof SchemaDocPage) {
                return SchemaFormOutlinePage.this.getTopics();
            }
            return super.getChildren(parent);
        }

        public Object getParent(Object child) {
            return super.getParent(child);
        }
    }

    class OutlineLabelProvider
    extends FormOutlinePage.BasicLabelProvider {
        OutlineLabelProvider() {
        }

        public String getText(Object obj) {
            String label = SchemaFormOutlinePage.this.getObjectLabel(obj);
            if (label != null) {
                return label;
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            Image image = PDEPlugin.getDefault().getLabelProvider().getImage(obj);
            if (image != null) {
                return image;
            }
            return super.getImage(obj);
        }
    }
}

