/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.EditableSchema;
import org.eclipse.pde.internal.core.schema.ExternalSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.FileSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.StorageSchemaDescriptor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageXMLEditor;
import org.eclipse.pde.internal.ui.editor.schema.SchemaDocPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaSourcePage;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.swt.widgets.Shell;

public class SchemaEditor
extends PDEMultiPageXMLEditor {
    public static final String DEFINITION_PAGE = "definition";
    public static final String DOC_PAGE = "documentation";
    public static final String SOURCE_PAGE = "source";
    public static final String KEY_OLD_EXTENSION = "SchemaEditor.oldExtension";
    private ShowDescriptionAction previewAction;

    protected Object createModel(Object input) {
        if (input instanceof File) {
            return this.createExternalModel((File)input);
        }
        if (!(input instanceof IFile)) {
            if (input instanceof IStorage) {
                return this.createStorageModel((IStorage)input);
            }
            return null;
        }
        IFile file = (IFile)input;
        FileSchemaDescriptor sd = new FileSchemaDescriptor(file);
        ISchema schema = sd.getSchema();
        if (!schema.isValid()) {
            return null;
        }
        this.warnIfOldExtension(file.getName());
        if (schema instanceof EditableSchema) {
            ((EditableSchema)schema).setNotificationEnabled(true);
        }
        return schema;
    }

    private Object createExternalModel(File file) {
        ExternalSchemaDescriptor sd = new ExternalSchemaDescriptor(file, "", false);
        ISchema schema = sd.getSchema();
        if (!schema.isValid()) {
            return null;
        }
        this.warnIfOldExtension(file.getName());
        if (schema instanceof EditableSchema) {
            ((EditableSchema)schema).setNotificationEnabled(true);
        }
        return schema;
    }

    private Object createStorageModel(IStorage storage) {
        StorageSchemaDescriptor sd = new StorageSchemaDescriptor(storage);
        ISchema schema = sd.getSchema();
        if (!schema.isValid()) {
            return null;
        }
        this.warnIfOldExtension(storage.getName());
        return schema;
    }

    private void warnIfOldExtension(String name) {
        String ext;
        int dotLoc = name.lastIndexOf(46);
        if (dotLoc != -1 && (ext = name.substring(dotLoc + 1).toLowerCase()).equals("xsd")) {
            String title = this.getSite().getRegisteredName();
            String message = PDEPlugin.getResourceString(KEY_OLD_EXTENSION);
            MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
        }
    }

    public void dispose() {
        PDECore.getDefault().getTempFileManager().disconnect((Object)this);
        super.dispose();
    }

    void previewReferenceDocument() {
        ISchema schema = (ISchema)this.getModel();
        if (this.previewAction == null) {
            this.previewAction = new ShowDescriptionAction(schema);
        } else {
            this.previewAction.setSchema(schema);
        }
        this.previewAction.run();
    }

    protected void createPages() {
        this.firstPageId = DEFINITION_PAGE;
        SchemaFormPage form = new SchemaFormPage(this);
        SchemaDocPage doc = new SchemaDocPage(form);
        this.addPage(DEFINITION_PAGE, form);
        this.addPage(DOC_PAGE, doc);
        this.addPage(SOURCE_PAGE, new SchemaSourcePage(this));
    }

    public IPDEEditorPage getHomePage() {
        return this.getPage(DEFINITION_PAGE);
    }

    protected String getSourcePageId() {
        return SOURCE_PAGE;
    }

    protected boolean isModelCorrect(Object model) {
        if (model == null) {
            return false;
        }
        ISchema schema = (ISchema)model;
        return schema.isValid();
    }

    protected boolean isModelDirty(Object model) {
        return model instanceof IEditable && ((IEditable)model).isDirty();
    }

    protected boolean updateModel() {
        Schema schema = (Schema)this.getModel();
        if (schema == null) {
            return false;
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String text = document.get();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            schema.reload((InputStream)stream);
            if (schema instanceof IEditable) {
                ((IEditable)schema).setDirty(false);
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    public boolean validateModelSemantics() {
        if (this.getModel() instanceof ISchema) {
            ISchema schema = (ISchema)this.getModel();
            return schema != null && schema.isValid();
        }
        return super.validateModelSemantics();
    }
}

