/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Vector;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.schema.ChoiceRestriction;
import org.eclipse.pde.internal.core.schema.SchemaEnumeration;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.schema.IRestrictionPage;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class EnumerationRestrictionPage
implements IRestrictionPage {
    public static final String KEY_CHOICES = "SchemaEditor.RestrictionDialog.enumeration.choices";
    public static final String KEY_NEW_CHOICE = "SchemaEditor.RestrictionDialog.enumeration.newChoice";
    public static final String KEY_ADD = "SchemaEditor.RestrictionDialog.enumeration.add";
    public static final String KEY_REMOVE = "SchemaEditor.RestrictionDialog.enumeration.remove";
    private List choiceList;
    private Button addButton;
    private Button deleteButton;
    private Text text;
    private Control control;
    static /* synthetic */ Class class$0;

    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Composite top = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        Label label = new Label(top, 0);
        label.setText(PDEPlugin.getResourceString(KEY_NEW_CHOICE));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.text = new Text(top, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.addButton = new Button(top, 8);
        this.addButton.setText(PDEPlugin.getResourceString(KEY_ADD));
        this.addButton.setEnabled(false);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnumerationRestrictionPage.this.handleAdd();
            }
        });
        this.addButton.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.addButton);
        Composite bottom = new Composite(container, 0);
        bottom.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        bottom.setLayout((Layout)layout);
        label = new Label(bottom, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setText(PDEPlugin.getResourceString(KEY_CHOICES));
        this.choiceList = new List(bottom, 2818);
        this.choiceList.setLayoutData((Object)new GridData(1808));
        this.deleteButton = new Button(bottom, 8);
        this.deleteButton.setText(PDEPlugin.getResourceString(KEY_REMOVE));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnumerationRestrictionPage.this.handleDelete();
            }
        });
        this.deleteButton.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.deleteButton);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String item = EnumerationRestrictionPage.this.text.getText();
                boolean canAdd = true;
                if (item.length() == 0 || EnumerationRestrictionPage.this.choiceList.indexOf(item) != -1) {
                    canAdd = false;
                }
                EnumerationRestrictionPage.this.addButton.setEnabled(canAdd);
            }
        });
        this.text.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                EnumerationRestrictionPage.this.handleAdd();
                e.doit = false;
            }
        });
        this.choiceList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnumerationRestrictionPage.this.deleteButton.setEnabled(EnumerationRestrictionPage.this.choiceList.getSelectionCount() > 0);
                if (EnumerationRestrictionPage.this.choiceList.getSelectionCount() == 1) {
                    EnumerationRestrictionPage.this.text.setText(EnumerationRestrictionPage.this.choiceList.getSelection()[0]);
                }
            }
        });
        this.control = container;
        return container;
    }

    public Class getCompatibleRestrictionClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.schema.ChoiceRestriction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Control getControl() {
        return this.control;
    }

    public ISchemaRestriction getRestriction() {
        ChoiceRestriction restriction = new ChoiceRestriction(null);
        String[] items = this.choiceList.getItems();
        if (items.length > 0) {
            Vector<SchemaEnumeration> enums = new Vector<SchemaEnumeration>();
            int i = 0;
            while (i < items.length) {
                SchemaEnumeration schemaEnumeration = new SchemaEnumeration((ISchemaObject)restriction, items[i]);
                enums.addElement(schemaEnumeration);
                ++i;
            }
            restriction.setChildren(enums);
        }
        return restriction;
    }

    private void handleAdd() {
        String item = this.text.getText().trim();
        if (item.length() == 0) {
            return;
        }
        this.choiceList.add(item);
        this.choiceList.setSelection(new String[]{item});
        this.text.setText("");
        this.deleteButton.setEnabled(true);
    }

    private void handleDelete() {
        String[] selection = this.choiceList.getSelection();
        this.choiceList.setRedraw(false);
        int i = 0;
        while (i < selection.length) {
            this.choiceList.remove(selection[i]);
            ++i;
        }
        this.choiceList.setRedraw(true);
        this.deleteButton.setEnabled(false);
    }

    public void initialize(ISchemaRestriction restriction) {
        if (restriction != null) {
            Object[] children = restriction.getChildren();
            int i = 0;
            while (i < children.length) {
                Object child = children[i];
                if (child instanceof ISchemaEnumeration) {
                    this.choiceList.add(child.toString());
                }
                ++i;
            }
        }
    }
}

