/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.pde.internal.core.plugin.AbstractModelUpdateStrategy;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestSourcePageNew;
import org.eclipse.swt.widgets.Shell;

public class XMLReconcilingStrategy
implements IReconcilingStrategy {
    private ManifestSourcePageNew fPage;
    private IDocument fDocument;

    public XMLReconcilingStrategy(ManifestSourcePageNew page) {
        this.fPage = page;
    }

    private void saveInternalReconcile() {
        try {
            this.internalReconcile();
        }
        catch (Throwable th) {
            PDEPlugin.logException(th);
        }
    }

    private synchronized void internalReconcile() {
        Object modelObject;
        if (!this.fPage.isDynamicReconciling() || !this.fPage.tryGetModelUpdatingTicket()) {
            return;
        }
        if (this.fDocument == null) {
            return;
        }
        Shell shell = this.fPage.getSite().getShell();
        if (shell != null && !shell.isDisposed() && (modelObject = this.fPage.getEditor().getModel()) != null && modelObject instanceof AbstractPluginModelBase) {
            AbstractPluginModelBase model = (AbstractPluginModelBase)modelObject;
            String text = this.fDocument.get();
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
                AbstractModelUpdateStrategy updateStrategy = model.getDocumentModel().reconcile((InputStream)stream, false, false);
                if (updateStrategy != null) {
                    shell.getDisplay().syncExec((Runnable)updateStrategy);
                }
            }
            catch (UnsupportedEncodingException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void reconcile(IRegion partition) {
        this.saveInternalReconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.saveInternalReconcile();
    }

    public synchronized void setDocument(IDocument document) {
        this.fDocument = document;
    }
}

