/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.List;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.internal.core.plugin.DocumentModelChangeEvent;
import org.eclipse.pde.internal.core.plugin.IDocumentModelListener;
import org.eclipse.pde.internal.core.plugin.IDocumentNode;
import org.eclipse.pde.internal.core.plugin.XMLCore;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class XMLOutlinePage
extends ContentOutlinePage {
    private IContentProvider fContentProvider;
    private IBaseLabelProvider fLabelProvider;
    private IDocumentModelListener fListener;
    private XMLCore fXMLCore;
    private IDocumentNode fModel;

    public XMLOutlinePage(XMLCore core) {
        this.fXMLCore = core;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    protected IDocumentModelListener createXMLModelChangeListener() {
        return new IDocumentModelListener(){

            public void documentModelChanged(DocumentModelChangeEvent event) {
                if (event.getNode() == XMLOutlinePage.this.fModel) {
                    XMLOutlinePage.this.getControl().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            1.access$0(this.this$1).getControl().setRedraw(false);
                            XMLOutlinePage.access$1(1.access$0(this.this$1)).refresh();
                            XMLOutlinePage.access$1(1.access$0(this.this$1)).expandAll();
                            1.access$0(this.this$1).getControl().setRedraw(true);
                        }
                    });
                }
            }

            static /* synthetic */ XMLOutlinePage access$0(1 var0) {
                return var0.XMLOutlinePage.this;
            }
        };
    }

    protected void setViewerInput(Object newInput) {
        TreeViewer tree = this.getTreeViewer();
        Object oldInput = tree.getInput();
        boolean isXMLNode = newInput instanceof IDocumentNode;
        boolean wasXMLNode = oldInput instanceof IDocumentNode;
        if (isXMLNode && !wasXMLNode) {
            if (this.fListener == null) {
                this.fListener = this.createXMLModelChangeListener();
            }
            this.fXMLCore.addDocumentModelListener(this.fListener);
        } else if (!isXMLNode && wasXMLNode && this.fListener != null) {
            this.fXMLCore.removeDocumentModelListener(this.fListener);
            this.fListener = null;
        }
        tree.setInput(newInput);
        tree.expandAll();
    }

    public void setPageInput(IDocumentNode xmlModel) {
        this.fModel = xmlModel;
        if (this.getTreeViewer() != null) {
            this.setViewerInput(this.fModel);
        }
    }

    public void dispose() {
        if (this.fListener != null) {
            this.fXMLCore.removeDocumentModelListener(this.fListener);
            this.fListener = null;
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider(this.fContentProvider);
        viewer.setLabelProvider(this.fLabelProvider);
        if (this.fModel != null) {
            this.setViewerInput(this.fModel);
        }
        this.createContextMenu();
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                this.contextMenuAboutToShow(manager);
            }

            private void contextMenuAboutToShow(IMenuManager manager) {
                PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
                actionGroup.setContext(new ActionContext(XMLOutlinePage.this.getSelection()));
                actionGroup.fillContextMenu(manager);
            }
        });
        Menu menu = manager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public void select(Object xmlElement) {
        IStructuredSelection ss;
        List elements;
        TreeViewer treeViewer = this.getTreeViewer();
        ISelection s = treeViewer.getSelection();
        if (s instanceof IStructuredSelection && !(elements = (ss = (IStructuredSelection)s).toList()).contains(xmlElement)) {
            s = xmlElement == null ? StructuredSelection.EMPTY : new StructuredSelection(xmlElement);
            treeViewer.setSelection(s, true);
        }
    }

    static /* synthetic */ TreeViewer access$1(XMLOutlinePage xMLOutlinePage) {
        return xMLOutlinePage.getTreeViewer();
    }
}

