/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestExtensionsPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestTemplatePage;
import org.eclipse.pde.internal.ui.launcher.RuntimeWorkbenchShortcut;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.HTMLTableLayout;
import org.eclipse.update.ui.forms.internal.HyperlinkSettings;
import org.eclipse.update.ui.forms.internal.TableData;
import org.eclipse.update.ui.forms.internal.WebForm;
import org.eclipse.update.ui.forms.internal.engine.FormEngine;
import org.eclipse.update.ui.forms.internal.engine.HyperlinkAction;
import org.eclipse.update.ui.forms.internal.engine.IHyperlinkSegment;

public class TemplateForm
extends WebForm {
    private static final String KEY_HEADING = "ManifestEditor.templatePage.heading";
    private static final String KEY_INTRO = "ManifestEditor.TemplatePage.intro";
    private static final String KEY_COMMON = "ManifestEditor.TemplatePage.common";
    private static final String KEY_DONT_SHOW = "ManifestEditor.TemplatePage.dontShow";
    private ManifestTemplatePage page;
    private Button dontShowCheck;
    private boolean dontShow;
    private FormEngine text;
    private RuntimeWorkbenchShortcut launchShortcut;

    public TemplateForm(ManifestTemplatePage page) {
        this.page = page;
        this.launchShortcut = new RuntimeWorkbenchShortcut();
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    protected void createContents(final Composite parent) {
        HTMLTableLayout layout = new HTMLTableLayout();
        parent.setLayout((Layout)layout);
        layout.leftMargin = 10;
        layout.rightMargin = 0;
        layout.topMargin = 15;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 10;
        FormWidgetFactory factory = this.getFactory();
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        Image pageImage = provider.get(PDEPluginImages.DESC_PAGE_OBJ);
        Image runImage = provider.get(PDEPluginImages.DESC_RUN_EXC);
        Image debugImage = provider.get(PDEPluginImages.DESC_DEBUG_EXC);
        Image runWorkbenchImage = provider.get(PDEPluginImages.DESC_WORKBENCH_LAUNCHER_WIZ);
        HyperlinkAction pageAction = new HyperlinkAction(){

            public void linkActivated(IHyperlinkSegment link) {
                String pageId = link.getObjectId();
                TemplateForm.this.page.getEditor().showPage(pageId);
            }
        };
        HyperlinkAction debugAction = new HyperlinkAction(){

            public void linkActivated(IHyperlinkSegment link) {
                String id = link.getObjectId();
                BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(this, id){
                    private final /* synthetic */ String val$id;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$id = string;
                    }

                    public void run() {
                        if (this.val$id.equals("action.run")) {
                            TemplateForm.access$1(2.access$0(this.this$1)).run();
                        } else if (this.val$id.equals("action.debug")) {
                            TemplateForm.access$1(2.access$0(this.this$1)).debug();
                        }
                    }
                });
            }

            static /* synthetic */ TemplateForm access$0(2 var0) {
                return var0.TemplateForm.this;
            }
        };
        HyperlinkAction expandSource = new HyperlinkAction(){

            public void linkActivated(IHyperlinkSegment link) {
                TemplateForm.this.expandSourceFolders();
            }
        };
        HyperlinkAction newExtensionWizard = new HyperlinkAction(){

            public void linkActivated(IHyperlinkSegment link) {
                TemplateForm.this.openNewExtensionWizard();
            }
        };
        this.text = factory.createFormEngine(parent);
        this.text.setHyperlinkSettings((HyperlinkSettings)factory.getHyperlinkHandler());
        IFile file = this.page.getTemplateFile();
        try {
            InputStream is = file.getContents(true);
            this.text.load(is, true);
            is.close();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        this.text.registerTextObject("ExtensionsPage", (Object)pageAction);
        this.text.registerTextObject("OverviewPage", (Object)pageAction);
        this.text.registerTextObject("action.run", (Object)debugAction);
        this.text.registerTextObject("action.debug", (Object)debugAction);
        this.text.registerTextObject("action.expandSource", (Object)expandSource);
        this.text.registerTextObject("action.newExtension", (Object)newExtensionWizard);
        this.text.registerTextObject("pageImage", (Object)pageImage);
        this.text.registerTextObject("runImage", (Object)runImage);
        this.text.registerTextObject("debugImage", (Object)debugImage);
        this.text.registerTextObject("runTimeWorkbenchImage", (Object)runWorkbenchImage);
        TableData td = new TableData();
        td.grabHorizontal = true;
        this.text.setLayoutData((Object)td);
        Composite separator = new Composite(parent, 0);
        separator.setBackground(factory.getBorderColor());
        td = new TableData();
        td.heightHint = 1;
        td.align = 7;
        separator.setLayoutData((Object)td);
        this.dontShowCheck = factory.createButton(parent, PDEPlugin.getResourceString(KEY_DONT_SHOW), 32);
        this.dontShowCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateForm.this.dontShow = TemplateForm.this.dontShowCheck.getSelection();
            }
        });
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.manifest_welcome");
    }

    public void dispose() {
        if (this.dontShow) {
            this.deleteTemplateFile(this.page.getTemplateFile());
        }
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    private void deleteTemplateFile(final IFile file) {
        if (file.exists()) {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(PDEPlugin.getActiveWorkbenchShell());
            try {
                pmd.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            try {
                                file.delete(true, monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            monitor.done();
                            throw throwable;
                        }
                        Object var3_5 = null;
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void expandSourceFolders() {
        IPluginModelBase model = (IPluginModelBase)((PDEFormPage)this.page).getModel();
        IProject project = model.getUnderlyingResource().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            ArrayList<IFolder> sourceFolders = new ArrayList<IFolder>();
            int i = 0;
            while (i < entries.length) {
                IFolder folder;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 3 && (folder = project.getFolder(entry.getPath())).exists()) {
                    sourceFolders.add(folder);
                }
                ++i;
            }
            if (sourceFolders.size() > 0) {
                StructuredSelection selection = new StructuredSelection(sourceFolders.toArray());
                IWorkbenchPage page = PDEPlugin.getActivePage();
                IWorkbenchPart part = page.getActivePart();
                if (part instanceof ISetSelectionTarget) {
                    ((ISetSelectionTarget)part).selectReveal((ISelection)selection);
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public void setFocus() {
        if (this.text != null) {
            this.text.setFocus();
        }
    }

    private void openNewExtensionWizard() {
        ManifestEditor editor = (ManifestEditor)this.page.getEditor();
        ManifestExtensionsPage exPage = (ManifestExtensionsPage)editor.getPage("ExtensionsPage");
        editor.showPage(exPage);
        exPage.openNewExtensionWizard();
    }

    public void initialize(Object model) {
        super.initialize(model);
        IPluginModelBase modelBase = (IPluginModelBase)model;
        IPluginBase plugin = modelBase.getPluginBase();
        this.setHeadingText(PDEPlugin.getFormattedMessage(KEY_HEADING, plugin.getTranslatedName()));
        ((Composite)this.getControl()).layout(true);
        this.updateSize();
    }

    static /* synthetic */ RuntimeWorkbenchShortcut access$1(TemplateForm templateForm) {
        return templateForm.launchShortcut;
    }
}

