/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestFormPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormPage;
import org.eclipse.update.ui.forms.internal.IHyperlinkListener;
import org.eclipse.update.ui.forms.internal.SelectableFormLabel;

public class RuntimeSection
extends PDEFormSection
implements IHyperlinkListener,
IModelChangedListener {
    public static final String SECTION_TITLE = "ManifestEditor.RuntimeSection.title";
    public static final String SECTION_MORE = "ManifestEditor.RuntimeSection.more";
    public static final String SECTION_DESC = "ManifestEditor.RuntimeSection.desc";
    public static final String SECTION_FDESC = "ManifestEditor.RuntimeSection.fdesc";
    private FormWidgetFactory factory;
    private Composite libraryParent;
    private boolean needsUpdate;
    private Image libraryImage;
    private Button moreButton;

    public RuntimeSection(ManifestFormPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        boolean fragment = ((ManifestEditor)page.getEditor()).isFragmentEditor();
        if (fragment) {
            this.setDescription(PDEPlugin.getResourceString(SECTION_FDESC));
        } else {
            this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        }
    }

    private void addLibraryLink(IPluginLibrary library) {
        Label imageLabel = this.factory.createLabel(this.libraryParent, "");
        SelectableFormLabel hyperlink = this.factory.createSelectableLabel(this.libraryParent, library.getName());
        this.factory.turnIntoHyperlink((Control)hyperlink, (IHyperlinkListener)this);
        imageLabel.setImage(this.libraryImage);
        hyperlink.setData((Object)library);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        this.libraryParent = factory.createComposite(container);
        RowLayout rlayout = new RowLayout();
        rlayout.wrap = true;
        this.libraryParent.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        this.libraryParent.setLayoutData((Object)gd);
        Composite buttonContainer = factory.createComposite(container);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        this.moreButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(SECTION_MORE), 8);
        gd = new GridData(34);
        this.moreButton.setLayoutData((Object)gd);
        final IPDEEditorPage targetPage = this.getFormPage().getEditor().getPage("RuntimePage");
        this.moreButton.setToolTipText(((IFormPage)targetPage).getTitle());
        this.moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSection.this.getFormPage().getEditor().showPage(targetPage);
            }
        });
        return container;
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void initialize(Object input) {
        this.initializeImages();
        IPluginModelBase model = (IPluginModelBase)input;
        this.update(false);
        model.addModelChangedListener((IModelChangedListener)this);
    }

    private void initializeImages() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.libraryImage = provider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
    }

    public void linkActivated(Control linkLabel) {
        IPluginLibrary library = (IPluginLibrary)linkLabel.getData();
        this.getFormPage().getEditor().showPage("RuntimePage", library);
    }

    public void linkEntered(Control linkLabel) {
        IPDEEditorPage page = this.getFormPage().getEditor().getPage("RuntimePage");
        IPluginLibrary library = (IPluginLibrary)linkLabel.getData();
        String status = String.valueOf(((PDEFormPage)page).getStatusText()) + "#" + library.getName();
        IStatusLineManager manager = this.getFormPage().getEditor().getStatusLineManager();
        if (manager != null) {
            manager.setMessage(status);
        }
    }

    public void linkExited(Control linkLabel) {
        IStatusLineManager manager = this.getFormPage().getEditor().getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        Object[] objects;
        int type = event.getChangeType();
        if (type == 99) {
            this.needsUpdate = true;
        } else if ((type == 1 || type == 2) && (objects = event.getChangedObjects())[0] instanceof IPluginLibrary) {
            this.needsUpdate = true;
        }
        if (this.getFormPage().isVisible()) {
            this.update();
        }
    }

    public void update() {
        if (this.needsUpdate) {
            this.update(true);
        }
    }

    public void update(boolean removePrevious) {
        if (removePrevious) {
            Control[] children = this.libraryParent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginBase pluginBase = model.getPluginBase();
        IPluginLibrary[] libraries = pluginBase.getLibraries();
        int i = 0;
        while (i < libraries.length) {
            this.addLibraryLink(libraries[i]);
            ++i;
        }
        if (removePrevious) {
            this.libraryParent.layout(true);
            this.libraryParent.redraw();
        }
        this.needsUpdate = false;
    }
}

