/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.manifest.ResourceAttributeValue;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class ResourceAttributeCellEditor
extends DialogCellEditor {
    public static final String TITLE = "ManifestEditor.ResourceAttributeCellEditor.title";
    private Label label;

    protected ResourceAttributeCellEditor(Composite parent) {
        super(parent);
    }

    protected Control createContents(Composite cell) {
        this.label = new Label(cell, 16384);
        this.label.setFont(cell.getFont());
        this.label.setBackground(cell.getBackground());
        return this.label;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Object[] resources;
        IResource resource;
        ResourceAttributeValue value = (ResourceAttributeValue)this.getValue();
        IProject project = value.getProject();
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (IAdaptable)project, PDEPlugin.getResourceString(TITLE));
        int result = dialog.open();
        if (result == 0 && (resource = (IResource)(resources = dialog.getResult())[0]) instanceof IFile) {
            String stringValue = resource.getProjectRelativePath().toString();
            return new ResourceAttributeValue(project, stringValue);
        }
        return value;
    }

    protected void updateContents(Object value) {
        if (value != null) {
            this.label.setText(value.toString());
        } else {
            this.label.setText("");
        }
    }
}

