/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Vector;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestFormPage;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormPage;
import org.eclipse.update.ui.forms.internal.IHyperlinkListener;
import org.eclipse.update.ui.forms.internal.SelectableFormLabel;

public class RequiresSection
extends PDEFormSection
implements IHyperlinkListener,
IModelChangedListener {
    private Vector requires = new Vector();
    private Button moreButton;
    private FormWidgetFactory factory;
    private Composite requiresParent;
    private boolean needsUpdate;
    private TableViewer requiresList;
    public static final String SECTION_TITLE = "ManifestEditor.RequiresSection.title";
    public static final String SECTION_DESC = "ManifestEditor.RequiresSection.desc";
    public static final String SECTION_FDESC = "ManifestEditor.RequiresSection.fdesc";
    public static final String SECTION_MORE = "ManifestEditor.RequiresSection.more";

    public RequiresSection(ManifestFormPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        boolean fragment = ((ManifestEditor)page.getEditor()).isFragmentEditor();
        if (fragment) {
            this.setDescription(PDEPlugin.getResourceString(SECTION_FDESC));
        } else {
            this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        }
    }

    private void addImportLink(IPluginImport importObject) {
        Label imageLabel = this.factory.createLabel(this.requiresParent, "");
        String pluginId = importObject.getId();
        IPlugin refPlugin = PDECore.getDefault().findPlugin(pluginId);
        String name = pluginId;
        String tooltip = pluginId;
        if (refPlugin != null) {
            String translatedName = refPlugin.getTranslatedName();
            if (MainPreferencePage.isFullNameModeEnabled()) {
                name = translatedName;
            } else {
                tooltip = translatedName;
            }
        }
        int flags = 0;
        if (refPlugin == null) {
            flags = 1;
        } else if (importObject.isReexported()) {
            flags = 4;
        }
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        Image image = provider.get(PDEPluginImages.DESC_REQ_PLUGIN_OBJ, flags);
        imageLabel.setImage(image);
        if (refPlugin != null) {
            SelectableFormLabel hyperlink = this.factory.createSelectableLabel(this.requiresParent, name);
            this.factory.turnIntoHyperlink((Control)hyperlink, (IHyperlinkListener)this);
            hyperlink.setToolTipText(tooltip);
            hyperlink.setData((Object)refPlugin);
        } else {
            this.factory.createLabel(this.requiresParent, name);
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        this.requiresParent = factory.createComposite(container);
        this.requiresParent.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        this.requiresParent.setLayoutData((Object)gd);
        Composite buttonContainer = factory.createComposite(container);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        this.moreButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(SECTION_MORE), 8);
        gd = new GridData(34);
        this.moreButton.setLayoutData((Object)gd);
        final IPDEEditorPage targetPage = this.getFormPage().getEditor().getPage("DependenciesPage");
        this.moreButton.setToolTipText(((IFormPage)targetPage).getTitle());
        this.moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequiresSection.this.getFormPage().getEditor().showPage(targetPage);
            }
        });
        return container;
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        model.addModelChangedListener((IModelChangedListener)this);
        this.needsUpdate = true;
        this.update(true);
    }

    public void linkActivated(Control linkLabel) {
        IPlugin pluginInfo = (IPlugin)linkLabel.getData();
        if (pluginInfo == null) {
            return;
        }
        ManifestEditor.openPluginEditor(pluginInfo.getId());
    }

    public void linkEntered(Control linkLabel) {
        IPlugin plugin = (IPlugin)linkLabel.getData();
        if (plugin == null) {
            return;
        }
        IPluginModelBase model = plugin.getModel();
        String location = model.getInstallLocation();
        if (location == null) {
            return;
        }
        location = location.replace('\\', '/');
        String status = "file://" + location + "/" + "plugin.xml";
        IStatusLineManager manager = this.getFormPage().getEditor().getStatusLineManager();
        if (manager != null) {
            manager.setMessage(status);
        }
    }

    public void linkExited(Control linkLabel) {
        IStatusLineManager manager = this.getFormPage().getEditor().getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        int type = event.getChangeType();
        if (type == 99) {
            this.needsUpdate = true;
        } else {
            Object[] objects = event.getChangedObjects();
            if (objects[0] instanceof IPluginImport) {
                this.needsUpdate = true;
            }
        }
        if (this.getFormPage().isVisible()) {
            this.update();
        }
    }

    public void update() {
        if (this.needsUpdate) {
            this.update(true);
        }
    }

    private void update(boolean freshUpdate) {
        if (freshUpdate) {
            Control[] children = this.requiresParent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginImport[] imports = model.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            this.addImportLink(imports[i]);
            ++i;
        }
        if (freshUpdate) {
            this.requiresParent.layout(true);
            this.requiresParent.redraw();
        }
        this.needsUpdate = false;
    }
}

